/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library.internal.media.AudioPlayer;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.PermissionsUtils;
import com.instabug.library.util.PlaceHolderUtils;
import java.util.Timer;
import java.util.TimerTask;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public class InstabugAudioRecordingFragment
extends Fragment
implements View.OnClickListener,
View.OnTouchListener {
    private static final String EXTRA_FILE_PATH = "com.instabug.library.audio_attachment_path";
    private ImageView mRecordButtonBackground;
    private boolean mIsRecordingActive;
    private ImageView mRecordButtonIcon;
    private PorterDuffColorFilter mColorFilter;
    private Timer mRecordingTimer;
    private com.instabug.library.internal.media.a mRecorder;
    private int mCurrentTime;
    private TimerTask mTimerTask;
    private TextView timerTextView;
    private TextView titleTextView;
    private boolean mIsRecordingPermissionGranted;
    private boolean isFirstPermissionRequested;
    private Callbacks listener;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public InstabugAudioRecordingFragment() {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        this.mIsRecordingActive = false;
        blArray[0] = true;
        this.mTimerTask = new a(this);
        this.isFirstPermissionRequested = false;
        blArray[1] = true;
    }

    public static InstabugAudioRecordingFragment newInstance(String string2) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        InstabugAudioRecordingFragment instabugAudioRecordingFragment = new InstabugAudioRecordingFragment();
        blArray[2] = true;
        Bundle bundle = new Bundle();
        blArray[3] = true;
        bundle.putString(EXTRA_FILE_PATH, string2);
        blArray[4] = true;
        instabugAudioRecordingFragment.setArguments(bundle);
        blArray[5] = true;
        return instabugAudioRecordingFragment;
    }

    public static InstabugAudioRecordingFragment newInstance(String string2, Callbacks callbacks) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        InstabugAudioRecordingFragment instabugAudioRecordingFragment = InstabugAudioRecordingFragment.newInstance(string2);
        instabugAudioRecordingFragment.listener = callbacks;
        blArray[6] = true;
        return instabugAudioRecordingFragment;
    }

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        this.mIsRecordingPermissionGranted = false;
        blArray[7] = true;
        this.mRecordingTimer = new Timer();
        blArray[8] = true;
        this.mRecorder = new com.instabug.library.internal.media.a(this.getArguments().getString(EXTRA_FILE_PATH));
        blArray[9] = true;
        View view = layoutInflater.inflate(R.layout.instabug_lyt_record_audio, viewGroup, false);
        blArray[10] = true;
        view.findViewById(R.id.instabug_btn_record_audio).setOnTouchListener((View.OnTouchListener)this);
        blArray[11] = true;
        this.mRecordButtonBackground = (ImageView)view.findViewById(R.id.instabug_bk_record_audio);
        blArray[12] = true;
        this.mRecordButtonIcon = (ImageView)view.findViewById(R.id.instabug_img_record_audio);
        blArray[13] = true;
        this.mColorFilter = new PorterDuffColorFilter(SettingsManager.getInstance().getPrimaryColor(), PorterDuff.Mode.SRC_IN);
        blArray[14] = true;
        this.mRecordButtonBackground.setColorFilter((ColorFilter)this.mColorFilter);
        blArray[15] = true;
        this.mRecordButtonIcon.setColorFilter((ColorFilter)this.mColorFilter);
        blArray[16] = true;
        this.timerTextView = (TextView)view.findViewById(R.id.instabug_txt_timer);
        blArray[17] = true;
        this.timerTextView.setTextColor(Instabug.getPrimaryColor());
        blArray[18] = true;
        this.timerTextView.setText((CharSequence)String.format("00:%02d", 0));
        blArray[19] = true;
        this.titleTextView = (TextView)view.findViewById(R.id.instabug_txt_recording_title);
        blArray[20] = true;
        blArray[21] = true;
        this.titleTextView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.VOICE_MESSAGE_PRESS_AND_HOLD_TO_RECORD, this.getString(R.string.instabug_str_hold_to_record)));
        blArray[22] = true;
        view.findViewById(R.id.instabug_recording_audio_dialog_container).setOnClickListener((View.OnClickListener)this);
        blArray[23] = true;
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle bundle) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        super.onViewCreated(view, bundle);
        blArray[24] = true;
        this.requestAudioRecordingPermission();
        blArray[25] = true;
    }

    public void onDetach() {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        super.onDetach();
        this.listener = null;
        blArray[26] = true;
    }

    private void requestAudioRecordingPermission() {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        PermissionsUtils.requestPermission(this, "android.permission.RECORD_AUDIO", 1, new Runnable(this){
            final /* synthetic */ InstabugAudioRecordingFragment a;
            private static transient /* synthetic */ boolean[] b;
            {
                boolean[] blArray = 1.a();
                this.a = instabugAudioRecordingFragment;
                blArray[0] = true;
            }

            @Override
            public void run() {
                boolean[] blArray = 1.a();
                if (InstabugAudioRecordingFragment.access$000(this.a)) {
                    blArray[1] = true;
                    InstabugSDKLogger.d((Object)this.a, "Shouldn't try to explain why get this permission, either first time or never again selected OR permission not in manifest");
                    blArray[2] = true;
                    blArray[3] = true;
                    Toast.makeText((Context)this.a.getContext(), (CharSequence)InstabugAudioRecordingFragment.access$100(this.a), (int)0).show();
                    blArray[4] = true;
                    Instabug.setShouldAudioRecordingOptionAppear(false);
                    blArray[5] = true;
                } else {
                    InstabugAudioRecordingFragment.access$002(this.a, true);
                    blArray[6] = true;
                }
                blArray[7] = true;
            }

            private static /* synthetic */ boolean[] a() {
                boolean[] blArray = b;
                if (b == null) {
                    blArray = b = Offline.getProbes((long)-3411964095062837395L, (String)"com/instabug/library/InstabugAudioRecordingFragment$1", (int)8);
                }
                return blArray;
            }
        }, new Runnable(this){
            final /* synthetic */ InstabugAudioRecordingFragment a;
            private static transient /* synthetic */ boolean[] b;
            {
                boolean[] blArray = 2.a();
                this.a = instabugAudioRecordingFragment;
                blArray[0] = true;
            }

            @Override
            public void run() {
                boolean[] blArray = 2.a();
                InstabugSDKLogger.d((Object)this.a, "Audio recording permission already granted before");
                blArray[1] = true;
                InstabugAudioRecordingFragment.access$202(this.a, true);
                blArray[2] = true;
            }

            private static /* synthetic */ boolean[] a() {
                boolean[] blArray = b;
                if (b == null) {
                    blArray = b = Offline.getProbes((long)8895779948117440168L, (String)"com/instabug/library/InstabugAudioRecordingFragment$2", (int)3);
                }
                return blArray;
            }
        });
        blArray[27] = true;
    }

    public void onRequestPermissionsResult(int n, @NonNull String[] stringArray, @NonNull int[] nArray) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        switch (n) {
            case 1: {
                if (nArray.length <= 0) {
                    blArray[28] = true;
                } else if (nArray[0] != 0) {
                    blArray[29] = true;
                } else {
                    blArray[30] = true;
                    InstabugSDKLogger.d((Object)this, "Audio recording permission granted by user");
                    this.mIsRecordingPermissionGranted = true;
                    blArray[31] = true;
                    break;
                }
                InstabugSDKLogger.d((Object)this, "Audio recording permission denied by user");
                this.mIsRecordingPermissionGranted = false;
                blArray[32] = true;
                blArray[33] = true;
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getPermissionDeniedMessage(), (int)0).show();
                blArray[34] = true;
                break;
            }
            default: {
                super.onRequestPermissionsResult(n, stringArray, nArray);
                blArray[35] = true;
            }
        }
        blArray[36] = true;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        switch (motionEvent.getAction()) {
            default: {
                blArray[37] = true;
                break;
            }
            case 0: {
                if (this.mIsRecordingActive) {
                    blArray[38] = true;
                } else if (!this.mIsRecordingPermissionGranted) {
                    blArray[39] = true;
                } else {
                    this.mCurrentTime = 0;
                    blArray[40] = true;
                    this.mRecordingTimer.scheduleAtFixedRate(this.mTimerTask, 0L, 1000L);
                    blArray[41] = true;
                    this.mRecorder.a();
                    this.mIsRecordingActive = true;
                    blArray[42] = true;
                    this.setStateActive();
                    blArray[43] = true;
                    blArray[44] = true;
                    this.titleTextView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.VOICE_MESSAGE_RELEASE_TO_ATTACH, this.getString(R.string.instabug_str_release_stop_record)));
                    blArray[45] = true;
                }
                if (this.mIsRecordingPermissionGranted) {
                    blArray[46] = true;
                    break;
                }
                blArray[47] = true;
                this.requestAudioRecordingPermission();
                blArray[48] = true;
                break;
            }
            case 1: 
            case 3: {
                if (!this.mIsRecordingActive) {
                    blArray[49] = true;
                    break;
                }
                if (!this.mIsRecordingPermissionGranted) {
                    blArray[50] = true;
                    break;
                }
                blArray[51] = true;
                if (!this.stopRecording()) {
                    blArray[52] = true;
                    break;
                }
                if (motionEvent.getAction() != 1) {
                    blArray[53] = true;
                    break;
                }
                blArray[54] = true;
                this.finishRecording();
                blArray[55] = true;
                break;
            }
        }
        blArray[56] = true;
        return true;
    }

    private void finishRecording() {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        if (this.listener == null) {
            blArray[57] = true;
        } else {
            blArray[58] = true;
            AudioPlayer audioPlayer = new AudioPlayer();
            blArray[59] = true;
            audioPlayer.getDurationAsync(this.getArguments().getString(EXTRA_FILE_PATH), new AudioPlayer.b(this, audioPlayer){
                final /* synthetic */ AudioPlayer a;
                final /* synthetic */ InstabugAudioRecordingFragment b;
                private static transient /* synthetic */ boolean[] c;
                {
                    boolean[] blArray = 3.a();
                    this.b = instabugAudioRecordingFragment;
                    this.a = audioPlayer;
                    blArray[0] = true;
                }

                @Override
                public void a(int n) {
                    boolean[] blArray = 3.a();
                    this.a.release();
                    blArray[1] = true;
                    InstabugAudioRecordingFragment.access$300(this.b).onAudioRecorded(this.b.getArguments().getString(InstabugAudioRecordingFragment.EXTRA_FILE_PATH), AudioPlayer.getFormattedDurationText(n));
                    blArray[2] = true;
                    InstabugAudioRecordingFragment.access$400(this.b);
                    blArray[3] = true;
                }

                private static /* synthetic */ boolean[] a() {
                    boolean[] blArray = c;
                    if (c == null) {
                        blArray = c = Offline.getProbes((long)-5489599562686201305L, (String)"com/instabug/library/InstabugAudioRecordingFragment$3", (int)4);
                    }
                    return blArray;
                }
            });
            blArray[60] = true;
        }
        blArray[61] = true;
    }

    private boolean stopRecording() {
        block6: {
            block5: {
                boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
                try {
                    this.mTimerTask.cancel();
                    blArray[62] = true;
                    this.mRecordingTimer.cancel();
                    blArray[63] = true;
                    this.mTimerTask = new a(this);
                    blArray[64] = true;
                    this.mRecordingTimer = new Timer();
                    this.mIsRecordingActive = false;
                    blArray[65] = true;
                    this.setStateInactive();
                    blArray[66] = true;
                    this.timerTextView.setText((CharSequence)String.format("00:%02d", 0));
                    blArray[67] = true;
                    blArray[68] = true;
                    this.titleTextView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.VOICE_MESSAGE_PRESS_AND_HOLD_TO_RECORD, this.getString(R.string.instabug_str_hold_to_record)));
                    blArray[69] = true;
                    this.mRecorder.b();
                    if (this.mCurrentTime > 3) break block5;
                    blArray[70] = true;
                    break block6;
                }
                catch (RuntimeException runtimeException) {
                    if (this.mCurrentTime <= 1) {
                        blArray[73] = true;
                    } else {
                        blArray[74] = true;
                        Toast.makeText((Context)this.getActivity(), (CharSequence)"Unknown error occurred", (int)0).show();
                        blArray[75] = true;
                    }
                    InstabugSDKLogger.e((Object)this, "Error capturing audio stream", runtimeException);
                    blArray[76] = true;
                    return false;
                }
            }
            blArray[71] = true;
            return blArray[71];
        }
        boolean bl = false;
        blArray[72] = true;
        return bl;
    }

    private void setStateActive() {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        this.mRecordButtonBackground.setImageResource(R.drawable.instabug_bg_active_record);
        blArray[77] = true;
        Colorizer.applyTint(-65536, this.mRecordButtonBackground);
        blArray[78] = true;
        this.mRecordButtonIcon.setColorFilter(null);
        blArray[79] = true;
        this.timerTextView.setTextColor(-65536);
        blArray[80] = true;
    }

    private void setStateInactive() {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        this.mRecordButtonBackground.setImageResource(R.drawable.instabug_bg_default_record);
        blArray[81] = true;
        this.mRecordButtonBackground.setColorFilter((ColorFilter)this.mColorFilter);
        blArray[82] = true;
        this.mRecordButtonIcon.setColorFilter((ColorFilter)this.mColorFilter);
        blArray[83] = true;
        this.timerTextView.setTextColor(Instabug.getPrimaryColor());
        blArray[84] = true;
    }

    public void onClick(View view) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        if (this.getFragmentManager() == null) {
            blArray[85] = true;
        } else {
            blArray[86] = true;
            FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
            blArray[87] = true;
            fragmentTransaction.remove((Fragment)this).commit();
            blArray[88] = true;
            this.getFragmentManager().popBackStack();
            blArray[89] = true;
        }
        blArray[90] = true;
    }

    private String getPermissionDeniedMessage() {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        blArray[91] = true;
        blArray[92] = true;
        blArray[93] = true;
        return PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.AUDIO_RECORDING_PERMISSION_DENIED, this.getString(R.string.instabug_audio_recorder_permission_denied));
    }

    private void onTimeIsUp() {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        this.finishRecording();
        blArray[94] = true;
    }

    private void removeCurrentFragment() {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        blArray[95] = true;
        blArray[96] = true;
        this.getActivity().getSupportFragmentManager().beginTransaction().remove((Fragment)this).commit();
        blArray[97] = true;
        this.getFragmentManager().popBackStack("Record Audio", 1);
        blArray[98] = true;
    }

    static /* synthetic */ boolean access$000(InstabugAudioRecordingFragment instabugAudioRecordingFragment) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        blArray[99] = true;
        return instabugAudioRecordingFragment.isFirstPermissionRequested;
    }

    static /* synthetic */ String access$100(InstabugAudioRecordingFragment instabugAudioRecordingFragment) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        blArray[100] = true;
        return instabugAudioRecordingFragment.getPermissionDeniedMessage();
    }

    static /* synthetic */ boolean access$002(InstabugAudioRecordingFragment instabugAudioRecordingFragment, boolean bl) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        instabugAudioRecordingFragment.isFirstPermissionRequested = bl;
        blArray[101] = true;
        return instabugAudioRecordingFragment.isFirstPermissionRequested;
    }

    static /* synthetic */ boolean access$202(InstabugAudioRecordingFragment instabugAudioRecordingFragment, boolean bl) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        instabugAudioRecordingFragment.mIsRecordingPermissionGranted = bl;
        blArray[102] = true;
        return instabugAudioRecordingFragment.mIsRecordingPermissionGranted;
    }

    static /* synthetic */ Callbacks access$300(InstabugAudioRecordingFragment instabugAudioRecordingFragment) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        blArray[103] = true;
        return instabugAudioRecordingFragment.listener;
    }

    static /* synthetic */ void access$400(InstabugAudioRecordingFragment instabugAudioRecordingFragment) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        instabugAudioRecordingFragment.removeCurrentFragment();
        blArray[104] = true;
    }

    static /* synthetic */ int access$500(InstabugAudioRecordingFragment instabugAudioRecordingFragment) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        blArray[105] = true;
        return instabugAudioRecordingFragment.mCurrentTime;
    }

    static /* synthetic */ TextView access$600(InstabugAudioRecordingFragment instabugAudioRecordingFragment) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        blArray[106] = true;
        return instabugAudioRecordingFragment.timerTextView;
    }

    static /* synthetic */ void access$700(InstabugAudioRecordingFragment instabugAudioRecordingFragment) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        instabugAudioRecordingFragment.onTimeIsUp();
        blArray[107] = true;
    }

    static /* synthetic */ int access$508(InstabugAudioRecordingFragment instabugAudioRecordingFragment) {
        boolean[] blArray = InstabugAudioRecordingFragment.$jacocoInit();
        blArray[108] = true;
        return instabugAudioRecordingFragment.mCurrentTime++;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)2619185719021906158L, (String)"com/instabug/library/InstabugAudioRecordingFragment", (int)109);
        }
        return blArray;
    }

    class a
    extends TimerTask {
        final /* synthetic */ InstabugAudioRecordingFragment a;
        private static transient /* synthetic */ boolean[] b;

        a(InstabugAudioRecordingFragment instabugAudioRecordingFragment) {
            boolean[] blArray = com.instabug.library.InstabugAudioRecordingFragment$a.a();
            this.a = instabugAudioRecordingFragment;
            blArray[0] = true;
        }

        @Override
        public void run() {
            boolean[] blArray = com.instabug.library.InstabugAudioRecordingFragment$a.a();
            this.a.getActivity().runOnUiThread(new Runnable(this){
                final /* synthetic */ a a;
                private static transient /* synthetic */ boolean[] b;
                {
                    boolean[] blArray = 1.a();
                    this.a = a2;
                    blArray[0] = true;
                }

                @Override
                public void run() {
                    boolean[] blArray = 1.a();
                    if (InstabugAudioRecordingFragment.access$500(this.a.a) >= 50) {
                        blArray[1] = true;
                        InstabugAudioRecordingFragment.access$600(this.a.a).setTextColor(Instabug.getPrimaryColor());
                        blArray[2] = true;
                    } else {
                        InstabugAudioRecordingFragment.access$600(this.a.a).setTextColor(-65536);
                        blArray[3] = true;
                    }
                    if (InstabugAudioRecordingFragment.access$500(this.a.a) != 60) {
                        blArray[4] = true;
                    } else {
                        blArray[5] = true;
                        InstabugAudioRecordingFragment.access$700(this.a.a);
                        blArray[6] = true;
                    }
                    InstabugAudioRecordingFragment.access$600(this.a.a).setText((CharSequence)AudioPlayer.getFormattedDurationText(InstabugAudioRecordingFragment.access$500(this.a.a) * 1000));
                    blArray[7] = true;
                    InstabugAudioRecordingFragment.access$508(this.a.a);
                    blArray[8] = true;
                }

                private static /* synthetic */ boolean[] a() {
                    boolean[] blArray = b;
                    if (b == null) {
                        blArray = b = Offline.getProbes((long)-6886355171690798470L, (String)"com/instabug/library/InstabugAudioRecordingFragment$AudioTimerTask$1", (int)9);
                    }
                    return blArray;
                }
            });
            blArray[1] = true;
        }

        private static /* synthetic */ boolean[] a() {
            boolean[] blArray = b;
            if (b == null) {
                blArray = b = Offline.getProbes((long)-5742254460656702548L, (String)"com/instabug/library/InstabugAudioRecordingFragment$AudioTimerTask", (int)2);
            }
            return blArray;
        }
    }

    public static interface Callbacks {
        public void onAudioRecorded(String var1, String var2);
    }
}

