/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public class DiskUtils {
    private static transient /* synthetic */ boolean[] $jacocoData;

    public DiskUtils() {
        boolean[] blArray = DiskUtils.$jacocoInit();
        blArray[0] = true;
    }

    @Nullable
    public static synchronized Uri zipFiles(Context context, String string2, ArrayList<File> arrayList) {
        boolean[] blArray = DiskUtils.$jacocoInit();
        blArray[1] = true;
        blArray[2] = true;
        InstabugSDKLogger.v(DiskUtils.class, "zipping " + arrayList.size() + " files ... , time in MS:" + System.currentTimeMillis());
        try {
            blArray[3] = true;
            blArray[4] = true;
            File file = new File(AttachmentManager.getAttachmentDirectory(context) + File.separator + string2 + "_" + System.currentTimeMillis() + ".zip");
            blArray[5] = true;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            blArray[6] = true;
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            blArray[7] = true;
            Iterator<File> iterator = arrayList.iterator();
            blArray[8] = true;
            while (iterator.hasNext()) {
                File file2 = iterator.next();
                if (file2 == null) {
                    blArray[9] = true;
                } else {
                    blArray[10] = true;
                    zipOutputStream.putNextEntry(new ZipEntry(file2.getName()));
                    blArray[11] = true;
                    DiskUtils.copy(file2, (OutputStream)zipOutputStream);
                    blArray[12] = true;
                    zipOutputStream.closeEntry();
                    blArray[13] = true;
                }
                blArray[14] = true;
            }
            if (file.length() == 0L) {
                blArray[15] = true;
            } else {
                blArray[16] = true;
                zipOutputStream.close();
                blArray[17] = true;
            }
            blArray[18] = true;
            blArray[19] = true;
            InstabugSDKLogger.v(DiskUtils.class, "zipping files have been finished successfully, path: " + file.getPath() + ", time in MS: " + System.currentTimeMillis());
            blArray[20] = true;
            blArray[21] = true;
            return Uri.fromFile((File)file);
        }
        catch (IOException iOException) {
            blArray[22] = true;
            blArray[23] = true;
            blArray[24] = true;
            InstabugSDKLogger.e(DiskUtils.class, "zipping files went wrong: " + iOException.getMessage() + ", time in MS: " + System.currentTimeMillis(), iOException);
            blArray[25] = true;
            return null;
        }
    }

    private static void copy(File file, OutputStream outputStream) throws IOException {
        boolean[] blArray = DiskUtils.$jacocoInit();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            blArray[26] = true;
            DiskUtils.copy(fileInputStream, outputStream);
            blArray[27] = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            blArray[28] = true;
            InstabugSDKLogger.e(DiskUtils.class, "FileNotFoundException: can not copy file to another stream");
            blArray[29] = true;
        }
        blArray[30] = true;
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        boolean[] blArray = DiskUtils.$jacocoInit();
        byte[] byArray = new byte[2048];
        blArray[31] = true;
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
            blArray[32] = true;
        }
        blArray[33] = true;
    }

    public static ArrayList<File> listFilesInDirectory(File file) {
        boolean[] blArray = DiskUtils.$jacocoInit();
        File[] fileArray = file.listFiles();
        blArray[34] = true;
        List<Object> list = new ArrayList();
        if (fileArray == null) {
            blArray[35] = true;
        } else {
            blArray[36] = true;
            list = Arrays.asList(fileArray);
            blArray[37] = true;
            blArray[38] = true;
            blArray[39] = true;
            blArray[40] = true;
            blArray[41] = true;
            InstabugSDKLogger.v(DiskUtils.class, "listing " + fileArray.length + " files ... at Directory name: " + file.getName() + "Directory path: " + file.getPath() + ", time in MS:" + System.currentTimeMillis());
            blArray[42] = true;
        }
        blArray[43] = true;
        return new ArrayList<File>(list);
    }

    @NonNull
    public static Observable<List<File>> getCleanDirectoryObservable(File file) {
        boolean[] blArray = DiskUtils.$jacocoInit();
        blArray[44] = true;
        blArray[45] = true;
        return Observable.fromCallable((Callable)new Callable<List<File>>(file){
            final /* synthetic */ File a;
            private static transient /* synthetic */ boolean[] b;
            {
                boolean[] blArray = 1.b();
                this.a = file;
                blArray[0] = true;
            }

            public List<File> a() {
                boolean[] blArray = 1.b();
                ArrayList<File> arrayList = new ArrayList<File>();
                blArray[1] = true;
                if (!this.a.exists()) {
                    blArray[2] = true;
                } else if (!this.a.isDirectory()) {
                    blArray[3] = true;
                } else {
                    blArray[4] = true;
                    File[] fileArray = this.a.listFiles();
                    if (fileArray == null) {
                        blArray[5] = true;
                    } else {
                        File[] fileArray2 = fileArray;
                        int n = fileArray2.length;
                        int n2 = 0;
                        blArray[6] = true;
                        while (true) {
                            if (n2 >= n) {
                                blArray[7] = true;
                                break;
                            }
                            File file = fileArray2[n2];
                            blArray[8] = true;
                            if (file.delete()) {
                                blArray[9] = true;
                            } else {
                                blArray[10] = true;
                                arrayList.add(file);
                                blArray[11] = true;
                            }
                            ++n2;
                            blArray[12] = true;
                        }
                    }
                }
                blArray[13] = true;
                return arrayList;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                boolean[] blArray = 1.b();
                blArray[14] = true;
                return this.a();
            }

            private static /* synthetic */ boolean[] b() {
                boolean[] blArray = b;
                if (b == null) {
                    blArray = b = Offline.getProbes((long)1608685003455946576L, (String)"com/instabug/library/util/DiskUtils$1", (int)15);
                }
                return blArray;
            }
        }).subscribeOn(Schedulers.io());
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)3876439126853155024L, (String)"com/instabug/library/util/DiskUtils", (int)46);
        }
        return blArray;
    }
}

