/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.support.annotation.NonNull;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.executor.DeleteOperationExecutor;
import com.instabug.library.internal.storage.executor.ReadOperationExecutor;
import com.instabug.library.internal.storage.executor.WriteOperationExecutor;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public final class DiskUtils {
    private final Context context;
    private static transient /* synthetic */ boolean[] $jacocoData;

    private DiskUtils(Context context) {
        boolean[] blArray = DiskUtils.$jacocoInit();
        this.context = context;
        blArray[0] = true;
    }

    public static File getInstabugDirectory(Context context) {
        String string2;
        block11: {
            block9: {
                block10: {
                    block8: {
                        boolean[] blArray = DiskUtils.$jacocoInit();
                        if (context.getExternalFilesDir(null) != null) break block8;
                        blArray[1] = true;
                        break block9;
                    }
                    blArray[2] = true;
                    if (!Environment.getExternalStorageState().equals("mounted")) break block10;
                    try {
                        blArray[4] = true;
                        string2 = context.getExternalFilesDir(null).getAbsolutePath();
                    }
                    catch (NullPointerException nullPointerException) {
                        blArray[6] = true;
                        string2 = DiskUtils.getInternalStoragePath(context);
                        blArray[7] = true;
                        InstabugSDKLogger.i(AttachmentsUtility.class, "External storage not available, saving file to internal storage.");
                        blArray[8] = true;
                    }
                    blArray[5] = true;
                    break block11;
                    break block11;
                }
                blArray[3] = true;
            }
            string2 = DiskUtils.getInternalStoragePath(context);
            blArray[9] = true;
            InstabugSDKLogger.i(AttachmentsUtility.class, "External storage not available, saving file to internal storage.");
            blArray[10] = true;
        }
        File file = new File(string2 + "/instabug/");
        blArray[11] = true;
        if (file.exists()) {
            blArray[12] = true;
        } else {
            blArray[13] = true;
            if (!file.mkdirs()) {
                blArray[14] = true;
            } else {
                blArray[15] = true;
                File file2 = new File(file, ".nomedia");
                try {
                    blArray[16] = true;
                    file2.createNewFile();
                    blArray[17] = true;
                }
                catch (IOException iOException) {
                    blArray[18] = true;
                    iOException.printStackTrace();
                    blArray[19] = true;
                }
            }
        }
        blArray[20] = true;
        return file;
    }

    private static String getInternalStoragePath(Context context) {
        boolean[] blArray = DiskUtils.$jacocoInit();
        blArray[21] = true;
        return context.getFilesDir().getAbsolutePath();
    }

    public static void saveBitmapOnDisk(Bitmap bitmap, File file) throws IOException {
        boolean[] blArray = DiskUtils.$jacocoInit();
        if (bitmap == null) {
            blArray[22] = true;
        } else if (file == null) {
            blArray[23] = true;
        } else {
            blArray[24] = true;
            blArray[25] = true;
            blArray[26] = true;
            InstabugSDKLogger.v(DiskUtils.class, "starting save viewHierarchy image, path: " + file.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
            blArray[27] = true;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            blArray[28] = true;
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
            blArray[29] = true;
            fileOutputStream.close();
            blArray[30] = true;
            blArray[31] = true;
            blArray[32] = true;
            InstabugSDKLogger.v(DiskUtils.class, "viewHierarchy image saved, path: " + file.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
            blArray[33] = true;
        }
        blArray[34] = true;
    }

    public static void cleanDirectory(File file) {
        boolean[] blArray = DiskUtils.$jacocoInit();
        if (!file.exists()) {
            blArray[35] = true;
        } else if (!file.isDirectory()) {
            blArray[36] = true;
        } else {
            blArray[37] = true;
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                blArray[38] = true;
            } else {
                File[] fileArray2 = fileArray;
                int n = fileArray2.length;
                int n2 = 0;
                blArray[39] = true;
                while (true) {
                    if (n2 >= n) {
                        blArray[40] = true;
                        break;
                    }
                    File file2 = fileArray2[n2];
                    blArray[41] = true;
                    if (!file2.delete()) {
                        blArray[42] = true;
                    } else {
                        blArray[43] = true;
                        blArray[44] = true;
                        blArray[45] = true;
                        blArray[46] = true;
                        InstabugSDKLogger.v(DiskUtils.class, "file deleted successfully, path: " + file2.getPath() + ", time in MS: " + System.currentTimeMillis());
                        blArray[47] = true;
                    }
                    ++n2;
                    blArray[48] = true;
                }
            }
        }
        blArray[49] = true;
    }

    public static void copyFromUriIntoFile(Context context, Uri uri, File file) throws IOException {
        int n;
        boolean[] blArray = DiskUtils.$jacocoInit();
        blArray[50] = true;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(context.getContentResolver().openInputStream(uri));
        blArray[51] = true;
        InstabugSDKLogger.d(AttachmentsUtility.class, "Target file path: " + file.getPath());
        blArray[52] = true;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(context.getContentResolver().openOutputStream(Uri.fromFile((File)file)));
        byte[] byArray = new byte[32768];
        blArray[53] = true;
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            blArray[54] = true;
            bufferedOutputStream.write(byArray, 0, n);
            blArray[55] = true;
        }
        bufferedOutputStream.close();
        blArray[56] = true;
        bufferedInputStream.close();
        blArray[57] = true;
    }

    public static void deleteFile(String string2) {
        boolean[] blArray = DiskUtils.$jacocoInit();
        PoolProvider.postIOTask(new Runnable(string2){
            final /* synthetic */ String a;
            private static transient /* synthetic */ boolean[] b;
            {
                boolean[] blArray = 1.a();
                this.a = string2;
                blArray[0] = true;
            }

            @Override
            public void run() {
                boolean[] blArray = 1.a();
                File file = new File(this.a);
                blArray[1] = true;
                file.delete();
                blArray[2] = true;
            }

            private static /* synthetic */ boolean[] a() {
                boolean[] blArray = b;
                if (b == null) {
                    blArray = b = Offline.getProbes((long)7585285449435524036L, (String)"com/instabug/library/internal/storage/DiskUtils$1", (int)3);
                }
                return blArray;
            }
        });
        blArray[58] = true;
    }

    public static DiskUtils with(Context context) {
        boolean[] blArray = DiskUtils.$jacocoInit();
        blArray[59] = true;
        return new DiskUtils(context);
    }

    public ReadOperationExecutor readOperation(@NonNull DiskOperation<String, Void> diskOperation) {
        boolean[] blArray = DiskUtils.$jacocoInit();
        blArray[60] = true;
        return new ReadOperationExecutor(diskOperation);
    }

    public WriteOperationExecutor writeOperation(@NonNull DiskOperation<Uri, Context> diskOperation) {
        boolean[] blArray = DiskUtils.$jacocoInit();
        blArray[61] = true;
        return new WriteOperationExecutor(this.context, diskOperation);
    }

    public DeleteOperationExecutor deleteOperation(@NonNull DiskOperation<Boolean, Void> diskOperation) {
        boolean[] blArray = DiskUtils.$jacocoInit();
        blArray[62] = true;
        return new DeleteOperationExecutor(diskOperation);
    }

    public static File createStateTextFile(Context context) {
        boolean[] blArray = DiskUtils.$jacocoInit();
        blArray[63] = true;
        blArray[64] = true;
        blArray[65] = true;
        return new File(context.getFilesDir().getAbsolutePath() + File.pathSeparator + "crash_state" + File.pathSeparator + System.currentTimeMillis() + ".txt");
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-839962631641112048L, (String)"com/instabug/library/internal/storage/DiskUtils", (int)66);
        }
        return blArray;
    }
}

