/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.instacapture.screenshot;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import com.instabug.library.instacapture.c.a;
import com.instabug.library.instacapture.c.b;
import com.instabug.library.instacapture.screenshot.FieldHelper;
import com.instabug.library.instacapture.screenshot.RootViewInfo;
import com.instabug.library.util.InstabugSDKLogger;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public final class ScreenshotTaker {
    private static transient /* synthetic */ boolean[] $jacocoData;

    private ScreenshotTaker() {
        boolean[] blArray = ScreenshotTaker.$jacocoInit();
        blArray[0] = true;
    }

    public static Bitmap getScreenshotBitmap(Activity activity, @Nullable @IdRes int[] nArray) {
        Bitmap bitmap;
        boolean[] blArray = ScreenshotTaker.$jacocoInit();
        if (activity == null) {
            blArray[1] = true;
            blArray[2] = true;
            throw new IllegalArgumentException("Parameter activity cannot be null.");
        }
        View view = activity.getWindow().getDecorView();
        blArray[3] = true;
        List<RootViewInfo> list = FieldHelper.getRootViews(activity, nArray);
        blArray[4] = true;
        a.a("viewRoots count: " + list.size());
        try {
            blArray[5] = true;
            if ((long)(view.getWidth() * view.getHeight() * 4) < b.a((Context)activity)) {
                blArray[6] = true;
                bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                blArray[7] = true;
            } else {
                bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
                blArray[8] = true;
            }
        }
        catch (IllegalArgumentException | OutOfMemoryError throwable) {
            blArray[9] = true;
            return null;
        }
        ScreenshotTaker.drawRootsToBitmap(list, bitmap, nArray);
        blArray[10] = true;
        return bitmap;
    }

    private static void drawRootsToBitmap(List<RootViewInfo> list, Bitmap bitmap, @Nullable @IdRes int[] nArray) {
        boolean[] blArray = ScreenshotTaker.$jacocoInit();
        Iterator<RootViewInfo> iterator = list.iterator();
        blArray[11] = true;
        while (iterator.hasNext()) {
            RootViewInfo rootViewInfo = iterator.next();
            blArray[12] = true;
            ScreenshotTaker.drawRootToBitmap(rootViewInfo, bitmap, nArray);
            blArray[13] = true;
        }
        blArray[14] = true;
    }

    private static void drawRootToBitmap(RootViewInfo rootViewInfo, Bitmap bitmap, @Nullable @IdRes int[] nArray) {
        View view;
        int n;
        Canvas canvas;
        boolean[] blArray = ScreenshotTaker.$jacocoInit();
        if ((rootViewInfo.getLayoutParams().flags & 2) != 2) {
            blArray[15] = true;
        } else {
            blArray[16] = true;
            canvas = new Canvas(bitmap);
            blArray[17] = true;
            int n2 = (int)(255.0f * rootViewInfo.getLayoutParams().dimAmount);
            blArray[18] = true;
            canvas.drawARGB(n2, 0, 0, 0);
            blArray[19] = true;
        }
        canvas = new Canvas(bitmap);
        blArray[20] = true;
        canvas.translate((float)rootViewInfo.getLeft(), (float)rootViewInfo.getTop());
        int[] nArray2 = null;
        if (nArray == null) {
            blArray[21] = true;
        } else {
            nArray2 = new int[nArray.length];
            blArray[22] = true;
        }
        if (nArray == null) {
            blArray[23] = true;
        } else {
            n = 0;
            blArray[24] = true;
            while (true) {
                if (n >= nArray.length) {
                    blArray[25] = true;
                    break;
                }
                blArray[26] = true;
                view = rootViewInfo.getView().findViewById(nArray[n]);
                if (view == null) {
                    blArray[27] = true;
                } else {
                    blArray[28] = true;
                    nArray2[n] = view.getVisibility();
                    blArray[29] = true;
                    view.setVisibility(4);
                    blArray[30] = true;
                }
                ++n;
                blArray[31] = true;
            }
        }
        rootViewInfo.getView().draw(canvas);
        blArray[32] = true;
        ScreenshotTaker.drawUnDrawableViews(rootViewInfo.getView(), canvas);
        if (nArray == null) {
            blArray[33] = true;
        } else {
            n = 0;
            blArray[34] = true;
            while (true) {
                if (n >= nArray.length) {
                    blArray[35] = true;
                    break;
                }
                blArray[36] = true;
                view = rootViewInfo.getView().findViewById(nArray[n]);
                if (view == null) {
                    blArray[37] = true;
                } else {
                    blArray[38] = true;
                    view.setVisibility(nArray2[n]);
                    blArray[39] = true;
                }
                ++n;
                blArray[40] = true;
            }
        }
        blArray[41] = true;
    }

    private static ArrayList<View> drawUnDrawableViews(View view, Canvas canvas) {
        boolean[] blArray = ScreenshotTaker.$jacocoInit();
        if (!(view instanceof ViewGroup)) {
            blArray[42] = true;
            ArrayList<View> arrayList = new ArrayList<View>();
            blArray[43] = true;
            arrayList.add(view);
            blArray[44] = true;
            return arrayList;
        }
        ArrayList<View> arrayList = new ArrayList<View>();
        ViewGroup viewGroup = (ViewGroup)view;
        blArray[45] = true;
        blArray[46] = true;
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            blArray[47] = true;
            View view2 = viewGroup.getChildAt(i);
            blArray[48] = true;
            ArrayList<View> arrayList2 = new ArrayList<View>();
            blArray[49] = true;
            arrayList2.add(view);
            blArray[50] = true;
            arrayList2.addAll(ScreenshotTaker.drawUnDrawableViews(view2, canvas));
            int[] nArray = new int[2];
            blArray[51] = true;
            view2.getLocationOnScreen(nArray);
            if (Build.VERSION.SDK_INT < 14) {
                blArray[52] = true;
            } else if (!(view2 instanceof TextureView)) {
                blArray[53] = true;
            } else {
                blArray[54] = true;
                ScreenshotTaker.drawTextureView((TextureView)view2, nArray, canvas);
                blArray[55] = true;
            }
            if (!(view2 instanceof GLSurfaceView)) {
                blArray[56] = true;
            } else {
                blArray[57] = true;
                ScreenshotTaker.drawGLSurfaceView((GLSurfaceView)view2, nArray, canvas);
                blArray[58] = true;
            }
            if (Build.VERSION.SDK_INT < 11) {
                blArray[59] = true;
            } else if (!(view2 instanceof WebView)) {
                blArray[60] = true;
            } else {
                blArray[61] = true;
                ScreenshotTaker.drawWebView((WebView)view2, canvas);
                blArray[62] = true;
            }
            arrayList.addAll(arrayList2);
            blArray[63] = true;
        }
        blArray[64] = true;
        return arrayList;
    }

    public static void drawGLSurfaceView(GLSurfaceView gLSurfaceView, int[] nArray, Canvas canvas) {
        boolean[] blArray = ScreenshotTaker.$jacocoInit();
        a.a("Drawing GLSurfaceView");
        blArray[65] = true;
        if (gLSurfaceView.getWindowToken() == null) {
            blArray[66] = true;
        } else {
            blArray[67] = true;
            int n = gLSurfaceView.getWidth();
            blArray[68] = true;
            int n2 = gLSurfaceView.getHeight();
            boolean bl = false;
            boolean bl2 = false;
            int[] nArray2 = new int[n * (0 + n2)];
            blArray[69] = true;
            IntBuffer intBuffer = IntBuffer.wrap(nArray2);
            blArray[70] = true;
            intBuffer.position(0);
            blArray[71] = true;
            CountDownLatch countDownLatch = new CountDownLatch(1);
            blArray[72] = true;
            gLSurfaceView.queueEvent(new Runnable(n, n2, intBuffer, countDownLatch){
                final /* synthetic */ int a;
                final /* synthetic */ int b;
                final /* synthetic */ IntBuffer c;
                final /* synthetic */ CountDownLatch d;
                private static transient /* synthetic */ boolean[] e;
                {
                    boolean[] blArray = 1.a();
                    this.a = n;
                    this.b = n2;
                    this.c = intBuffer;
                    this.d = countDownLatch;
                    blArray[0] = true;
                }

                @Override
                public void run() {
                    boolean[] blArray = 1.a();
                    EGL10 eGL10 = (EGL10)EGLContext.getEGL();
                    blArray[1] = true;
                    eGL10.eglWaitGL();
                    blArray[2] = true;
                    GL10 gL10 = (GL10)eGL10.eglGetCurrentContext().getGL();
                    blArray[3] = true;
                    gL10.glFinish();
                    try {
                        blArray[4] = true;
                        Thread.sleep(200L);
                        blArray[5] = true;
                    }
                    catch (InterruptedException interruptedException) {
                        blArray[6] = true;
                        interruptedException.printStackTrace();
                        blArray[7] = true;
                    }
                    gL10.glReadPixels(0, 0, this.a, 0 + this.b, 6408, 5121, (Buffer)this.c);
                    blArray[8] = true;
                    this.d.countDown();
                    blArray[9] = true;
                }

                private static /* synthetic */ boolean[] a() {
                    boolean[] blArray = e;
                    if (e == null) {
                        blArray = e = Offline.getProbes((long)4445453993219420787L, (String)"com/instabug/library/instacapture/screenshot/ScreenshotTaker$1", (int)10);
                    }
                    return blArray;
                }
            });
            try {
                blArray[73] = true;
                countDownLatch.await();
                blArray[74] = true;
            }
            catch (InterruptedException interruptedException) {
                blArray[75] = true;
                interruptedException.printStackTrace();
                blArray[76] = true;
            }
            int[] nArray3 = new int[n * n2];
            int n3 = 0;
            int n4 = 0;
            blArray[77] = true;
            while (n3 < n2) {
                blArray[78] = true;
                for (int i = 0; i < n; ++i) {
                    int n5;
                    int n6 = nArray2[n3 * n + i];
                    int n7 = n6 >> 16 & 0xFF;
                    int n8 = n6 << 16 & 0xFF0000;
                    nArray3[(n2 - n4 - 1) * n + i] = n5 = n6 & 0xFF00FF00 | n8 | n7;
                    blArray[79] = true;
                }
                ++n3;
                ++n4;
                blArray[80] = true;
            }
            Bitmap bitmap = Bitmap.createBitmap((int[])nArray3, (int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            blArray[81] = true;
            Paint paint = new Paint();
            blArray[82] = true;
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
            blArray[83] = true;
            canvas.drawBitmap(bitmap, (float)nArray[0], (float)nArray[1], paint);
            blArray[84] = true;
            bitmap.recycle();
            blArray[85] = true;
        }
        blArray[86] = true;
    }

    @TargetApi(value=14)
    public static void drawTextureView(TextureView textureView, int[] nArray, Canvas canvas) {
        boolean[] blArray = ScreenshotTaker.$jacocoInit();
        a.a("Drawing TextureView");
        try {
            blArray[87] = true;
            Bitmap bitmap = textureView.getBitmap();
            if (bitmap == null) {
                blArray[88] = true;
            } else {
                blArray[89] = true;
                Paint paint = new Paint();
                blArray[90] = true;
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
                blArray[91] = true;
                canvas.drawBitmap(bitmap, (float)nArray[0], (float)nArray[1], paint);
                blArray[92] = true;
                bitmap.recycle();
                blArray[93] = true;
            }
            blArray[94] = true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            blArray[95] = true;
            InstabugSDKLogger.e(ScreenshotTaker.class, ScreenshotTaker.class.getSimpleName(), outOfMemoryError);
            blArray[96] = true;
        }
        blArray[97] = true;
    }

    @TargetApi(value=11)
    public static void drawWebView(WebView webView, Canvas canvas) {
        boolean[] blArray = ScreenshotTaker.$jacocoInit();
        int n = webView.getLayerType();
        if (n != 2) {
            blArray[98] = true;
        } else {
            blArray[99] = true;
            webView.setLayerType(0, null);
            blArray[100] = true;
            webView.setDrawingCacheEnabled(true);
            blArray[101] = true;
            webView.buildDrawingCache(true);
            blArray[102] = true;
            Bitmap bitmap = webView.getDrawingCache();
            if (bitmap == null) {
                blArray[103] = true;
            } else {
                blArray[104] = true;
                Paint paint = new Paint();
                blArray[105] = true;
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
                int[] nArray = new int[2];
                blArray[106] = true;
                webView.getLocationOnScreen(nArray);
                blArray[107] = true;
                canvas.drawBitmap(bitmap, (float)nArray[0], (float)nArray[1], paint);
                blArray[108] = true;
                bitmap.recycle();
                blArray[109] = true;
            }
            webView.setDrawingCacheEnabled(false);
            blArray[110] = true;
            webView.setLayerType(n, null);
            blArray[111] = true;
        }
        blArray[112] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)1974664054485497943L, (String)"com/instabug/library/instacapture/screenshot/ScreenshotTaker", (int)113);
        }
        return blArray;
    }
}

