/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class AttachmentsUtility {
    private static final double MAX_FILE_SIZE_IN_MB = 50.0;

    public static File getVideoFile(Context context) {
        File file = AttachmentsUtility.getNewDirectory(context, "videos");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.ENGLISH);
        String string2 = "video-" + simpleDateFormat.format(new Date()) + ".mp4";
        return new File(file, string2);
    }

    public static File getFilesAttachmentDirectory(Context context) {
        return AttachmentsUtility.getNewDirectory(context, "attachments");
    }

    public static File getNewDirectory(Context context, String string2) {
        File file = new File(DiskUtils.getInstabugDirectory(context) + "/" + string2 + "/");
        if (!file.exists() && file.mkdirs()) {
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File getVideoRecordingFramesDirectory(Context context) {
        return AttachmentsUtility.getNewDirectory(context, "frames");
    }

    @Nullable
    public static String getGalleryImagePath(Activity activity, Uri uri) {
        String[] stringArray = new String[]{"_data"};
        Cursor cursor = activity.managedQuery(uri, stringArray, null, null, null);
        if (cursor != null) {
            int n = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            return cursor.getString(n);
        }
        return null;
    }

    @Nullable
    public static Uri getNewFileAttachmentUri(Context context, Uri uri, String string2) {
        File file;
        if (uri == null) {
            return null;
        }
        String string3 = uri.getLastPathSegment().toLowerCase();
        File file2 = AttachmentsUtility.getFilesAttachmentDirectory(context);
        String string4 = string3;
        if (string2 != null && SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(uri)) {
            string4 = string2;
        }
        if ((file = new File(file2, string4)).exists()) {
            file = new File(file2, String.valueOf(System.currentTimeMillis()) + "_" + string4);
        }
        try {
            DiskUtils.copyFromUriIntoFile(context, uri, file);
            if (!AttachmentsUtility.validateFileSize(file, 50.0)) {
                InstabugSDKLogger.i(AttachmentsUtility.class, "Attachment file size exceeds than the limit 50.0");
                return null;
            }
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(AttachmentsUtility.class, iOException.getMessage(), iOException);
            return null;
        }
        return Uri.fromFile((File)file);
    }

    public static Uri getNewFileAttachmentUri(Context context, Uri uri) {
        return AttachmentsUtility.getNewFileAttachmentUri(context, uri, null);
    }

    public static File getAttachmentFile(Context context, String string2) {
        File file = AttachmentsUtility.getFilesAttachmentDirectory(context);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            file2 = new File(file, String.valueOf(System.currentTimeMillis()) + "_" + string2);
        }
        return file2;
    }

    public static Uri getUriFromBytes(Context context, byte[] byArray, String string2) {
        File file = AttachmentsUtility.getAttachmentFile(context, string2);
        try {
            AttachmentsUtility.saveBytesToFile(byArray, file);
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(AttachmentsUtility.class, iOException.getMessage(), iOException);
            return null;
        }
        return Uri.fromFile((File)file);
    }

    private static void saveBytesToFile(byte[] byArray, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    private static boolean validateFileSize(File file, double d2) {
        long l = file.length();
        double d3 = (double)l / 1048576.0;
        InstabugSDKLogger.d(AttachmentsUtility.class, "External attachment file size is " + l + " bytes or " + d3 + " MBs");
        return !(d3 > d2);
    }
}

