/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.analytics;

import com.instabug.library.analytics.model.Api;
import com.instabug.library.analytics.model.SDKEvent;
import com.instabug.library.analytics.util.b;
import com.instabug.library.model.Session;
import com.instabug.library.util.InstabugDateFormatter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import rx.functions.Action1;

@SuppressFBWarnings(value={"URF_UNREAD_FIELD", "DLS_DEAD_LOCAL_STORE", "DLS_DEAD_LOCAL_STORE"})
public class AnalyticsObserver {
    private static final String INVOCATION = "invocation";
    private static final String INVOCATION_EVENT = "invoke_event";
    private static final String INVOCATION_MODE = "invoked_mode";
    private static final String DISMISSING = "dismissing";
    private static final String DISMISSED_VIEW = "dismissed_view";
    private static final String ClICK = "click";
    private static final String VIEW_ID = "view_id";
    private static final String PARENT_VIEW = "parent_view";
    private static final String NOTIFICATION_SHOWN = "notification_shown";
    private static final String NOTIFICATION_CLICKED = "notification_clicked";
    private static final String NOTIFICATION_DISMISSED = "notification_dismissed";
    private static final String IS_AUTO_DISMISSED = "is_auto_dismissed";
    private static final String NOTIFICATION_MESSAGE = "notification_message";
    private static final String SESSION_START = "session_start";
    private static final String SESSION_END = "session_end";
    private static AnalyticsObserver INSTANCE;
    private Action1<Session.SessionState> sessionStateChangedAction = new Action1<Session.SessionState>(){

        public void a(Session.SessionState sessionState) {
            AnalyticsObserver.this.handleAPIsUsageWithSessionStateChanged(sessionState);
            b.a();
        }

        public /* synthetic */ void call(Object object) {
            this.a((Session.SessionState)((Object)object));
        }
    };
    private LinkedHashMap<String, Api> loggingApisLinkedHashMap = new LinkedHashMap();
    private List<Api> sdkApisArrayList = Collections.synchronizedList(new ArrayList());

    public static AnalyticsObserver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AnalyticsObserver();
        }
        return INSTANCE;
    }

    private AnalyticsObserver() {
    }

    public void catchApiUsage(Api.Parameter ... parameterArray) {
        String string = this.getCallerMethodName();
        this.catchApiUsage(string, false, parameterArray);
    }

    public void catchDeprecatedApiUsage(Api.Parameter ... parameterArray) {
        String string = this.getCallerMethodName();
        this.catchApiUsage(string, true, parameterArray);
    }

    public void catchLoggingApiUsage(Api.Parameter ... parameterArray) {
        String string = this.getCallerMethodName();
        this.catchLoggingApiUsage(string, false, parameterArray);
    }

    public void catchDeprecatedLoggingApiUsage(Api.Parameter ... parameterArray) {
        String string = this.getCallerMethodName();
        this.catchLoggingApiUsage(string, true, parameterArray);
    }

    private void catchApiUsage(String string, boolean bl, Api.Parameter ... parameterArray) {
        this.sdkApisArrayList.add(this.createApiUsageInfo(string, bl, parameterArray));
    }

    private void catchLoggingApiUsage(String string, boolean bl, Api.Parameter ... parameterArray) {
        this.loggingApisLinkedHashMap.put(string, this.createApiUsageInfo(string, bl, parameterArray));
    }

    private Api createApiUsageInfo(String string, boolean bl, Api.Parameter ... parameterArray) {
        Api api = new Api();
        api.setApiName(string);
        api.setDeprecated(bl);
        ArrayList<Api.Parameter> arrayList = parameterArray != null ? new ArrayList<Api.Parameter>(Arrays.asList(parameterArray)) : new ArrayList();
        api.setParameters(arrayList);
        return api;
    }

    private String getCallerMethodName() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        return stackTraceElementArray[4].getMethodName();
    }

    private void handleAPIsUsageWithSessionStateChanged(Session.SessionState sessionState) {
        if (sessionState == Session.SessionState.FINISH) {
            for (Api api : this.sdkApisArrayList) {
            }
            this.sdkApisArrayList.clear();
            for (Api api : this.loggingApisLinkedHashMap.values()) {
            }
            this.loggingApisLinkedHashMap.clear();
        }
    }

    public void catchSDKDismissing(String string) {
        SDKEvent.ExtraAttribute extraAttribute = new SDKEvent.ExtraAttribute().setKey(DISMISSED_VIEW).setValue(string);
        this.catchEventInfo(DISMISSING, extraAttribute);
    }

    public void catchUIClickingEvent(String string, String string2) {
        SDKEvent.ExtraAttribute extraAttribute = new SDKEvent.ExtraAttribute().setKey(VIEW_ID).setValue(string);
        SDKEvent.ExtraAttribute extraAttribute2 = new SDKEvent.ExtraAttribute().setKey(PARENT_VIEW).setValue(string2);
        this.catchEventInfo(ClICK, extraAttribute, extraAttribute2);
    }

    public void catchNotificationShowing(String string) {
        SDKEvent.ExtraAttribute extraAttribute = new SDKEvent.ExtraAttribute().setKey(NOTIFICATION_MESSAGE).setValue(string);
        this.catchEventInfo(NOTIFICATION_SHOWN, extraAttribute);
    }

    public void catchNotificationClicking() {
        this.catchEventInfo(NOTIFICATION_CLICKED, new SDKEvent.ExtraAttribute[0]);
    }

    public void catchNotificationDismissing(Boolean bl) {
        SDKEvent.ExtraAttribute extraAttribute = new SDKEvent.ExtraAttribute().setKey(IS_AUTO_DISMISSED).setValue(Boolean.toString(bl));
        this.catchEventInfo(NOTIFICATION_DISMISSED, extraAttribute);
    }

    public void catchSessionStart() {
        this.catchEventInfo(SESSION_START, new SDKEvent.ExtraAttribute[0]);
    }

    public void catchSessionEnd() {
        this.catchEventInfo(SESSION_END, new SDKEvent.ExtraAttribute[0]);
    }

    public void catchEventInfo(String string, SDKEvent.ExtraAttribute ... extraAttributeArray) {
        String string2 = String.valueOf(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
        ArrayList<SDKEvent.ExtraAttribute> arrayList = extraAttributeArray != null ? new ArrayList<SDKEvent.ExtraAttribute>(Arrays.asList(extraAttributeArray)) : new ArrayList<SDKEvent.ExtraAttribute>();
        String string3 = SDKEvent.ExtraAttribute.toJson(arrayList).toString();
    }
}

