/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.app.ProgressDialog;
import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.MediaController;
import android.widget.VideoView;
import com.instabug.library.Feature;
import com.instabug.library.InstabugBaseFragment;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library.b;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.PlaceHolderUtils;

public class VideoPlayerFragment
extends InstabugBaseFragment {
    public static final String VIDEO_PATH = "video.uri";
    public static final String TAG = "video_player_fragment";
    private VideoView videoView;
    private int position = 0;
    private ProgressDialog progressDialog;
    private MediaController mediaControls;
    private String videoUri;

    public static VideoPlayerFragment newInstance(String string2) {
        VideoPlayerFragment videoPlayerFragment = new VideoPlayerFragment();
        Bundle bundle = new Bundle();
        bundle.putString(VIDEO_PATH, string2);
        videoPlayerFragment.setArguments(bundle);
        return videoPlayerFragment;
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_lyt_video_view;
    }

    @Override
    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.videoView = (VideoView)view.findViewById(R.id.video_view);
        if (b.a().b(Feature.WHITE_LABELING) == Feature.State.DISABLED) {
            this.getActivity().findViewById(R.id.instabug_pbi_footer).setVisibility(8);
        }
    }

    public void onActivityCreated(@Nullable Bundle bundle) {
        super.onActivityCreated(bundle);
        if (this.mediaControls == null) {
            this.mediaControls = new MediaController((Context)this.getActivity());
        }
        this.progressDialog = new ProgressDialog((Context)this.getActivity());
        this.progressDialog.setMessage((CharSequence)"Loading...");
        this.progressDialog.setCancelable(false);
        this.progressDialog.show();
        try {
            this.videoView.setMediaController(this.mediaControls);
            this.videoView.setVideoURI(Uri.parse((String)this.videoUri));
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((Object)this, exception.getMessage(), exception);
        }
        this.videoView.requestFocus();
        this.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                VideoPlayerFragment.this.progressDialog.dismiss();
                VideoPlayerFragment.this.videoView.seekTo(VideoPlayerFragment.this.position);
                if (VideoPlayerFragment.this.position == 0) {
                    VideoPlayerFragment.this.videoView.start();
                } else {
                    VideoPlayerFragment.this.videoView.pause();
                }
            }
        });
        this.videoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
                VideoPlayerFragment.this.progressDialog.dismiss();
                return false;
            }
        });
    }

    @Override
    protected String getTitle() {
        return PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.VIDEO_PLAYER_TITLE, this.getString(R.string.instabug_str_video_player));
    }

    @Override
    protected void consumeNewInstanceSavedArguments() {
        this.videoUri = this.getArguments().getString(VIDEO_PATH);
    }

    @Override
    protected void restoreState(Bundle bundle) {
        this.position = bundle.getInt("Position");
        this.videoView.seekTo(this.position);
    }

    @Override
    protected void saveState(Bundle bundle) {
        bundle.putInt("Position", this.videoView.getCurrentPosition());
        this.videoView.pause();
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (b.a().b(Feature.WHITE_LABELING) == Feature.State.DISABLED) {
            this.getActivity().findViewById(R.id.instabug_pbi_footer).setVisibility(0);
        }
    }
}

