/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.bugreporting.network;

import android.content.Context;
import com.instabug.library.bugreporting.BugsCacheManager;
import com.instabug.library.bugreporting.model.Bug;
import com.instabug.library.bugreporting.network.a;
import com.instabug.library.network.InstabugNetworkBasedBackgroundService;
import com.instabug.library.network.Request;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.json.JSONException;

public class InstabugBugsUploaderService
extends InstabugNetworkBasedBackgroundService {
    @Override
    protected void runBackgroundTask() throws Exception {
        this.a();
    }

    private void a() throws IOException, JSONException {
        InstabugSDKLogger.d((Object)this, "Found " + BugsCacheManager.getBugs().size() + " bugs in cache");
        for (final Bug bug : BugsCacheManager.getBugs()) {
            if (bug.g().equals((Object)Bug.BugState.READY_TO_BE_SENT)) {
                InstabugSDKLogger.d((Object)this, "Uploading bug: " + bug.toString());
                a.a().a((Context)this, bug, new Request.Callbacks<String, Throwable>(){

                    public void a(String string) {
                        InstabugSDKLogger.d((Object)InstabugBugsUploaderService.this, "Bug uploaded successfully, setting bug TemporaryServerToken equal " + string);
                        bug.b(string);
                        bug.a(Bug.BugState.LOGS_READY_TO_BE_UPLOADED);
                        BugsCacheManager.saveCacheToDisk();
                        InstabugBugsUploaderService.this.a(bug);
                    }

                    public void a(Throwable throwable) {
                        InstabugSDKLogger.d((Object)InstabugBugsUploaderService.this, "Something went wrong while uploading bug");
                    }

                    @Override
                    public /* synthetic */ void onFailed(Object object) {
                        this.a((Throwable)object);
                    }

                    @Override
                    public /* synthetic */ void onSucceeded(Object object) {
                        this.a((String)object);
                    }
                });
                continue;
            }
            if (bug.g().equals((Object)Bug.BugState.LOGS_READY_TO_BE_UPLOADED)) {
                InstabugSDKLogger.d((Object)this, "Bug: " + bug.toString() + " already uploaded but has unsent logs, uploading now");
                this.a(bug);
                continue;
            }
            if (!bug.g().equals((Object)Bug.BugState.ATTACHMENTS_READY_TO_BE_UPLOADED)) continue;
            InstabugSDKLogger.d((Object)this, "Bug: " + bug.toString() + " already uploaded but has unsent attachments, uploading now");
            this.b(bug);
        }
    }

    private void a(final Bug bug) {
        InstabugSDKLogger.d((Object)this, "Start uploading all logs related to this bug id = " + bug.a());
        a.a().c((Context)this, bug, new Request.Callbacks<Boolean, Bug>(){

            public void a(Boolean bl) {
                InstabugSDKLogger.d((Object)InstabugBugsUploaderService.this, "Bug logs uploaded successfully, change its state");
                bug.a(Bug.BugState.ATTACHMENTS_READY_TO_BE_UPLOADED);
                BugsCacheManager.saveCacheToDisk();
                try {
                    InstabugBugsUploaderService.this.b(bug);
                }
                catch (FileNotFoundException | JSONException throwable) {
                    InstabugSDKLogger.e((Object)InstabugBugsUploaderService.this, "Something went wrong while uploading bug attachments e: " + throwable.getMessage());
                }
            }

            public void a(Bug bug2) {
                InstabugSDKLogger.d((Object)InstabugBugsUploaderService.this, "Something went wrong while uploading bug logs");
            }

            @Override
            public /* synthetic */ void onFailed(Object object) {
                this.a((Bug)object);
            }

            @Override
            public /* synthetic */ void onSucceeded(Object object) {
                this.a((Boolean)object);
            }
        });
    }

    private void b(final Bug bug) throws JSONException, FileNotFoundException {
        InstabugSDKLogger.d((Object)this, "Found " + bug.e().size() + " attachments related to bug: " + bug.d());
        a.a().b((Context)this, bug, new Request.Callbacks<Boolean, Bug>(){

            public void a(Boolean bl) {
                InstabugSDKLogger.d((Object)InstabugBugsUploaderService.this, "Bug attachments uploaded successfully, deleting bug");
                BugsCacheManager.deleteBug(bug.a());
                BugsCacheManager.saveCacheToDisk();
            }

            public void a(Bug bug2) {
                InstabugSDKLogger.d((Object)InstabugBugsUploaderService.this, "Something went wrong while uploading bug attachments");
            }

            @Override
            public /* synthetic */ void onFailed(Object object) {
                this.a((Bug)object);
            }

            @Override
            public /* synthetic */ void onSucceeded(Object object) {
                this.a((Boolean)object);
            }
        });
    }
}

