/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.analytics;

import com.instabug.library.analytics.model.Api;
import com.instabug.library.analytics.model.a;
import com.instabug.library.analytics.util.b;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InstabugInvocationMode;
import com.instabug.library.invocation.c;
import com.instabug.library.model.Session;
import com.instabug.library.util.InstabugDateFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import rx.functions.Action1;

public class AnalyticsObserver {
    private static final String INVOCATION = "invocation";
    private static final String INVOCATION_EVENT = "invoke_event";
    private static final String INVOCATION_MODE = "invoked_mode";
    private static final String DISMISSING = "dismissing";
    private static final String DISMISSED_VIEW = "dismissed_view";
    private static final String ClICK = "click";
    private static final String VIEW_ID = "view_id";
    private static final String PARENT_VIEW = "parent_view";
    private static final String NOTIFICATION_SHOWN = "notification_shown";
    private static final String NOTIFICATION_CLICKED = "notification_clicked";
    private static final String NOTIFICATION_DISMISSED = "notification_dismissed";
    private static final String IS_AUTO_DISMISSED = "is_auto_dismissed";
    private static final String NOTIFICATION_MESSAGE = "notification_message";
    private static final String SESSION_START = "session_start";
    private static final String SESSION_END = "session_end";
    private static AnalyticsObserver INSTANCE;
    private Action1<Session.SessionState> sessionStateChangedAction = new Action1<Session.SessionState>(){

        public void a(Session.SessionState sessionState) {
            AnalyticsObserver.this.handleAPIsUsageWithSessionStateChanged(sessionState);
            b.a();
        }

        public /* synthetic */ void call(Object object) {
            this.a((Session.SessionState)((Object)object));
        }
    };
    private LinkedHashMap<String, Api> loggingApisLinkedHashMap = new LinkedHashMap();
    private List<Api> sdkApisArrayList = Collections.synchronizedList(new ArrayList());

    public static AnalyticsObserver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AnalyticsObserver();
        }
        return INSTANCE;
    }

    private AnalyticsObserver() {
    }

    public void catchApiUsage(Api.Parameter ... parameterArray) {
        String string = this.getCallerMethodName();
        this.catchApiUsage(string, false, parameterArray);
    }

    public void catchDeprecatedApiUsage(Api.Parameter ... parameterArray) {
        String string = this.getCallerMethodName();
        this.catchApiUsage(string, true, parameterArray);
    }

    public void catchLoggingApiUsage(Api.Parameter ... parameterArray) {
        String string = this.getCallerMethodName();
        this.catchLoggingApiUsage(string, false, parameterArray);
    }

    public void catchDeprecatedLoggingApiUsage(Api.Parameter ... parameterArray) {
        String string = this.getCallerMethodName();
        this.catchLoggingApiUsage(string, true, parameterArray);
    }

    private void catchApiUsage(String string, boolean bl, Api.Parameter ... parameterArray) {
        this.sdkApisArrayList.add(this.createApiUsageInfo(string, bl, parameterArray));
    }

    private void catchLoggingApiUsage(String string, boolean bl, Api.Parameter ... parameterArray) {
        this.loggingApisLinkedHashMap.put(string, this.createApiUsageInfo(string, bl, parameterArray));
    }

    private Api createApiUsageInfo(String string, boolean bl, Api.Parameter ... parameterArray) {
        Api api = new Api();
        api.setApiName(string);
        api.setDeprecated(bl);
        ArrayList<Api.Parameter> arrayList = parameterArray != null ? new ArrayList<Api.Parameter>(Arrays.asList(parameterArray)) : new ArrayList();
        api.setParameters(arrayList);
        return api;
    }

    private String getCallerMethodName() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        return stackTraceElementArray[4].getMethodName();
    }

    private void handleAPIsUsageWithSessionStateChanged(Session.SessionState sessionState) {
        if (sessionState == Session.SessionState.Finish) {
            for (Api api : this.sdkApisArrayList) {
            }
            this.sdkApisArrayList.clear();
            for (Api api : this.loggingApisLinkedHashMap.values()) {
            }
            this.loggingApisLinkedHashMap.clear();
        }
    }

    public void catchSDKInvocation(c c2, InstabugInvocationEvent instabugInvocationEvent) {
        a.a a2 = new a.a().a(INVOCATION_EVENT).b(instabugInvocationEvent.toString());
        a.a a3 = new a.a().a(INVOCATION_MODE);
        if (c2.a() != null) {
            a3.b(c2.a().toString());
        } else if (c2.b().a() && !c2.b().b() && !c2.b().c()) {
            a3.b(InstabugInvocationMode.CHATS_LIST.toString());
        } else if (!c2.b().a() && c2.b().b() && !c2.b().c()) {
            a3.b(InstabugInvocationMode.NEW_BUG.toString());
        } else if (!c2.b().a() && !c2.b().b() && c2.b().c()) {
            a3.b(InstabugInvocationMode.NEW_FEEDBACK.toString());
        } else if (!(c2.b().a() || c2.b().b() || c2.b().c())) {
            a3.b(InstabugInvocationMode.NEW_BUG.toString());
        } else {
            a3.b(InstabugInvocationMode.PROMPT_OPTION.toString());
        }
        this.catchEventInfo(INVOCATION, a2, a3);
    }

    public void catchSDKDismissing(String string) {
        a.a a2 = new a.a().a(DISMISSED_VIEW).b(string);
        this.catchEventInfo(DISMISSING, a2);
    }

    public void catchUIClickingEvent(String string, String string2) {
        a.a a2 = new a.a().a(VIEW_ID).b(string);
        a.a a3 = new a.a().a(PARENT_VIEW).b(string2);
        this.catchEventInfo(ClICK, a2, a3);
    }

    public void catchNotificationShowing(String string) {
        a.a a2 = new a.a().a(NOTIFICATION_MESSAGE).b(string);
        this.catchEventInfo(NOTIFICATION_SHOWN, a2);
    }

    public void catchNotificationClicking() {
        this.catchEventInfo(NOTIFICATION_CLICKED, new a.a[0]);
    }

    public void catchNotificationDismissing(Boolean bl) {
        a.a a2 = new a.a().a(IS_AUTO_DISMISSED).b(Boolean.toString(bl));
        this.catchEventInfo(NOTIFICATION_DISMISSED, a2);
    }

    public void catchSessionStart() {
        this.catchEventInfo(SESSION_START, new a.a[0]);
    }

    public void catchSessionEnd() {
        this.catchEventInfo(SESSION_END, new a.a[0]);
    }

    public void catchEventInfo(String string, a.a ... aArray) {
        String string2 = String.valueOf(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
        ArrayList<a.a> arrayList = aArray != null ? new ArrayList<a.a>(Arrays.asList(aArray)) : new ArrayList<a.a>();
        String string3 = a.a.a(arrayList).toString();
    }
}

