/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.tracking;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.view.MotionEvent;
import com.instabug.library.Feature;
import com.instabug.library._InstabugActivity;
import com.instabug.library.g;
import com.instabug.library.model.g;
import com.instabug.library.tracking.a;
import com.instabug.library.tracking.c;
import com.instabug.library.tracking.e;
import com.instabug.library.tracking.f;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.Serializable;
import java.lang.ref.WeakReference;

public class InstabugInternalTrackingDelegate {
    private static InstabugInternalTrackingDelegate INSTANCE;
    public static final String CURRENT_ACTIVITY_LIFECYCLE_CHANGED = "current_activity_lifecycle_changed";
    public static final String ACTIVITY_LIFECYCLE_EVENT = "activity_lifecycle_event";
    private WeakReference<Activity> currentActivity;

    public static void init(Application application) {
        if (INSTANCE == null) {
            INSTANCE = new InstabugInternalTrackingDelegate(application);
        }
    }

    public static InstabugInternalTrackingDelegate getInstance() {
        return INSTANCE;
    }

    private InstabugInternalTrackingDelegate(Application application) {
        if (application != null) {
            this.registerActivityLifecycleListener(application);
        }
    }

    public void onApplicationCreated(Application application) {
        if (this.isUserTrackingStepsEnable()) {
            InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, application.getClass().getSimpleName() + " created");
            f.a().a(application.getClass().getName(), g.a.c);
        }
    }

    public void onActivityCreated(Activity activity) {
        if (this.beforeICS()) {
            this.handleActivityCreatedEvent(activity);
        }
    }

    void handleActivityCreatedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " created");
                f.a().a(activity.getClass().getName(), g.a.d);
            }
            this.sendActivityLifeCycleLocaleBroadcast((Context)activity, (Serializable)((Object)a.a));
        }
    }

    public void onActivityStarted(Activity activity) {
        if (this.beforeICS()) {
            this.handleActivityStartedEvent(activity);
        }
    }

    void handleActivityStartedEvent(Activity activity) {
        if (this.isUserTrackingStepsEnable() && this.isNotInstabugActivity(activity)) {
            InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " started");
            f.a().a(activity.getClass().getName(), g.a.e);
        }
        this.sendActivityLifeCycleLocaleBroadcast((Context)activity, (Serializable)((Object)a.b));
    }

    public void onActivityResumed(Activity activity) {
        if (this.beforeICS()) {
            this.handleActivityResumedEvent(activity);
        }
    }

    void handleActivityResumedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            this.currentActivity = new WeakReference<Activity>(activity);
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " resumed");
                f.a().a(activity.getClass().getName(), g.a.f);
            }
            this.sendActivityLifeCycleLocaleBroadcast((Context)activity, (Serializable)((Object)a.c));
        }
    }

    public void onActivityPaused(Activity activity) {
        if (this.beforeICS()) {
            this.handleActivityPausedEvent(activity);
        }
    }

    void handleActivityPausedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.currentActivity == null) {
                InstabugSDKLogger.w(this, "No activity was set earlier than this call. Doing nothing");
                return;
            }
            if (!activity.equals(this.currentActivity.get())) {
                InstabugSDKLogger.w(this, "You're trying to pause an activity that is not the current activity! Please make sure you're calling onCurrentActivityPaused and onCurrentActivityResumed on every activity");
                return;
            }
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " paused");
                f.a().a(activity.getClass().getName(), g.a.g);
            }
            this.sendActivityLifeCycleLocaleBroadcast((Context)activity, (Serializable)((Object)a.d));
        }
    }

    public void onActivityStopped(Activity activity) {
        if (this.beforeICS()) {
            this.handleActivityStoppedEvent(activity);
        }
    }

    void handleActivityStoppedEvent(Activity activity) {
        if (this.isUserTrackingStepsEnable() && this.isNotInstabugActivity(activity)) {
            InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " stopped");
            f.a().a(activity.getClass().getName(), g.a.h);
        }
        this.sendActivityLifeCycleLocaleBroadcast((Context)activity, (Serializable)((Object)a.e));
    }

    public void onActivityDestroyed(Activity activity) {
        if (this.beforeICS()) {
            this.handleActivityDestroyedEvent(activity);
        }
    }

    void handleActivityDestroyedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " destroyed");
                f.a().a(activity.getClass().getName(), g.a.i);
            }
            this.sendActivityLifeCycleLocaleBroadcast((Context)activity, (Serializable)((Object)a.f));
        }
    }

    public void onFragmentAttached(Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.k);
        }
    }

    public void onFragmentViewCreated(Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.l);
        }
    }

    public void onFragmentStarted(Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.m);
        }
    }

    public void onFragmentResumed(Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.n);
        }
    }

    public void onFragmentPaused(Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.o);
        }
    }

    public void onFragmentStopped(Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.p);
        }
    }

    public void onFragmentDetached(Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.q);
        }
    }

    public void onFragmentVisibilityChanged(boolean bl, Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), "Fragment visibility: " + bl, g.a.r);
        }
    }

    public void onFragmentAttached(android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.k);
        }
    }

    public void onFragmentViewCreated(android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.l);
        }
    }

    public void onFragmentStarted(android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.m);
        }
    }

    public void onFragmentResumed(android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.n);
        }
    }

    public void onFragmentPaused(android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.o);
        }
    }

    public void onFragmentStopped(android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.p);
        }
    }

    public void onFragmentDetached(android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.q);
        }
    }

    public void onFragmentVisibilityChanged(boolean bl, android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            f.a().a(fragment.getClass().getName(), activity.getClass().getName(), "Fragment visibility: " + bl, g.a.r);
        }
    }

    public void trackTouchEvent(MotionEvent motionEvent, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            e.a().a(activity, motionEvent);
        }
    }

    public Activity getCurrentActivity() {
        if (this.currentActivity != null && this.currentActivity.get() != null) {
            return (Activity)this.currentActivity.get();
        }
        return null;
    }

    @Nullable
    public Activity getTargetActivity() {
        Activity activity = null;
        if (this.currentActivity != null && this.currentActivity.get() != null && ((Activity)this.currentActivity.get()).getParent() != null) {
            activity = ((Activity)this.currentActivity.get()).getParent();
            while (activity.getParent() != null) {
                activity = activity.getParent();
            }
        } else if (this.currentActivity != null) {
            activity = (Activity)this.currentActivity.get();
        }
        return activity;
    }

    private void registerActivityLifecycleListener(Application application) {
        if (Build.VERSION.SDK_INT >= 14) {
            InstabugSDKLogger.v(this, "Registering activity lifecycle listener");
            c c2 = new c();
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)c2);
        }
    }

    private boolean beforeICS() {
        return Build.VERSION.SDK_INT < 14;
    }

    private boolean isUserTrackingStepsEnable() {
        return g.a().b(Feature.TRACK_USER_STEPS) == Feature.State.ENABLED;
    }

    private boolean isNotInstabugActivity(Activity activity) {
        return !(activity instanceof _InstabugActivity);
    }

    private void sendActivityLifeCycleLocaleBroadcast(Context context, Serializable serializable) {
        Intent intent = new Intent();
        intent.setAction(CURRENT_ACTIVITY_LIFECYCLE_CHANGED);
        intent.putExtra(ACTIVITY_LIFECYCLE_EVENT, serializable);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
    }
}

