/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.messaging;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.instabug.library.InstabugBaseFragment;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.util.ViewResourcesUtil;
import com.instabug.library.i;
import com.instabug.library.internal.storage.cache.AssetsCacheManager;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.messaging.cache.ChatsCacheManager;
import com.instabug.library.messaging.f;
import com.instabug.library.messaging.g;
import com.instabug.library.messaging.model.Chat;
import com.instabug.library.messaging.model.Message;
import com.instabug.library.model.a;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.j;
import com.instabug.library.view.CircularImageView;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observer;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.subjects.PublishSubject;

public class d
extends InstabugBaseFragment
implements View.OnClickListener,
AdapterView.OnItemClickListener,
com.instabug.library.a,
com.instabug.library.internal.storage.cache.a<Chat>,
g {
    private b a;
    private ListView b;
    private ArrayList<Chat> c;
    private a d;
    private PublishSubject<Long> e;
    private Subscription f;

    public static d a() {
        return new d();
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_lyt_conversations;
    }

    @Override
    protected String getTitle() {
        return j.a(InstabugCustomTextPlaceHolder.Key.CONVERSATIONS_LIST_TITLE, this.getString(R.string.instabug_str_conversations));
    }

    @Override
    protected void consumeNewInstanceSavedArguments() {
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        view.findViewById(R.id.instabug_btn_toolbar_right).setVisibility(8);
        view.findViewById(R.id.instabug_btn_toolbar_left).setOnClickListener((View.OnClickListener)this);
        this.b = (ListView)view.findViewById(R.id.instabug_lst_conversations);
        this.b.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.c = new ArrayList<Chat>(ChatsCacheManager.getValidChats());
        Collections.sort(this.c, Collections.reverseOrder(new Chat.a()));
        this.a = new b((Context)this.getPreservedActivity(), this.c);
        this.b.setAdapter((ListAdapter)this.a);
        this.b();
        ImageButton imageButton = (ImageButton)view.findViewById(R.id.instabug_btn_new_chat);
        Drawable drawable2 = com.instabug.library.util.c.a(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.instabug_bg_white_oval));
        imageButton.setBackgroundDrawable(drawable2);
        imageButton.setOnClickListener((View.OnClickListener)this);
        this.d();
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.d = (a)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement InstabugChatListFragment.Callbacks");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.d = null;
    }

    @Override
    protected void saveState(Bundle bundle) {
    }

    @Override
    protected void restoreState(Bundle bundle) {
    }

    public void onDestroyView() {
        super.onDestroyView();
        InstabugSDKLogger.d(this, "onViewDestroyed called");
        if (this.f != null && !this.f.isUnsubscribed()) {
            this.f.unsubscribe();
        }
    }

    @Override
    public void a(Chat chat) {
        InstabugSDKLogger.d(this, "Chat removed from cache: " + chat + ", Time: " + System.currentTimeMillis());
        this.c.remove(chat);
        this.a(System.currentTimeMillis());
    }

    @Override
    public void b(Chat chat) {
        InstabugSDKLogger.d(this, "Chat added to cache: " + chat + ", Time: " + System.currentTimeMillis());
        if (chat.b().size() != 0) {
            this.c.add(chat);
        }
        this.a(System.currentTimeMillis());
    }

    @Override
    public void a(Chat chat, Chat chat2) {
        InstabugSDKLogger.d(this, "Chat updated in cache, Old chat: " + chat + ", Updated chat: " + chat2 + ", Time: " + System.currentTimeMillis());
        this.c.remove(chat);
        if (chat2.b().size() != 0) {
            this.c.add(chat2);
        }
        this.a(System.currentTimeMillis());
    }

    @Override
    public void e() {
        InstabugSDKLogger.d(this, "Chats cache was invalidated, Time: " + System.currentTimeMillis());
        this.c.clear();
        this.a(System.currentTimeMillis());
    }

    public void onStart() {
        super.onStart();
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        this.c = inMemoryCache != null ? new ArrayList<Chat>(inMemoryCache.getValues()) : new ArrayList();
        this.f();
        com.instabug.library.messaging.f.a().a(this);
        CacheManager.getInstance().subscribe("chats_memory_cache", this);
    }

    public void onStop() {
        super.onStop();
        com.instabug.library.messaging.f.a().b(this);
        CacheManager.getInstance().unSubscribe("chats_memory_cache", this);
    }

    @Override
    public void a(boolean bl) {
        InstabugSDKLogger.d(this, "isVisible: " + bl);
    }

    private void b() {
        this.b.setVisibility(0);
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
        if (this.d != null) {
            this.d.c(((Chat)adapterView.getItemAtPosition(n2)).a());
        }
    }

    @Override
    public List<Message> a(@NonNull List<Message> list) {
        if (this.getPreservedActivity() != null) {
            i.a().b((Context)this.getPreservedActivity());
            if (((FragmentActivity)this.getPreservedActivity()).getSupportFragmentManager().findFragmentById(R.id.instabug_fragment_container) instanceof d) {
                return null;
            }
            return list;
        }
        return list;
    }

    public void onClick(View view) {
        AnalyticsObserver.getInstance().catchUIClickingEvent(ViewResourcesUtil.getViewResourceIdAsString(this.getContext(), view.getId()), "instabug_chat_list_fragment");
        if (view.getId() == R.id.instabug_btn_toolbar_left) {
            this.getActivity().onBackPressed();
        } else if (view.getId() == R.id.instabug_btn_new_chat) {
            this.c();
        }
    }

    private void c() {
        if (this.d != null) {
            this.d.g();
        }
    }

    @Override
    private void a(long l2) {
        InstabugSDKLogger.v(this, "handleChatsCacheUpdate, Time: " + l2);
        this.e.onNext((Object)l2);
    }

    private void d() {
        this.e = PublishSubject.create();
        this.f = this.e.debounce(300L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Long>(){

            public void onCompleted() {
            }

            public void onError(Throwable throwable) {
            }

            public void a(Long l2) {
                InstabugSDKLogger.v(this, "chatsCacheUpdateSubscription.onNext() , Time: " + l2);
                d.this.f();
            }

            public /* synthetic */ void onNext(Object object) {
                this.a((Long)object);
            }
        });
    }

    private void f() {
        InstabugSDKLogger.v(this, "updateAdapterDataSetFromCache, Time: " + System.currentTimeMillis());
        this.c = new ArrayList<Chat>(ChatsCacheManager.getValidChats());
        Collections.sort(this.c, Collections.reverseOrder(new Chat.a()));
        this.a.a(this.c);
        this.a.notifyDataSetChanged();
    }

    public static interface a {
        public void c(String var1);

        public void g();
    }

    public class c {
        private final TextView b;
        private final CircularImageView c;
        private final TextView d;
        private final TextView e;
        private final TextView f;
        private final LinearLayout g;

        public c(View view) {
            this.g = (LinearLayout)view.findViewById(R.id.conversation_list_item_container);
            this.b = (TextView)view.findViewById(R.id.instabug_txt_message_sender);
            this.c = (CircularImageView)view.findViewById(R.id.instabug_message_sender_avatar);
            this.d = (TextView)view.findViewById(R.id.instabug_txt_message_time);
            this.f = (TextView)view.findViewById(R.id.instabug_unread_messages_count);
            this.e = (TextView)view.findViewById(R.id.instabug_txt_message_snippet);
        }
    }

    public class b
    extends BaseAdapter {
        private List<Chat> b;
        private com.instabug.library.util.d c;

        public b(Context context, List<Chat> list) {
            this.b = list;
            this.c = new com.instabug.library.util.d(context);
        }

        public int getCount() {
            return this.b.size();
        }

        public Chat a(int n2) {
            return this.b.get(n2);
        }

        public long getItemId(int n2) {
            return this.a(n2).a().hashCode();
        }

        public View getView(int n2, View view, ViewGroup viewGroup) {
            c c2;
            if (view == null) {
                view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.instabug_conversation_list_item, viewGroup, false);
                c2 = new c(view);
                view.setTag((Object)c2);
            } else {
                c2 = (c)view.getTag();
            }
            this.a(c2, this.a(n2));
            return view;
        }

        private void a(final c c2, Chat chat) {
            Object object;
            Object object2;
            InstabugSDKLogger.v((Object)this, "Binding chat " + chat + " to view");
            Collections.sort(chat.b(), new Message.a());
            Message message = chat.j();
            if (message == null || message.c() == null || TextUtils.isEmpty((CharSequence)message.c().trim()) || message.c().equals("null")) {
                if (message != null && message.j().size() > 0) {
                    object2 = message.j().get(message.j().size() - 1).getType();
                    switch (2.a[((Enum)object2).ordinal()]) {
                        case 1: {
                            c2.e.setText(R.string.instabug_str_image);
                            break;
                        }
                        case 2: {
                            c2.e.setText(R.string.instabug_str_audio);
                            break;
                        }
                        case 3: {
                            c2.e.setText(R.string.instabug_str_video);
                        }
                    }
                }
            } else {
                c2.e.setText((CharSequence)message.c());
            }
            if ((object2 = chat.h()) != null && ((String)object2).equals("") && ((String)object2).equals("null")) {
                InstabugSDKLogger.v((Object)this, "chat SenderName: " + (String)object2);
                object = ((String)object2).substring(0, ((String)object2).indexOf(60));
                c2.b.setText((CharSequence)object);
            } else {
                object = String.format(d.this.getString(R.string.instabug_str_notification_title), this.c.a());
                c2.b.setText((CharSequence)object);
            }
            c2.d.setText((CharSequence)InstabugDateFormatter.formatConversationLastMessageDate(chat.i()));
            if (chat.d() != 0) {
                object = new TypedValue();
                Resources.Theme theme = d.this.getActivity().getTheme();
                theme.resolveAttribute(R.attr.instabug_unread_message_background_color, (TypedValue)object, true);
                c2.g.setBackgroundColor(((TypedValue)object).data);
                Drawable drawable2 = com.instabug.library.util.c.a(ContextCompat.getDrawable((Context)d.this.getContext(), (int)R.drawable.instabug_bg_white_oval));
                c2.f.setBackgroundDrawable(drawable2);
                c2.f.setText((CharSequence)String.valueOf(chat.d()));
                c2.f.setVisibility(0);
            } else {
                c2.g.setBackgroundColor(0);
                c2.f.setVisibility(8);
            }
            if (chat.g() != null) {
                object = AssetsCacheManager.createEmptyEntity((Context)d.this.getActivity(), chat.g(), a.a.a);
                AssetsCacheManager.getAssetEntity((Context)d.this.getActivity(), (com.instabug.library.model.a)object, new AssetsCacheManager.b(){

                    @Override
                    public void a(com.instabug.library.model.a a2) {
                        InstabugSDKLogger.d(this, "Asset Entity downloaded: " + a2.c().getPath());
                        try {
                            c2.c.setImageDrawable(null);
                            c2.c.setImageBitmap(BitmapFactory.decodeStream((InputStream)new FileInputStream(a2.c())));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            InstabugSDKLogger.e(this, "Asset Entity downloading got FileNotFoundException error", fileNotFoundException);
                        }
                    }

                    @Override
                    public void a(Throwable throwable) {
                        InstabugSDKLogger.e(this, "Asset Entity downloading got error", throwable);
                    }
                });
            }
        }

        public void a(List<Chat> list) {
            this.b = list;
        }

        public /* synthetic */ Object getItem(int n2) {
            return this.a(n2);
        }
    }
}

