/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.model.e;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.HashMap;

public class UserAttributesCacheManager {
    public static final String USER_ATTRIBUTES_DISK_CACHE_FILE_NAME = "/user_attributes.cache";
    public static final String USER_ATTRIBUTES_DISK_CACHE_KEY = "user_attributes_disk_cache";
    public static final String USER_ATTRIBUTES_MEMORY_CACHE_KEY = "user_attributes_memory_cache";
    private static final String USER_ATTRIBUTES_CACHE_KEY = "attrs";

    public static InMemoryCache<String, e> getCache() {
        if (!CacheManager.getInstance().cacheExists(USER_ATTRIBUTES_MEMORY_CACHE_KEY)) {
            Cache cache = CacheManager.getInstance().getCache(USER_ATTRIBUTES_MEMORY_CACHE_KEY);
            InstabugSDKLogger.d(UserAttributesCacheManager.class, "In-memory user attributes cache not found, loading it from disk " + cache);
            CacheManager.getInstance().migrateCache(USER_ATTRIBUTES_DISK_CACHE_KEY, USER_ATTRIBUTES_MEMORY_CACHE_KEY, new CacheManager.KeyExtractor<String, e>(){

                public String a(e e2) {
                    return UserAttributesCacheManager.USER_ATTRIBUTES_CACHE_KEY;
                }

                @Override
                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((e)object);
                }
            });
        }
        InstabugSDKLogger.d(UserAttributesCacheManager.class, "In-memory user attributes cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(USER_ATTRIBUTES_MEMORY_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        if (!CacheManager.getInstance().cacheExists(USER_ATTRIBUTES_MEMORY_CACHE_KEY)) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Cache cache = CacheManager.getInstance().getCache(UserAttributesCacheManager.USER_ATTRIBUTES_MEMORY_CACHE_KEY);
                Cache cache2 = CacheManager.getInstance().getCache(UserAttributesCacheManager.USER_ATTRIBUTES_DISK_CACHE_KEY);
                if (cache2 != null) {
                    InstabugSDKLogger.d(UserAttributesCacheManager.class, "Checking old values cached " + cache2.getValues());
                }
                if (cache != null && cache2 != null) {
                    InstabugSDKLogger.d(UserAttributesCacheManager.class, "Saving In-memory user attributes cache to disk, no. of user attributes to save is " + cache.size());
                    CacheManager.getInstance().migrateCache(cache, cache2, new CacheManager.KeyExtractor<String, e>(){

                        public String a(e e2) {
                            return UserAttributesCacheManager.USER_ATTRIBUTES_CACHE_KEY;
                        }

                        @Override
                        public /* synthetic */ Object extractKey(Object object) {
                            return this.a((e)object);
                        }
                    });
                    InstabugSDKLogger.d(UserAttributesCacheManager.class, "In-memory user attributes cache had been persisted on-disk, " + cache2.size() + " user attributes saved");
                }
            }
        });
        thread.start();
    }

    public static void putAttribute(@NonNull String string2, String string3) {
        InMemoryCache<String, e> inMemoryCache = UserAttributesCacheManager.getCache();
        if (inMemoryCache != null) {
            if (inMemoryCache.get(USER_ATTRIBUTES_CACHE_KEY) == null) {
                inMemoryCache.put(USER_ATTRIBUTES_CACHE_KEY, new e());
            }
            inMemoryCache.get(USER_ATTRIBUTES_CACHE_KEY).a(string2, string3);
        }
    }

    @Nullable
    public static String getAttribute(@NonNull String string2) {
        e e2;
        InMemoryCache<String, e> inMemoryCache = UserAttributesCacheManager.getCache();
        if (inMemoryCache != null && (e2 = inMemoryCache.get(USER_ATTRIBUTES_CACHE_KEY)) != null) {
            return e2.a(string2);
        }
        return null;
    }

    public static void deleteAttribute(String string2) {
        e e2;
        InMemoryCache<String, e> inMemoryCache = UserAttributesCacheManager.getCache();
        if (inMemoryCache != null && (e2 = inMemoryCache.get(USER_ATTRIBUTES_CACHE_KEY)) != null) {
            e2.b(string2);
        }
    }

    public static void deleteAll() {
        InMemoryCache<String, e> inMemoryCache = UserAttributesCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.invalidate();
        }
    }

    @Nullable
    public static HashMap<String, String> getAll() {
        InMemoryCache<String, e> inMemoryCache = UserAttributesCacheManager.getCache();
        e e2 = inMemoryCache != null ? UserAttributesCacheManager.getCache().get(USER_ATTRIBUTES_CACHE_KEY) : null;
        return e2 == null || e2.a() == null || e2.a().isEmpty() ? null : e2.a();
    }
}

