/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.model.Session;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;

public class SessionsCacheManager {
    public static final String SESSIONS_DISK_CACHE_FILE_NAME = "/sessions.cache";
    public static final String SESSIONS_DISK_CACHE_KEY = "sessions_disk_cache";
    public static final String SESSIONS_MEMORY_CACHE_KEY = "sessions_memory_cache";

    @Nullable
    public static InMemoryCache<Long, Session> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(SESSIONS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(SessionsCacheManager.class, "In-memory Sessions cache not found, loading it from disk " + CacheManager.getInstance().getCache(SESSIONS_MEMORY_CACHE_KEY));
            CacheManager.getInstance().migrateCache(SESSIONS_DISK_CACHE_KEY, SESSIONS_MEMORY_CACHE_KEY, new CacheManager.KeyExtractor<Long, Session>(){

                public Long a(Session session) {
                    return session.b();
                }

                @Override
                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((Session)object);
                }
            });
            Cache cache = CacheManager.getInstance().getCache(SESSIONS_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(SessionsCacheManager.class, "In-memory Sessions cache restored from disk, " + cache.getValues().size() + " elements restored");
            }
        }
        InstabugSDKLogger.d(SessionsCacheManager.class, "In-memory Sessions cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(SESSIONS_MEMORY_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        final Cache cache = CacheManager.getInstance().getCache(SESSIONS_MEMORY_CACHE_KEY);
        final Cache cache2 = CacheManager.getInstance().getCache(SESSIONS_DISK_CACHE_KEY);
        if (cache != null && cache2 != null) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    InstabugSDKLogger.d(SessionsCacheManager.class, "Checking old values cached " + cache2.getValues());
                    InstabugSDKLogger.d(SessionsCacheManager.class, "Saving In-memory Sessions cache to disk, no. of sessions to save is " + cache.size());
                    CacheManager.getInstance().migrateCache(cache, cache2, new CacheManager.KeyExtractor<String, Session>(){

                        public String a(Session session) {
                            return String.valueOf(session.b());
                        }

                        @Override
                        public /* synthetic */ Object extractKey(Object object) {
                            return this.a((Session)object);
                        }
                    });
                    InstabugSDKLogger.d(SessionsCacheManager.class, "In-memory Sessions cache had been persisted on-disk, " + cache2.getValues().size() + " sessions saved");
                }
            });
            thread.start();
        } else {
            InstabugSDKLogger.e(SessionsCacheManager.class, "sessionsMemoryCache or sessionsDiskCache is null or both");
        }
    }

    public static void addSession(Session session) {
        InMemoryCache<Long, Session> inMemoryCache = SessionsCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.put(session.b(), session);
        }
    }

    @Nullable
    public static Session getSession(long l2) {
        InMemoryCache<Long, Session> inMemoryCache = SessionsCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.get(l2);
        }
        return null;
    }

    @Nullable
    public static Session deleteSession(Session session) {
        InMemoryCache<Long, Session> inMemoryCache = SessionsCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.delete(session.b());
        }
        return null;
    }

    public static List<Session> getSessions() {
        InMemoryCache<Long, Session> inMemoryCache = SessionsCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.getValues();
        }
        return new ArrayList<Session>();
    }
}

