/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.content.Context;
import android.text.TextUtils;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class OnDiskCache<V extends Cacheable>
extends Cache<String, V> {
    private final File cacheFile;
    private final File cacheDir;
    private Class<V> VClass;

    public OnDiskCache(Context context, String string2, String string3, Class<V> clazz) {
        super(string2);
        this.VClass = clazz;
        this.cacheDir = context.getCacheDir();
        this.cacheFile = new File(this.cacheDir + string3);
        if (!this.cacheFile.exists()) {
            try {
                this.cacheFile.createNewFile();
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(this, "Failed to create", iOException);
            }
        }
        if (!this.checkCacheValidity()) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> getValues() {
        ArrayList<Cacheable> arrayList = new ArrayList<Cacheable>();
        if (!this.cacheFile.exists()) {
            InstabugSDKLogger.d(this, "Cache file doesn't exist");
            return arrayList;
        }
        File file = this.cacheFile;
        synchronized (file) {
            BufferedReader bufferedReader = null;
            try {
                String string2;
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.cacheFile), Charset.forName("UTF-8")));
                do {
                    String string3;
                    if ((string3 = this.getValue(string2 = bufferedReader.readLine())) == null || string3.isEmpty()) continue;
                    Cacheable cacheable = (Cacheable)this.VClass.newInstance();
                    cacheable.fromJson(this.getValue(string2));
                    arrayList.add(cacheable);
                } while (string2 != null);
            }
            catch (InstantiationException instantiationException) {
                InstabugSDKLogger.e(this, "InstantiationException happened while fetching values", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                InstabugSDKLogger.e(this, "IllegalAccessException went wrong while fetching", illegalAccessException);
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(this, "IOException went wrong while fetching values", iOException);
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(this, "JSONException went wrong while fetching values", jSONException);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e(this, "Failed to close file reader", iOException);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V get(String string2) {
        if (string2 == null) {
            InstabugSDKLogger.d(this, "Key equal null");
            return null;
        }
        if (!this.cacheFile.exists()) {
            InstabugSDKLogger.d(this, "Cache file doesn't exist");
            return null;
        }
        BufferedReader bufferedReader = null;
        Cacheable cacheable = null;
        try {
            cacheable = (Cacheable)this.VClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            InstabugSDKLogger.e(this, "InstantiationException happened while fetching value for key " + string2, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            InstabugSDKLogger.e(this, "IllegalAccessException went wrong while fetching value for key " + string2, illegalAccessException);
        }
        File file = this.cacheFile;
        synchronized (file) {
            try {
                String string3;
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.cacheFile), Charset.forName("UTF-8")));
                do {
                    String string4;
                    if ((string4 = this.getKey(string3 = bufferedReader.readLine())) == null || !string4.equals(string2)) continue;
                    cacheable.fromJson(this.getValue(string3));
                    Cacheable cacheable2 = cacheable;
                    return (V)cacheable2;
                } while (string3 != null);
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(this, "IOException went wrong while fetching value for key " + string2, iOException);
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(this, "JSONException went wrong while fetching value for key " + string2, jSONException);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e(this, "Failed to close file reader", iOException);
                }
            }
            InstabugSDKLogger.d(this, "No value found for key " + string2 + ", returning null");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(String string2, V v) {
        if (string2 == null) {
            InstabugSDKLogger.d(this, "Key equal null");
            return null;
        }
        if (v == null) {
            InstabugSDKLogger.d(this, "Value equal null");
            return null;
        }
        if (!this.cacheFile.exists()) {
            InstabugSDKLogger.d(this, "Cache file doesn't exist");
            return null;
        }
        V v2 = this.get(string2);
        if (v2 != null) {
            this.delete(string2);
        }
        OutputStreamWriter outputStreamWriter = null;
        File file = this.cacheFile;
        synchronized (file) {
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.cacheFile, true), Charset.forName("UTF-8"));
                BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                bufferedWriter.append(string2).append(":").append(v.toJson()).append("\n");
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(this, "Something went wrong while setting value for key " + string2, iOException);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            finally {
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {
                        InstabugSDKLogger.e(this, "Failed to close file writer", iOException);
                    }
                }
            }
        }
        return v2 != null ? v2 : v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V delete(String string2) {
        if (!this.cacheFile.exists()) {
            InstabugSDKLogger.d(this, "Cache file doesn't exist");
            return null;
        }
        File file = new File(this.cacheDir + "/cache.tmp");
        Cacheable cacheable = null;
        try {
            cacheable = (Cacheable)this.VClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            InstabugSDKLogger.e(this, "InstantiationException happened while deleting value for key " + string2, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            InstabugSDKLogger.e(this, "IllegalAccessException went wrong while deleting value for key " + string2, illegalAccessException);
        }
        File file2 = this.cacheFile;
        synchronized (file2) {
            try {
                String string3;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.cacheFile), Charset.forName("UTF-8")));
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), Charset.forName("UTF-8")));
                do {
                    String string4;
                    if ((string4 = this.getKey(string3 = bufferedReader.readLine())) == null) continue;
                    if (string4.equals(string2)) {
                        cacheable.fromJson(this.getValue(string3));
                        continue;
                    }
                    bufferedWriter.write(string3 + "\n");
                } while (string3 != null);
                bufferedReader.close();
                bufferedWriter.flush();
                bufferedWriter.close();
                if (this.cacheFile.delete()) {
                    file.renameTo(this.cacheFile);
                }
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(this, "IOException went wrong while deleting value for key " + string2, iOException);
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(this, "JSONException went wrong while deleting value for key " + string2, jSONException);
            }
        }
        return (V)cacheable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        if (!this.cacheFile.exists()) {
            InstabugSDKLogger.d(this, "Cache file doesn't exist");
            return -1L;
        }
        File file = this.cacheFile;
        synchronized (file) {
            return this.cacheFile.getTotalSpace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        if (this.cacheFile.exists()) {
            InstabugSDKLogger.d(this, "Cache file  exist");
            File file = this.cacheFile;
            synchronized (file) {
                this.cacheFile.delete();
            }
        }
        try {
            this.cacheFile.createNewFile();
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(this, "Failed to create cache file", iOException);
        }
    }

    public String getValue(String string2) {
        if (string2 != null && !string2.isEmpty() && string2.contains(":")) {
            return string2.substring(string2.indexOf(":") + 1);
        }
        return null;
    }

    public String getKey(String string2) {
        if (string2 != null && !string2.isEmpty() && string2.contains(":")) {
            return string2.substring(0, string2.indexOf(":"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkCacheValidity() {
        if (!this.cacheFile.exists()) {
            InstabugSDKLogger.d(this, "Cache file doesn't exist");
            return false;
        }
        File file = this.cacheFile;
        synchronized (file) {
            BufferedReader bufferedReader = null;
            try {
                String string2;
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.cacheFile), Charset.forName("UTF-8")));
                String string3 = bufferedReader.readLine();
                if (string3 != null && !TextUtils.isEmpty((CharSequence)(string2 = this.getValue(string3)))) {
                    new JSONObject(string2);
                }
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(this, "IOException went wrong while fetching values", iOException);
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(this, "JSONException went wrong while fetching values", jSONException);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException2) {
                    InstabugSDKLogger.e(this, "Failed to close file reader", iOException2);
                }
            }
            return true;
        }
    }
}

