/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import android.content.ContentValues;
import android.database.Cursor;
import android.support.annotation.NonNull;
import com.instabug.library.Feature;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.a.a;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventSubscriber;
import com.instabug.library.g;
import com.instabug.library.internal.storage.cache.a.c;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.user.a;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.functions.Action1;

public class InstabugUserEventLogger {
    private static InstabugUserEventLogger instabugUserEventLogger;
    private static final int USER_EVENT_COUNT_LIMIT = 10000;
    private List<a> userEvents = new ArrayList<a>();
    private Map<String, Integer> userEventsCount = new HashMap<String, Integer>();

    private InstabugUserEventLogger() {
        this.subscribeOnSDKEvents();
    }

    public static InstabugUserEventLogger getInstance() {
        if (instabugUserEventLogger == null) {
            instabugUserEventLogger = new InstabugUserEventLogger();
        }
        return instabugUserEventLogger;
    }

    public void logUserEvent(@NonNull String string2, UserEventParam ... userEventParamArray) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new a.a().a("eventIdentifier").a(String.class), new a.a().a("userEventParams").a(UserEventParam.class));
        if (g.a().b(Feature.USER_EVENTS) == Feature.State.ENABLED) {
            a a2 = new a().a(string2).a(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
            for (UserEventParam userEventParam : userEventParamArray) {
                a2.a(userEventParam);
            }
            if (this.userEvents.size() >= 10000) {
                this.userEvents.remove(0);
            }
            this.userEvents.add(a2);
            Object object = this.userEventsCount.get(string2);
            if (object != null) {
                object = (Integer)object + 1;
                this.userEventsCount.put(string2, (Integer)object);
            } else {
                this.userEventsCount.put(string2, 1);
            }
        }
    }

    public int getLoggingEventCount(@NonNull String string2) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new a.a().a("userEventIdentifier").a(String.class));
        return this.getEventLoggingCount(string2);
    }

    public List<a> getUserEvents() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new a.a[0]);
        return this.userEvents;
    }

    public void clearAll() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new a.a[0]);
        this.userEvents.clear();
    }

    public void clearLoggingData() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new a.a[0]);
        c c2 = com.instabug.library.internal.storage.cache.a.a.a().b();
        c2.a("user_events_logs", (String)null, (String[])null);
    }

    private void incrementEventLoggingCount(@NonNull String string2, int n2) {
        int n3 = this.getEventLoggingCount(string2);
        boolean bl = n3 > 0;
        c c2 = com.instabug.library.internal.storage.cache.a.a.a().b();
        ContentValues contentValues = new ContentValues();
        contentValues.put("event_identifier", string2);
        contentValues.put("event_logging_count", Integer.valueOf(n3 += n2));
        if (bl) {
            InstabugSDKLogger.d(this, "update: " + c2.a("user_events_logs", contentValues, "event_identifier=?", new String[]{string2}));
        } else {
            InstabugSDKLogger.d(this, "insert: " + c2.a("user_events_logs", null, contentValues));
        }
        c2.b();
    }

    private int getEventLoggingCount(@NonNull String string2) {
        c c2 = com.instabug.library.internal.storage.cache.a.a.a().b();
        Cursor cursor = c2.a("user_events_logs", new String[]{"event_logging_count"}, "event_identifier=?", new String[]{string2}, null, null, null);
        int n2 = 0;
        if (cursor.getCount() > 0) {
            cursor.moveToFirst();
            int n3 = cursor.getColumnIndex("event_logging_count");
            n2 = cursor.getInt(n3);
        }
        cursor.close();
        c2.b();
        return n2;
    }

    private void subscribeOnSDKEvents() {
        SDKCoreEventSubscriber.subscribe(new Action1<SDKCoreEvent>(){

            public void a(SDKCoreEvent sDKCoreEvent) {
                switch (sDKCoreEvent) {
                    case SESSION_FINISHED: {
                        for (Map.Entry entry : InstabugUserEventLogger.this.userEventsCount.entrySet()) {
                            InstabugUserEventLogger.this.incrementEventLoggingCount((String)entry.getKey(), (Integer)entry.getValue());
                        }
                        InstabugUserEventLogger.this.userEventsCount.clear();
                    }
                }
            }

            public /* synthetic */ void call(Object object) {
                this.a((SDKCoreEvent)((Object)object));
            }
        });
    }
}

