/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import com.instabug.library.Instabug;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.network.b;
import com.instabug.library.util.InstabugSDKLogger;
import com.squareup.mimecraft.Multipart;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.GZIPOutputStream;
import org.json.JSONException;
import rx.Observable;
import rx.Subscriber;

public class NetworkManager {
    public static final String APP_TOKEN = "application_token";
    public static final String UUID = "uuid";
    private static final int DEFAULT_READ_TIME_OUT = 10000;
    private static final int DEFAULT_CONNECTION_TIME_OUT = 15000;

    public static boolean isOnline(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnectedOrConnecting()) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            InstabugSDKLogger.w(NetworkManager.class, "Could not read network state. To enable please add the following line in your AndroidManifest.xml <uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\"/>\n" + securityException.getMessage());
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(NetworkManager.class, "Something went wrong while checking network state", exception);
        }
        return false;
    }

    public Observable<RequestResponse> doRequest(final @NonNull Request request) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RequestResponse>(){

            public void a(Subscriber<? super RequestResponse> subscriber) {
                try {
                    subscriber.onStart();
                    InstabugSDKLogger.v(NetworkManager.class, "Starting do request");
                    InstabugSDKLogger.v(NetworkManager.class, "Request Url: " + request.getRequestUrl());
                    InstabugSDKLogger.v(NetworkManager.class, "Request Type: " + request.getRequestMethod().toString());
                    InstabugSDKLogger.v(NetworkManager.class, "Request Body: " + request.getRequestBody());
                    HttpURLConnection httpURLConnection = null;
                    switch (request.getRequestType()) {
                        case NORMAL: {
                            httpURLConnection = NetworkManager.this.connectWithNormalType(request);
                            break;
                        }
                        case FILE_DOWNLOAD: {
                            httpURLConnection = NetworkManager.this.connectWithFileDownloadType(request);
                            break;
                        }
                        case MULTI_PART: {
                            httpURLConnection = NetworkManager.this.connectWithMultiPartType(request);
                        }
                    }
                    int n2 = httpURLConnection.getResponseCode();
                    if (n2 >= 300) {
                        InstabugSDKLogger.e(NetworkManager.class, "Network request got error");
                        NetworkManager.this.handleServerConnectionError(httpURLConnection);
                    }
                    InstabugSDKLogger.v(NetworkManager.class, "Network request completed successfully");
                    switch (request.getRequestType()) {
                        case NORMAL: {
                            subscriber.onNext((Object)NetworkManager.this.handleRequestResponse(httpURLConnection));
                            break;
                        }
                        case FILE_DOWNLOAD: {
                            subscriber.onNext((Object)NetworkManager.this.handleFileDownloadRequestResponse(request, httpURLConnection));
                            break;
                        }
                        case MULTI_PART: {
                            subscriber.onNext((Object)NetworkManager.this.handleMultipartRequestResponse(httpURLConnection));
                        }
                    }
                    subscriber.onCompleted();
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e(NetworkManager.class, "Request got error: " + request.getRequestUrl(), iOException);
                    subscriber.onError((Throwable)iOException);
                }
                catch (b b2) {
                    InstabugSDKLogger.w(NetworkManager.class, "Request got error: " + request.getRequestUrl() + ", error message: " + b2.getMessage());
                    subscriber.onCompleted();
                }
            }

            public /* synthetic */ void call(Object object) {
                this.a((Subscriber<? super RequestResponse>)((Subscriber)object));
            }
        });
    }

    public Request buildRequest(@NonNull Context context, @NonNull Request.Endpoint endpoint, @NonNull Request.RequestMethod requestMethod) throws JSONException {
        return this.buildRequest(context, endpoint, requestMethod, RequestType.NORMAL);
    }

    public Request buildRequest(@NonNull Context context, @NonNull Request.Endpoint endpoint, @NonNull Request.RequestMethod requestMethod, @NonNull RequestType requestType) throws JSONException {
        Request request = new Request(endpoint, requestType);
        request.setRequestMethod(requestMethod);
        return this.buildRequest(context, request);
    }

    public Request buildRequest(@NonNull Context context, @NonNull String string2, @NonNull Request.RequestMethod requestMethod) throws JSONException {
        return this.buildRequest(context, string2, requestMethod, RequestType.NORMAL);
    }

    public Request buildRequest(@NonNull Context context, @NonNull String string2, @NonNull Request.RequestMethod requestMethod, @NonNull RequestType requestType) throws JSONException {
        Request request = new Request(string2, requestType);
        request.setRequestMethod(requestMethod);
        return this.buildRequest(context, request);
    }

    private Request buildRequest(@NonNull Context context, Request request) throws JSONException {
        request.addParameter(APP_TOKEN, Instabug.getAppToken());
        request.addParameter(UUID, com.instabug.library.user.b.d());
        return request;
    }

    public HttpURLConnection buildConnection(@NonNull Request request) throws IOException {
        URL uRL = new URL(request.getRequestUrl());
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
        httpURLConnection.setRequestProperty("Content-Encoding", "gzip");
        for (Request.RequestParameter requestParameter : request.getHeaders()) {
            httpURLConnection.setRequestProperty(requestParameter.getKey(), (String)requestParameter.getValue());
        }
        httpURLConnection.setDoInput(true);
        return httpURLConnection;
    }

    private HttpURLConnection setURLConnectionDefaultTimeOut(@NonNull HttpURLConnection httpURLConnection) {
        return this.setURLConnectionTimeOut(httpURLConnection, 10000, 15000);
    }

    public HttpURLConnection setURLConnectionTimeOut(@NonNull HttpURLConnection httpURLConnection, int n2, int n3) {
        httpURLConnection.setReadTimeout(n2);
        httpURLConnection.setConnectTimeout(n3);
        return httpURLConnection;
    }

    private HttpURLConnection connectWithNormalType(Request request) throws IOException {
        InstabugSDKLogger.v(this, "Connect to: " + request.getRequestUrl() + " with normal type");
        HttpURLConnection httpURLConnection = this.buildConnection(request);
        this.setURLConnectionDefaultTimeOut(httpURLConnection);
        httpURLConnection.setRequestMethod(request.getRequestMethod().toString());
        if (request.getRequestMethod() == Request.RequestMethod.Post || request.getRequestMethod() == Request.RequestMethod.put) {
            httpURLConnection.setDoOutput(true);
            this.writeRequestBody(httpURLConnection.getOutputStream(), request.getRequestBody());
        }
        return httpURLConnection;
    }

    private void writeRequestBody(OutputStream outputStream, String string2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(string2.getBytes(Charset.forName("UTF8")));
        gZIPOutputStream.close();
        outputStream.write(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
    }

    private HttpURLConnection connectWithFileDownloadType(Request request) throws IOException {
        InstabugSDKLogger.v(this, "Connect to: " + request.getRequestUrl() + " with fileDownload type");
        return this.connectWithNormalType(request);
    }

    private HttpURLConnection connectWithMultiPartType(Request request) throws IOException {
        InstabugSDKLogger.v(this, "Connect to: " + request.getRequestUrl() + " with multiPart type");
        HttpURLConnection httpURLConnection = this.buildConnection(request);
        httpURLConnection.setRequestMethod(request.getRequestMethod().toString());
        httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
        httpURLConnection.setRequestProperty("Cache-Control", "no-cache");
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoOutput(true);
        Multipart multipart = request.buildMultiPart(request.getFileToUpload(), request.getRequestBodyParameters());
        for (Map.Entry entry : multipart.getHeaders().entrySet()) {
            httpURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
        this.writeMultiPartRequestBody(httpURLConnection.getOutputStream(), multipart);
        return httpURLConnection;
    }

    private void writeMultiPartRequestBody(OutputStream outputStream, Multipart multipart) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        multipart.writeBodyTo((OutputStream)gZIPOutputStream);
        gZIPOutputStream.close();
        outputStream.write(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
    }

    private RequestResponse handleRequestResponse(HttpURLConnection httpURLConnection) throws IOException {
        RequestResponse requestResponse = new RequestResponse();
        int n2 = httpURLConnection.getResponseCode();
        requestResponse.setResponseCode(n2);
        InstabugSDKLogger.v(this, "Request response code: " + n2);
        String string2 = this.convertStreamToString(httpURLConnection.getInputStream());
        requestResponse.setResponseBody(string2);
        InstabugSDKLogger.v(this, "Request response: " + string2);
        httpURLConnection.disconnect();
        return requestResponse;
    }

    private RequestResponse handleMultipartRequestResponse(HttpURLConnection httpURLConnection) throws IOException {
        return this.handleRequestResponse(httpURLConnection);
    }

    private RequestResponse handleFileDownloadRequestResponse(Request request, HttpURLConnection httpURLConnection) throws IOException {
        RequestResponse requestResponse = new RequestResponse();
        int n2 = httpURLConnection.getResponseCode();
        requestResponse.setResponseCode(n2);
        InstabugSDKLogger.v(this, "File downloader request response code: " + n2);
        this.copyStream(httpURLConnection.getInputStream(), new FileOutputStream(request.getDownloadedFile()));
        requestResponse.setResponseBody(request.getDownloadedFile());
        InstabugSDKLogger.v(this, "File downloader request response: " + request.getDownloadedFile().getPath());
        httpURLConnection.disconnect();
        return requestResponse;
    }

    private void handleServerConnectionError(HttpURLConnection httpURLConnection) throws IOException, b {
        int n2 = httpURLConnection.getResponseCode();
        InputStream inputStream = httpURLConnection.getErrorStream();
        InstabugSDKLogger.e(this, "Error getting Network request response: " + this.convertStreamToString(inputStream));
        throw new b("responseCode: " + n2 + "\n" + this.convertStreamToString(inputStream));
    }

    private String convertStreamToString(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream, "UTF-8").useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    private void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        while ((n2 = inputStream.read()) != -1) {
            outputStream.write(n2);
        }
    }

    public static enum RequestType {
        NORMAL,
        MULTI_PART,
        FILE_DOWNLOAD;

    }
}

