/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.messaging.a;

import android.content.Context;
import com.instabug.library.messaging.model.Chat;
import com.instabug.library.messaging.model.Message;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.network.NetworkManager;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.user.b;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import rx.Observable;
import rx.Subscriber;
import rx.schedulers.Schedulers;

public class a {
    private static a a;
    private NetworkManager b = new NetworkManager();

    public static a a() {
        if (a == null) {
            a = new a();
        }
        return a;
    }

    private a() {
    }

    public void a(Context context, State state, final Request.Callbacks<String, Throwable> callbacks) throws JSONException, IOException {
        InstabugSDKLogger.v(this, "trigger chat");
        Request request = this.b.buildRequest(context, Request.Endpoint.TriggerChat, Request.RequestMethod.Post);
        ArrayList<State.StateItem> arrayList = state.getStateItems();
        for (int i2 = 0; i2 < state.getStateItems().size(); ++i2) {
            InstabugSDKLogger.v(this, "Chat State Key: " + arrayList.get(i2).getKey() + ", Chat State value: " + arrayList.get(i2).getValue());
            request.addRequestBodyParameter(state.getStateItems().get(i2).getKey(), state.getStateItems().get(i2).getValue());
        }
        this.b.doRequest(request).subscribe((Subscriber)new Subscriber<RequestResponse>(){

            public void onStart() {
                InstabugSDKLogger.v((Object)this, "triggeringChatRequest started");
            }

            public void onCompleted() {
                InstabugSDKLogger.v((Object)this, "triggeringChatRequest completed");
            }

            public void onError(Throwable throwable) {
                InstabugSDKLogger.v((Object)this, "triggeringChatRequest got error: " + throwable.getMessage());
                callbacks.onFailed(throwable);
            }

            public void a(RequestResponse requestResponse) {
                InstabugSDKLogger.v((Object)this, "triggeringChatRequest onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody());
                if (requestResponse.getResponseCode() == 200) {
                    try {
                        callbacks.onSucceeded(new JSONObject((String)requestResponse.getResponseBody()).getString("chat_number"));
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                } else {
                    callbacks.onFailed(new Throwable("Triggering chat got error with response code:" + requestResponse.getResponseCode()));
                }
            }

            public /* synthetic */ void onNext(Object object) {
                this.a((RequestResponse)object);
            }
        });
    }

    public void a(Context context, Message message, final Request.Callbacks<String, Throwable> callbacks) throws JSONException, IOException {
        InstabugSDKLogger.v(this, "Sending message");
        Request request = this.b.buildRequest(context, Request.Endpoint.SendMessage, Request.RequestMethod.Post);
        request.setEndpoint(request.getEndpoint().replaceAll(":chat_number", message.b()));
        request.addParameter("message", new JSONObject().put("body", (Object)message.c()).put("messaged_at", message.f()).put("email", (Object)com.instabug.library.user.b.b()).put("name", (Object)com.instabug.library.user.b.c()));
        this.b.doRequest(request).subscribe((Subscriber)new Subscriber<RequestResponse>(){

            public void onStart() {
                InstabugSDKLogger.v((Object)this, "sendMessage request started");
            }

            public void onCompleted() {
                InstabugSDKLogger.v((Object)this, "sendMessage request completed");
            }

            public void onError(Throwable throwable) {
                InstabugSDKLogger.v((Object)this, "sendMessage request got error: " + throwable.getMessage());
                callbacks.onFailed(throwable);
            }

            public void a(RequestResponse requestResponse) {
                InstabugSDKLogger.v((Object)this, "sendMessage request onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody());
                if (requestResponse.getResponseCode() == 200) {
                    try {
                        callbacks.onSucceeded(new JSONObject((String)requestResponse.getResponseBody()).getString("message_id"));
                    }
                    catch (JSONException jSONException) {
                        InstabugSDKLogger.e((Object)this, "Sending message got error", jSONException);
                    }
                } else {
                    callbacks.onFailed(new Throwable("Sending message got error with response code:" + requestResponse.getResponseCode()));
                }
            }

            public /* synthetic */ void onNext(Object object) {
                this.a((RequestResponse)object);
            }
        });
    }

    public void b(Context context, final Message message, final Request.Callbacks<Boolean, Message> callbacks) throws JSONException, FileNotFoundException {
        InstabugSDKLogger.v(this, "Uploading message attachments, Message: " + message.c());
        Observable[] observableArray = new Observable[message.j().size()];
        for (int i2 = 0; i2 < observableArray.length; ++i2) {
            Attachment attachment = message.j().get(i2);
            InstabugSDKLogger.v(this, "Uploading attachment with type: " + (Object)((Object)attachment.getType()));
            Request request = this.b.buildRequest(context, Request.Endpoint.AddMessageAttachment, Request.RequestMethod.Post, NetworkManager.RequestType.MULTI_PART);
            request.setEndpoint(request.getEndpoint().replaceAll(":chat_number", message.b()));
            request.setEndpoint(request.getEndpoint().replaceAll(":message_id", String.valueOf(message.a())));
            request.addParameter("metadata[file_type]", (Object)attachment.getType());
            if (attachment.getType() == Attachment.Type.AUDIO) {
                request.addParameter("metadata[duration]", attachment.getDuration());
            }
            request.setFileToUpload(new Request.FileToUpload("file", attachment.getName(), attachment.getLocalPath(), attachment.getFileType()));
            InstabugSDKLogger.v(this, "Uploading attachment with name: " + attachment.getName() + " path: " + attachment.getLocalPath() + " file type: " + attachment.getFileType());
            observableArray[i2] = this.b.doRequest(request);
        }
        Observable.merge((Observable[])observableArray, (int)1).subscribe((Subscriber)new Subscriber<RequestResponse>(){

            public void onStart() {
                InstabugSDKLogger.v((Object)this, "uploadingMessageAttachmentRequest started");
            }

            public void onCompleted() {
                InstabugSDKLogger.v((Object)this, "uploadingMessageAttachmentRequest completed");
                callbacks.onSucceeded(true);
            }

            public void onError(Throwable throwable) {
                InstabugSDKLogger.v((Object)this, "uploadingMessageAttachmentRequest got error: " + throwable.getMessage());
                callbacks.onFailed(message);
            }

            public void a(RequestResponse requestResponse) {
                InstabugSDKLogger.v((Object)this, "uploadingMessageAttachmentRequest onNext, Response code: " + requestResponse.getResponseCode() + ", Response body: " + requestResponse.getResponseBody());
            }

            public /* synthetic */ void onNext(Object object) {
                this.a((RequestResponse)object);
            }
        });
    }

    public void a(Context context, long l2, int n2, JSONArray jSONArray, final Request.Callbacks<RequestResponse, Throwable> callbacks) throws JSONException, IOException {
        InstabugSDKLogger.v(this, "Syncing messages with server");
        Request request = this.b.buildRequest(context, Request.Endpoint.SyncChats, Request.RequestMethod.Post);
        if (l2 != 0L) {
            request.addParameter("last_message_messaged_at", InstabugDateFormatter.formatUTCDate(l2));
        }
        request.addParameter("messages_count", n2);
        if (jSONArray != null && jSONArray.length() != 0) {
            request.addParameter("read_messages", jSONArray);
        }
        this.b.doRequest(request).subscribeOn(Schedulers.io()).subscribe((Subscriber)new Subscriber<RequestResponse>(){

            public void onStart() {
                InstabugSDKLogger.v((Object)this, "syncMessages request started");
            }

            public void onCompleted() {
                InstabugSDKLogger.v((Object)this, "syncMessages request completed");
            }

            public void onError(Throwable throwable) {
                InstabugSDKLogger.v((Object)this, "syncMessages request got error: " + throwable.getMessage());
                callbacks.onFailed(throwable);
            }

            public void a(RequestResponse requestResponse) {
                InstabugSDKLogger.v((Object)this, "syncMessages request onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody());
                callbacks.onSucceeded(requestResponse);
            }

            public /* synthetic */ void onNext(Object object) {
                this.a((RequestResponse)object);
            }
        });
    }

    public void a(Context context, final Chat chat, final Request.Callbacks<Boolean, Chat> callbacks) {
        try {
            Request request = this.b.buildRequest(context, Request.Endpoint.chatLogs, Request.RequestMethod.Post);
            request.setEndpoint(request.getEndpoint().replaceAll(":chat_token", chat.a()));
            if (chat.f() != null) {
                ArrayList<State.StateItem> arrayList = chat.f().getLogsItems();
                for (State.StateItem stateItem : arrayList) {
                    request.addRequestBodyParameter(stateItem.getKey(), stateItem.getValue());
                }
            }
            this.b.doRequest(request).subscribe((Subscriber)new Subscriber<RequestResponse>(){

                public void onStart() {
                    InstabugSDKLogger.d((Object)this, "uploading chat logs started");
                }

                public void a(RequestResponse requestResponse) {
                    InstabugSDKLogger.v((Object)this, "uploading chat logs onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody());
                }

                public void onCompleted() {
                    InstabugSDKLogger.d((Object)this, "uploading chat logs completed");
                    callbacks.onSucceeded(true);
                }

                public void onError(Throwable throwable) {
                    InstabugSDKLogger.d((Object)this, "uploading chat logs got error: " + throwable.getMessage());
                    callbacks.onFailed(chat);
                }

                public /* synthetic */ void onNext(Object object) {
                    this.a((RequestResponse)object);
                }
            });
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.d(this, "uploading chat logs got Json error: " + jSONException.getMessage());
            callbacks.onFailed(chat);
        }
    }
}

