/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.instabug.library.Instabug;
import com.instabug.library.settings.SettingsManager;

public class Colorizer {
    public static Drawable getPrimaryColorTintedDrawable(@NonNull Drawable drawable2) {
        return Colorizer.getTintedDrawable(Instabug.getPrimaryColor(), drawable2);
    }

    public static Drawable getTintedDrawable(int n, @NonNull Drawable drawable2) {
        drawable2.clearColorFilter();
        drawable2.setColorFilter(n, PorterDuff.Mode.SRC_IN);
        return drawable2;
    }

    public static void applyPrimaryColorTint(@NonNull ImageView imageView) {
        Colorizer.applyTint(Instabug.getPrimaryColor(), imageView);
    }

    public static void applyTint(int n, @NonNull ImageView imageView) {
        imageView.clearColorFilter();
        imageView.setColorFilter((ColorFilter)new PorterDuffColorFilter(n, PorterDuff.Mode.SRC_IN));
    }

    public static ColorFilter getPrimaryColorFilter() {
        return new PorterDuffColorFilter(SettingsManager.getInstance().getPrimaryColor(), PorterDuff.Mode.SRC_IN);
    }
}

