/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.support.annotation.NonNull;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class DiskUtils {
    public static File getInstabugDirectory(@NonNull Context context) {
        String string2;
        if (context.getExternalFilesDir(null) != null && Environment.getExternalStorageState().equals("mounted")) {
            try {
                string2 = context.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException nullPointerException) {
                string2 = DiskUtils.getInternalStoragePath(context);
                InstabugSDKLogger.i(AttachmentsUtility.class, "External storage not available, saving file to internal storage.");
            }
        } else {
            string2 = DiskUtils.getInternalStoragePath(context);
            InstabugSDKLogger.i(AttachmentsUtility.class, "External storage not available, saving file to internal storage.");
        }
        File file = new File(string2 + "/instabug/");
        if (!file.exists() && file.mkdirs()) {
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    private static String getInternalStoragePath(Context context) {
        return context.getFilesDir().getAbsolutePath();
    }

    public static void saveBitmapOnDisk(Bitmap bitmap, File file) throws IOException {
        if (bitmap != null && file != null) {
            InstabugSDKLogger.v(DiskUtils.class, "starting save viewHierarchy image, path: " + file.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            InstabugSDKLogger.v(DiskUtils.class, "viewHierarchy image saved, path: " + file.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
        }
    }

    public static void cleanDirectory(File file) {
        File[] fileArray;
        if (file.exists() && file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (!file2.delete()) continue;
                InstabugSDKLogger.v(DiskUtils.class, "file deleted successfully, path: " + file2.getPath() + ", time in MS: " + System.currentTimeMillis());
            }
        }
    }

    public static void copyFromUriIntoFile(Context context, Uri uri, File file) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(context.getContentResolver().openInputStream(uri));
        InstabugSDKLogger.d(AttachmentsUtility.class, "Target file path: " + file.getPath());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(context.getContentResolver().openOutputStream(Uri.fromFile((File)file)));
        byte[] byArray = new byte[32768];
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.close();
        bufferedInputStream.close();
    }

    public static void deleteFile(final String string2) {
        PoolProvider.postIOTask(new Runnable(){

            @Override
            public void run() {
                File file = new File(string2);
                file.delete();
            }
        });
    }
}

