/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.support.annotation.NonNull;
import java.util.List;

public class StringUtility {
    public static String trimString(String string2) {
        return StringUtility.trimString(string2, 4096);
    }

    public static String trimString(String string2, int n) {
        if (string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static String[] trimStrings(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = StringUtility.trimString(stringArray[i]);
        }
        return stringArray;
    }

    public static boolean isNumeric(String string2) {
        return string2.matches("\\d+(?:\\.\\d+)?");
    }

    public static int compareVersion(String stringArray, String stringArray2) throws NumberFormatException {
        stringArray = stringArray.split("\\.");
        stringArray2 = stringArray2.split("\\.");
        for (int i = 0; i < stringArray.length || i < stringArray2.length; ++i) {
            if (i < stringArray.length && i < stringArray2.length) {
                if (Integer.parseInt(stringArray[i]) < Integer.parseInt(stringArray2[i])) {
                    return -1;
                }
                if (Integer.parseInt(stringArray[i]) <= Integer.parseInt(stringArray2[i])) continue;
                return 1;
            }
            if (i < stringArray.length) {
                if (Integer.parseInt(stringArray[i]) == 0) continue;
                return 1;
            }
            if (i >= stringArray2.length || Integer.parseInt(stringArray2[i]) == 0) continue;
            return -1;
        }
        return 0;
    }

    public static String removeExtension(@NonNull String string2) {
        return string2.replaceFirst("[.][^.]+$", "");
    }

    public static String toCommaSeparated(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size() - 1; ++i) {
            stringBuilder.append(list.get(i));
            stringBuilder.append(",");
        }
        stringBuilder.append(list.get(list.size() - 1));
        return stringBuilder.toString();
    }
}

