/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import com.instabug.library.util.InstabugSDKLogger;

public class PermissionsUtils {
    public static boolean isPermissionGranted(@NonNull Context context, @NonNull String string2) {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                int n = ContextCompat.checkSelfPermission((Context)context, (String)string2);
                n = n == 0 ? 1 : 0;
                InstabugSDKLogger.d(PermissionsUtils.class, "Permission " + string2 + " state is " + (n != 0 ? "" : "NOT ") + "granted");
                return n != 0;
            }
            int n = context.checkCallingOrSelfPermission(string2);
            n = n == 0 ? 1 : 0;
            InstabugSDKLogger.d(PermissionsUtils.class, "Permission " + string2 + " state is " + (n != 0 ? "" : "NOT ") + "granted");
            return n != 0;
        }
        catch (Error | Exception throwable) {
            return true;
        }
    }

    public static void requestPermission(@NonNull Activity activity, @NonNull String string2, int n, @Nullable Runnable runnable, @Nullable Runnable runnable2) {
        if (!PermissionsUtils.isPermissionGranted((Context)activity, string2)) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)string2)) {
                PermissionsUtils.runIfValid(runnable);
            }
            InstabugSDKLogger.d(PermissionsUtils.class, "Permission " + string2 + " not granted, requesting it");
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{string2}, (int)n);
            return;
        }
        InstabugSDKLogger.d(PermissionsUtils.class, "Permission " + string2 + " already granted, running after permission granted runnable");
        PermissionsUtils.runIfValid(runnable2);
    }

    public static void requestPermission(@NonNull Fragment fragment, @NonNull String string2, int n, @Nullable Runnable runnable, @Nullable Runnable runnable2) {
        if (!PermissionsUtils.isPermissionGranted(fragment.getContext(), string2)) {
            if (!fragment.shouldShowRequestPermissionRationale(string2)) {
                PermissionsUtils.runIfValid(runnable);
            }
            InstabugSDKLogger.d(PermissionsUtils.class, "Permission " + string2 + " not granted, requesting it");
            fragment.requestPermissions(new String[]{string2}, n);
            return;
        }
        InstabugSDKLogger.d(PermissionsUtils.class, "Permission " + string2 + " already granted, running after permission granted runnable");
        PermissionsUtils.runIfValid(runnable2);
    }

    private static void runIfValid(Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
    }
}

