/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import com.instabug.library.Instabug;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.HashSet;

public class OrientationUtils {
    private static HashSet<String> lockedActivities = new HashSet();

    private OrientationUtils() {
    }

    public static void unlockOrientation(Activity activity) {
        if (activity != null) {
            if (!lockedActivities.contains(activity.getClass().getName())) {
                return;
            }
            InstabugSDKLogger.d(OrientationUtils.class, "Unlocking orientation for activity " + activity.toString());
            Object object = new ComponentName((Context)activity, activity.getClass());
            PackageManager packageManager = activity.getPackageManager();
            try {
                object = packageManager.getActivityInfo(object, 128);
                activity.setRequestedOrientation(object.screenOrientation);
                return;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                object = nameNotFoundException;
                nameNotFoundException.printStackTrace();
                activity.setRequestedOrientation(-1);
                return;
            }
            catch (Exception exception) {
                activity.setRequestedOrientation(-1);
            }
        }
    }

    public static void lockScreenOrientation(Activity activity) {
        InstabugSDKLogger.d(OrientationUtils.class, "Locking orientation for activity " + activity.toString());
        int n = activity.getWindowManager().getDefaultDisplay().getRotation();
        switch (activity.getResources().getConfiguration().orientation) {
            case 1: {
                if (n == 1 || n == 2) {
                    activity.setRequestedOrientation(9);
                    break;
                }
                activity.setRequestedOrientation(1);
                break;
            }
            case 2: {
                if (n == 0 || n == 1) {
                    activity.setRequestedOrientation(0);
                    break;
                }
                activity.setRequestedOrientation(8);
            }
        }
        lockedActivities.add(activity.getClass().getName());
    }

    public static void handelOrientation(Activity activity) {
        if (SettingsManager.getInstance().getRequestedOrientation() == -2) {
            OrientationUtils.lockScreenOrientation(activity);
            return;
        }
        activity.setRequestedOrientation(Instabug.getRequestedOrientation());
    }

    public static int getOrientation(int n) {
        switch (n) {
            case -1: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
        }
        return -1;
    }

    public static boolean isInLandscape(Activity activity) {
        if (activity != null) {
            return activity.getResources().getConfiguration().orientation == 2;
        }
        return false;
    }
}

