/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import rx.Observable;
import rx.functions.Func0;
import rx.schedulers.Schedulers;

public class DiskUtils {
    @Nullable
    public static synchronized Uri zipFiles(Context object, String object2, ArrayList<File> object3) {
        InstabugSDKLogger.v(DiskUtils.class, "zipping " + ((ArrayList)object3).size() + " files ... , time in MS:" + System.currentTimeMillis());
        try {
            object = new File(AttachmentManager.getAttachmentDirectory((Context)object) + File.separator + (String)object2 + "_" + System.currentTimeMillis() + ".zip");
            object2 = new FileOutputStream((File)object);
            object2 = new ZipOutputStream((OutputStream)object2);
            object3 = ((ArrayList)object3).iterator();
            while (object3.hasNext()) {
                File file = (File)object3.next();
                if (file == null) continue;
                ((ZipOutputStream)object2).putNextEntry(new ZipEntry(file.getName()));
                DiskUtils.copy(file, (OutputStream)object2);
                ((ZipOutputStream)object2).closeEntry();
            }
            if (((File)object).length() != 0L) {
                ((ZipOutputStream)object2).close();
            }
            InstabugSDKLogger.v(DiskUtils.class, "zipping files have been finished successfully, path: " + ((File)object).getPath() + ", time in MS: " + System.currentTimeMillis());
            return Uri.fromFile((File)object);
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(DiskUtils.class, "zipping files went wrong: " + iOException.getMessage() + ", time in MS: " + System.currentTimeMillis(), iOException);
            return null;
        }
    }

    private static void copy(File object, OutputStream outputStream) throws IOException {
        try {
            object = new FileInputStream((File)object);
            DiskUtils.copy((InputStream)object, outputStream);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            InstabugSDKLogger.e(DiskUtils.class, "FileNotFoundException: can not copy file to another stream");
            return;
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static ArrayList<File> listFilesInDirectory(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        List<File> list = Arrays.asList(fileArray);
        InstabugSDKLogger.v(DiskUtils.class, "listing " + fileArray.length + " files ... at Directory name: " + file.getName() + "Directory path: " + file.getPath() + ", time in MS:" + System.currentTimeMillis());
        arrayList.addAll(list);
        return arrayList;
    }

    @NonNull
    public static Observable<List<File>> getCleanDirectoryObservable(File file) {
        return Observable.defer((Func0)new Func0<Observable<List<File>>>(file){
            private /* synthetic */ File a;
            {
                this.a = file;
            }

            public final /* synthetic */ Object call() {
                File[] fileArray = this;
                ArrayList<File> arrayList = new ArrayList<File>();
                if (fileArray.a.exists() && fileArray.a.isDirectory() && (fileArray = fileArray.a.listFiles()) != null) {
                    for (File file : fileArray) {
                        if (file.delete()) continue;
                        arrayList.add(file);
                    }
                }
                return Observable.just(arrayList);
            }
        }).subscribeOn(Schedulers.io());
    }
}

