/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.support.annotation.RequiresApi;
import android.util.DisplayMetrics;
import android.util.Property;
import android.util.TypedValue;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.instabug.library.ui.custom.MaterialMenu;

@RequiresApi(api=14)
public class MaterialMenuDrawable
extends Drawable
implements Animatable,
MaterialMenu {
    public static final int DEFAULT_COLOR = -1;
    public static final int DEFAULT_SCALE = 1;
    public static final int DEFAULT_TRANSFORM_DURATION = 800;
    public static final boolean DEFAULT_VISIBLE = true;
    private static final int BASE_DRAWABLE_WIDTH = 40;
    private static final int BASE_DRAWABLE_HEIGHT = 40;
    private static final int BASE_ICON_WIDTH = 20;
    private static final int BASE_CIRCLE_RADIUS = 18;
    private static final float ARROW_MID_LINE_ANGLE = 180.0f;
    private static final float ARROW_TOP_LINE_ANGLE = 135.0f;
    private static final float ARROW_BOT_LINE_ANGLE = 225.0f;
    private static final float X_TOP_LINE_ANGLE = 44.0f;
    private static final float X_BOT_LINE_ANGLE = -44.0f;
    private static final float X_ROTATION_ANGLE = 90.0f;
    private static final float CHECK_MIDDLE_ANGLE = 135.0f;
    private static final float CHECK_BOTTOM_ANGLE = -90.0f;
    private static final float TRANSFORMATION_START = 0.0f;
    private static final float TRANSFORMATION_MID = 1.0f;
    private static final float TRANSFORMATION_END = 2.0f;
    private static final int DEFAULT_CIRCLE_ALPHA = 200;
    private final float diph;
    private final float dip1;
    private final float dip2;
    private final float dip3;
    private final float dip4;
    private final float dip8;
    private final int width;
    private final int height;
    private final float strokeWidth;
    private final float iconWidth;
    private final float topPadding;
    private final float sidePadding;
    private final float circleRadius;
    private final Stroke stroke;
    private final Object lock = new Object();
    private final Paint iconPaint = new Paint();
    private final Paint circlePaint = new Paint();
    private float transformationValue = 0.0f;
    private boolean transformationRunning = false;
    private IconState currentIconState = IconState.BURGER;
    private AnimationState animationState = AnimationState.BURGER_ARROW;
    private IconState animatingIconState;
    private boolean visible;
    private boolean rtlEnabled;
    private ObjectAnimator transformation;
    private Animator.AnimatorListener animatorListener;
    private MaterialMenuState materialMenuState;
    private Property<MaterialMenuDrawable, Float> transformationProperty = new Property<MaterialMenuDrawable, Float>(Float.class, "transformation"){

        public Float get(MaterialMenuDrawable materialMenuDrawable) {
            return materialMenuDrawable.getTransformationValue();
        }

        public void set(MaterialMenuDrawable materialMenuDrawable, Float f2) {
            materialMenuDrawable.setTransformationValue(f2);
        }
    };

    public MaterialMenuDrawable(Context context, int n, Stroke stroke) {
        this(context, n, stroke, 1, 800);
    }

    public MaterialMenuDrawable(Context context, int n, Stroke stroke, int n2) {
        this(context, n, stroke, 1, n2);
    }

    public MaterialMenuDrawable(Context context, int n, Stroke stroke, int n2, int n3) {
        context = context.getResources();
        this.dip1 = MaterialMenuDrawable.dpToPx((Resources)context, 1.0f) * (float)n2;
        this.dip2 = MaterialMenuDrawable.dpToPx((Resources)context, 2.0f) * (float)n2;
        this.dip3 = MaterialMenuDrawable.dpToPx((Resources)context, 3.0f) * (float)n2;
        this.dip4 = MaterialMenuDrawable.dpToPx((Resources)context, 4.0f) * (float)n2;
        this.dip8 = MaterialMenuDrawable.dpToPx((Resources)context, 8.0f) * (float)n2;
        this.diph = this.dip1 / 2.0f;
        this.stroke = stroke;
        this.visible = true;
        this.width = (int)(MaterialMenuDrawable.dpToPx((Resources)context, 40.0f) * (float)n2);
        this.height = (int)(MaterialMenuDrawable.dpToPx((Resources)context, 40.0f) * (float)n2);
        this.iconWidth = MaterialMenuDrawable.dpToPx((Resources)context, 20.0f) * (float)n2;
        this.circleRadius = MaterialMenuDrawable.dpToPx((Resources)context, 18.0f) * (float)n2;
        this.strokeWidth = MaterialMenuDrawable.dpToPx((Resources)context, stroke.strokeWidth) * (float)n2;
        this.sidePadding = ((float)this.width - this.iconWidth) / 2.0f;
        this.topPadding = ((float)this.height - 5.0f * this.dip3) / 2.0f;
        this.initPaint(n);
        this.initAnimations(n3);
        this.materialMenuState = new MaterialMenuState();
    }

    private MaterialMenuDrawable(int n, Stroke stroke, long l, int n2, int n3, float f2, float f3, float f4, float f5) {
        this.dip1 = f5;
        this.dip2 = f5 * 2.0f;
        this.dip3 = f5 * 3.0f;
        this.dip4 = f5 * 4.0f;
        this.dip8 = f5 * 8.0f;
        this.diph = f5 / 2.0f;
        this.stroke = stroke;
        this.width = n2;
        this.height = n3;
        this.iconWidth = f2;
        this.circleRadius = f3;
        this.strokeWidth = f4;
        this.sidePadding = ((float)n2 - f2) / 2.0f;
        this.topPadding = ((float)n3 - 5.0f * this.dip3) / 2.0f;
        this.initPaint(n);
        this.initAnimations((int)l);
        this.materialMenuState = new MaterialMenuState();
    }

    private void initPaint(int n) {
        this.iconPaint.setAntiAlias(true);
        this.iconPaint.setStyle(Paint.Style.STROKE);
        this.iconPaint.setStrokeWidth(this.strokeWidth);
        this.iconPaint.setColor(n);
        this.circlePaint.setAntiAlias(true);
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.circlePaint.setColor(n);
        this.circlePaint.setAlpha(200);
        this.setBounds(0, 0, this.width, this.height);
    }

    public void draw(Canvas canvas) {
        float f2;
        if (!this.visible) {
            return;
        }
        float f3 = f2 = this.transformationValue <= 1.0f ? this.transformationValue : 2.0f - this.transformationValue;
        if (this.rtlEnabled) {
            canvas.save();
            canvas.scale(-1.0f, 1.0f, 0.0f, 0.0f);
            canvas.translate((float)(-this.getIntrinsicWidth()), 0.0f);
        }
        this.drawTopLine(canvas, f2);
        this.drawMiddleLine(canvas, f2);
        this.drawBottomLine(canvas, f2);
        if (this.rtlEnabled) {
            canvas.restore();
        }
    }

    private void drawMiddleLine(Canvas canvas, float f2) {
        canvas.restore();
        canvas.save();
        float f3 = 0.0f;
        float f4 = this.width / 2;
        float f5 = this.width / 2;
        float f6 = this.sidePadding;
        float f7 = this.topPadding + this.dip3 / 2.0f * 5.0f;
        float f8 = (float)this.width - this.sidePadding;
        float f9 = this.topPadding + this.dip3 / 2.0f * 5.0f;
        int n = 255;
        switch (this.animationState) {
            case BURGER_ARROW: {
                f3 = this.isMorphingForward() ? f2 * 180.0f : 180.0f + (1.0f - f2) * 180.0f;
                f8 -= f2 * this.resolveStrokeModifier(f2) / 2.0f;
                break;
            }
            case BURGER_X: {
                n = (int)((1.0f - f2) * 255.0f);
                break;
            }
            case ARROW_X: {
                n = (int)((1.0f - f2) * 255.0f);
                f6 += (1.0f - f2) * this.dip2;
                break;
            }
            case ARROW_CHECK: {
                f3 = this.isMorphingForward() ? f2 * 135.0f : 135.0f - 135.0f * (1.0f - f2);
                f6 += this.dip3 / 2.0f + this.dip4 - (1.0f - f2) * this.dip2;
                f8 += f2 * this.dip1;
                f4 = (float)(this.width / 2) + this.dip3 + this.diph;
                break;
            }
            case BURGER_CHECK: {
                f3 = f2 * 135.0f;
                f6 += f2 * (this.dip4 + this.dip3 / 2.0f);
                f8 += f2 * this.dip1;
                f4 = (float)(this.width / 2) + this.dip3 + this.diph;
                break;
            }
            case X_CHECK: {
                n = (int)(f2 * 255.0f);
                f3 = f2 * 135.0f;
                f6 += f2 * (this.dip4 + this.dip3 / 2.0f);
                f8 += f2 * this.dip1;
                f4 = (float)(this.width / 2) + this.dip3 + this.diph;
            }
        }
        this.iconPaint.setAlpha(n);
        canvas.rotate(f3, f4, f5);
        canvas.drawLine(f6, f7, f8, f9, this.iconPaint);
        this.iconPaint.setAlpha(255);
    }

    private void drawTopLine(Canvas canvas, float f2) {
        canvas.save();
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = (float)(this.width / 2) + this.dip3 / 2.0f;
        float f8 = this.topPadding + this.dip2;
        float f9 = this.sidePadding;
        float f10 = this.topPadding + this.dip2;
        float f11 = (float)this.width - this.sidePadding;
        float f12 = this.topPadding + this.dip2;
        int n = 255;
        switch (this.animationState) {
            case BURGER_ARROW: {
                f3 = this.isMorphingForward() ? f2 * 225.0f : 225.0f + (1.0f - f2) * 135.0f;
                f4 = this.width / 2;
                f5 = this.height / 2;
                f11 -= this.resolveStrokeModifier(f2);
                f9 += this.dip3 * f2;
                break;
            }
            case BURGER_X: {
                f3 = 44.0f * f2;
                f6 = 90.0f * f2;
                f4 = this.sidePadding + this.dip4;
                f5 = this.topPadding + this.dip3;
                f9 += this.dip3 * f2;
                break;
            }
            case ARROW_X: {
                f3 = 225.0f + -181.0f * f2;
                f6 = 90.0f * f2;
                f4 = (float)(this.width / 2) + (this.sidePadding + this.dip4 - (float)(this.width / 2)) * f2;
                f5 = (float)(this.height / 2) + (this.topPadding + this.dip3 - (float)(this.height / 2)) * f2;
                f11 -= this.resolveStrokeModifier(f2);
                f9 += this.dip3;
                break;
            }
            case ARROW_CHECK: {
                n = (int)((1.0f - f2) * 255.0f);
                f3 = 225.0f;
                f4 = this.width / 2;
                f5 = this.height / 2;
                f11 -= this.resolveStrokeModifier(1.0f);
                f9 += this.dip3;
                break;
            }
            case BURGER_CHECK: {
                n = (int)((1.0f - f2) * 255.0f);
                break;
            }
            case X_CHECK: {
                f3 = 44.0f;
                f6 = 90.0f;
                f4 = this.sidePadding + this.dip4;
                f5 = this.topPadding + this.dip3;
                f11 += this.dip3 - this.dip3 * (1.0f - f2);
                f9 += this.dip3;
                n = (int)((1.0f - f2) * 255.0f);
            }
        }
        this.iconPaint.setAlpha(n);
        canvas.rotate(f3, f4, f5);
        canvas.rotate(f6, f7, f8);
        canvas.drawLine(f9, f10, f11, f12, this.iconPaint);
        this.iconPaint.setAlpha(255);
    }

    private void drawBottomLine(Canvas canvas, float f2) {
        canvas.restore();
        canvas.save();
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = (float)(this.width / 2) + this.dip3 / 2.0f;
        float f8 = (float)this.height - this.topPadding - this.dip2;
        float f9 = this.sidePadding;
        float f10 = (float)this.height - this.topPadding - this.dip2;
        float f11 = (float)this.width - this.sidePadding;
        float f12 = (float)this.height - this.topPadding - this.dip2;
        switch (this.animationState) {
            case BURGER_ARROW: {
                f3 = this.isMorphingForward() ? 135.0f * f2 : 135.0f + (1.0f - f2) * 225.0f;
                f4 = this.width / 2;
                f5 = this.height / 2;
                f11 = (float)this.width - this.sidePadding - this.resolveStrokeModifier(f2);
                f9 = this.sidePadding + this.dip3 * f2;
                break;
            }
            case BURGER_X: {
                f6 = this.isMorphingForward() ? -90.0f * f2 : 90.0f * f2;
                f3 = -44.0f * f2;
                f4 = this.sidePadding + this.dip4;
                f5 = (float)this.height - this.topPadding - this.dip3;
                f9 += this.dip3 * f2;
                break;
            }
            case ARROW_X: {
                f3 = 135.0f + 181.0f * f2;
                f6 = -90.0f * f2;
                f4 = (float)(this.width / 2) + (this.sidePadding + this.dip4 - (float)(this.width / 2)) * f2;
                f5 = (float)(this.height / 2) + ((float)(this.height / 2) - this.topPadding - this.dip3) * f2;
                f11 -= this.resolveStrokeModifier(f2);
                f9 += this.dip3;
                break;
            }
            case ARROW_CHECK: {
                f3 = 135.0f + f2 * -90.0f;
                f4 = (float)(this.width / 2) + this.dip3 * f2;
                f5 = (float)(this.height / 2) - this.dip3 * f2;
                f11 -= this.resolveStrokeModifier(1.0f);
                f9 += this.dip3 + (this.dip4 + this.dip1) * f2;
                break;
            }
            case BURGER_CHECK: {
                f3 = f2 * 45.0f;
                f4 = (float)(this.width / 2) + this.dip3 * f2;
                f5 = (float)(this.height / 2) - this.dip3 * f2;
                f9 += this.dip8 * f2;
                f11 -= this.resolveStrokeModifier(f2);
                break;
            }
            case X_CHECK: {
                f6 = -90.0f * (1.0f - f2);
                f3 = -44.0f + 89.0f * f2;
                f4 = this.sidePadding + this.dip4 + ((float)(this.width / 2) + this.dip3 - this.sidePadding - this.dip4) * f2;
                f5 = (float)this.height - this.topPadding - this.dip3 + (this.topPadding + (float)(this.height / 2) - (float)this.height) * f2;
                f9 += this.dip8 - (this.dip4 + this.dip1) * (1.0f - f2);
                f11 -= this.resolveStrokeModifier(1.0f - f2);
            }
        }
        canvas.rotate(f3, f4, f5);
        canvas.rotate(f6, f7, f8);
        canvas.drawLine(f9, f10, f11, f12, this.iconPaint);
    }

    private boolean isMorphingForward() {
        return this.transformationValue <= 1.0f;
    }

    private float resolveStrokeModifier(float f2) {
        switch (this.stroke) {
            case REGULAR: {
                if (this.animationState == AnimationState.ARROW_X || this.animationState == AnimationState.X_CHECK) {
                    return this.dip3 - this.dip3 * f2;
                }
                return f2 * this.dip3;
            }
            case THIN: {
                if (this.animationState == AnimationState.ARROW_X || this.animationState == AnimationState.X_CHECK) {
                    return this.dip3 + this.diph - (this.dip3 + this.diph) * f2;
                }
                return f2 * (this.dip3 + this.diph);
            }
            case EXTRA_THIN: {
                if (this.animationState == AnimationState.ARROW_X || this.animationState == AnimationState.X_CHECK) {
                    return this.dip4 - (this.dip3 + this.dip1) * f2;
                }
                return f2 * this.dip4;
            }
        }
        return 0.0f;
    }

    public void setAlpha(int n) {
        this.iconPaint.setAlpha(n);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.iconPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -2;
    }

    @Override
    public void setColor(int n) {
        this.iconPaint.setColor(n);
        this.circlePaint.setColor(n);
        this.invalidateSelf();
    }

    @Override
    @RequiresApi(api=11)
    public void setTransformationDuration(int n) {
        this.transformation.setDuration((long)n);
    }

    @Override
    public void setInterpolator(Interpolator interpolator) {
        this.transformation.setInterpolator((TimeInterpolator)interpolator);
    }

    @Override
    public void setAnimationListener(Animator.AnimatorListener animatorListener) {
        if (this.animatorListener != null) {
            this.transformation.removeListener(this.animatorListener);
        }
        if (animatorListener != null) {
            this.transformation.addListener(animatorListener);
        }
        this.animatorListener = animatorListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIconState(IconState iconState) {
        Object object = this.lock;
        synchronized (object) {
            if (this.transformationRunning) {
                this.transformation.cancel();
                this.transformationRunning = false;
            }
            if (this.currentIconState == iconState) {
                return;
            }
            switch (iconState) {
                case BURGER: {
                    this.animationState = AnimationState.BURGER_ARROW;
                    this.transformationValue = 0.0f;
                    break;
                }
                case ARROW: {
                    this.animationState = AnimationState.BURGER_ARROW;
                    this.transformationValue = 1.0f;
                    break;
                }
                case X: {
                    this.animationState = AnimationState.BURGER_X;
                    this.transformationValue = 1.0f;
                    break;
                }
                case CHECK: {
                    this.animationState = AnimationState.BURGER_CHECK;
                    this.transformationValue = 1.0f;
                }
            }
            this.currentIconState = iconState;
            this.invalidateSelf();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void animateIconState(IconState iconState) {
        Object object = this.lock;
        synchronized (object) {
            if (this.transformationRunning) {
                this.transformation.end();
            }
            this.animatingIconState = iconState;
            this.start();
            return;
        }
    }

    @Override
    public IconState setTransformationOffset(AnimationState animationState, float f2) {
        if (f2 < 0.0f || f2 > 2.0f) {
            throw new IllegalArgumentException(String.format("Value must be between %s and %s", Float.valueOf(0.0f), Float.valueOf(2.0f)));
        }
        this.animationState = animationState;
        boolean bl = f2 < 1.0f || f2 == 2.0f;
        this.currentIconState = bl ? animationState.getFirstState() : animationState.getSecondState();
        this.animatingIconState = bl ? animationState.getSecondState() : animationState.getFirstState();
        this.setTransformationValue(Float.valueOf(f2));
        return this.currentIconState;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
        this.invalidateSelf();
    }

    @Override
    public void setRTLEnabled(boolean bl) {
        this.rtlEnabled = bl;
        this.invalidateSelf();
    }

    @Override
    public IconState getIconState() {
        return this.currentIconState;
    }

    public boolean isDrawableVisible() {
        return this.visible;
    }

    public Float getTransformationValue() {
        return Float.valueOf(this.transformationValue);
    }

    public void setTransformationValue(Float f2) {
        this.transformationValue = f2.floatValue();
        this.invalidateSelf();
    }

    private void initAnimations(int n) {
        this.transformation = ObjectAnimator.ofFloat((Object)this, this.transformationProperty, (float[])new float[]{0.0f});
        this.transformation.setInterpolator((TimeInterpolator)new DecelerateInterpolator(3.0f));
        this.transformation.setDuration((long)n);
        this.transformation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                MaterialMenuDrawable.this.transformationRunning = false;
                MaterialMenuDrawable.this.setIconState(MaterialMenuDrawable.this.animatingIconState);
            }
        });
    }

    private boolean resolveTransformation() {
        boolean bl;
        boolean bl2 = this.currentIconState == IconState.BURGER;
        boolean bl3 = this.currentIconState == IconState.ARROW;
        boolean bl4 = this.currentIconState == IconState.X;
        boolean bl5 = this.currentIconState == IconState.CHECK;
        boolean bl6 = this.animatingIconState == IconState.BURGER;
        boolean bl7 = this.animatingIconState == IconState.ARROW;
        boolean bl8 = this.animatingIconState == IconState.X;
        boolean bl9 = bl = this.animatingIconState == IconState.CHECK;
        if (bl2 && bl7 || bl3 && bl6) {
            this.animationState = AnimationState.BURGER_ARROW;
            return bl2;
        }
        if (bl3 && bl8 || bl4 && bl7) {
            this.animationState = AnimationState.ARROW_X;
            return bl3;
        }
        if (bl2 && bl8 || bl4 && bl6) {
            this.animationState = AnimationState.BURGER_X;
            return bl2;
        }
        if (bl3 && bl || bl5 && bl7) {
            this.animationState = AnimationState.ARROW_CHECK;
            return bl3;
        }
        if (bl2 && bl || bl5 && bl6) {
            this.animationState = AnimationState.BURGER_CHECK;
            return bl2;
        }
        if (bl4 && bl || bl5 && bl8) {
            this.animationState = AnimationState.X_CHECK;
            return bl4;
        }
        throw new IllegalStateException(String.format("Animating from %s to %s is not supported", new Object[]{this.currentIconState, this.animatingIconState}));
    }

    public void start() {
        if (this.transformationRunning) {
            return;
        }
        if (this.animatingIconState != null && this.animatingIconState != this.currentIconState) {
            this.transformationRunning = true;
            boolean bl = this.resolveTransformation();
            this.transformation.setFloatValues(new float[]{bl ? 0.0f : 1.0f, bl ? 1.0f : 2.0f});
            this.transformation.start();
        }
        this.invalidateSelf();
    }

    public void stop() {
        if (this.isRunning() && this.transformation.isRunning()) {
            this.transformation.end();
            return;
        }
        this.transformationRunning = false;
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.transformationRunning;
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    public Drawable.ConstantState getConstantState() {
        this.materialMenuState.changingConfigurations = this.getChangingConfigurations();
        return this.materialMenuState;
    }

    public Drawable mutate() {
        this.materialMenuState = new MaterialMenuState();
        return this;
    }

    static float dpToPx(Resources resources, float f2) {
        return TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)resources.getDisplayMetrics());
    }

    final class MaterialMenuState
    extends Drawable.ConstantState {
        private int changingConfigurations;

        private MaterialMenuState() {
        }

        public final Drawable newDrawable() {
            MaterialMenuDrawable materialMenuDrawable = new MaterialMenuDrawable(MaterialMenuDrawable.this.circlePaint.getColor(), MaterialMenuDrawable.this.stroke, MaterialMenuDrawable.this.transformation.getDuration(), MaterialMenuDrawable.this.width, MaterialMenuDrawable.this.height, MaterialMenuDrawable.this.iconWidth, MaterialMenuDrawable.this.circleRadius, MaterialMenuDrawable.this.strokeWidth, MaterialMenuDrawable.this.dip1);
            materialMenuDrawable.setIconState(MaterialMenuDrawable.this.animatingIconState != null ? MaterialMenuDrawable.this.animatingIconState : MaterialMenuDrawable.this.currentIconState);
            materialMenuDrawable.setVisible(MaterialMenuDrawable.this.visible);
            materialMenuDrawable.setRTLEnabled(MaterialMenuDrawable.this.rtlEnabled);
            return materialMenuDrawable;
        }

        public final int getChangingConfigurations() {
            return this.changingConfigurations;
        }
    }

    public static enum Stroke {
        REGULAR(3),
        THIN(2),
        EXTRA_THIN(1);

        private final int strokeWidth;

        private Stroke(int n2) {
            this.strokeWidth = n2;
        }

        protected static Stroke valueOf(int n) {
            switch (n) {
                case 3: {
                    return REGULAR;
                }
                case 2: {
                    return THIN;
                }
                case 1: {
                    return EXTRA_THIN;
                }
            }
            return THIN;
        }
    }

    public static enum AnimationState {
        BURGER_ARROW,
        BURGER_X,
        ARROW_X,
        ARROW_CHECK,
        BURGER_CHECK,
        X_CHECK;


        public final IconState getFirstState() {
            switch (this) {
                case BURGER_ARROW: {
                    return IconState.BURGER;
                }
                case BURGER_X: {
                    return IconState.BURGER;
                }
                case ARROW_X: {
                    return IconState.ARROW;
                }
                case ARROW_CHECK: {
                    return IconState.ARROW;
                }
                case BURGER_CHECK: {
                    return IconState.BURGER;
                }
                case X_CHECK: {
                    return IconState.X;
                }
            }
            return null;
        }

        public final IconState getSecondState() {
            switch (this) {
                case BURGER_ARROW: {
                    return IconState.ARROW;
                }
                case BURGER_X: {
                    return IconState.X;
                }
                case ARROW_X: {
                    return IconState.X;
                }
                case ARROW_CHECK: {
                    return IconState.CHECK;
                }
                case BURGER_CHECK: {
                    return IconState.CHECK;
                }
                case X_CHECK: {
                    return IconState.CHECK;
                }
            }
            return null;
        }
    }

    public static enum IconState {
        BURGER,
        ARROW,
        X,
        CHECK;

    }
}

