/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.screenshot;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.content.res.AppCompatResources;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import com.instabug.library.R;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.invocation.b;
import com.instabug.library.screenshot.a;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ScreenUtility;
import com.instabug.library.view.ViewUtils;
import rx.Subscription;
import rx.functions.Action1;

public class ExtraScreenshotHelper {
    private ImageButton captureButton;
    private boolean isCaptureButtonShown = false;
    private Subscription currentActivityLifeCycleSubscription;
    private OnCaptureListener onCaptureListener;

    public void init(OnCaptureListener onCaptureListener) {
        this.onCaptureListener = onCaptureListener;
        this.subscribeToCurranActivityLifeCycle();
        b.c().h();
    }

    public void release() {
        this.captureButton = null;
        this.onCaptureListener = null;
        if (this.currentActivityLifeCycleSubscription != null && !this.currentActivityLifeCycleSubscription.isUnsubscribed()) {
            this.currentActivityLifeCycleSubscription.unsubscribe();
        }
        b.c().i();
    }

    private void show(@NonNull Activity activity) {
        if (this.isCaptureButtonShown) {
            InstabugSDKLogger.v(this, "bar already shown");
            return;
        }
        this.captureButton = this.createCaptureButton(activity);
        ViewCompat.setElevation((View)this.captureButton, (float)ViewUtils.convertDpToPx((Context)activity, 5.0f));
        ((ViewGroup)activity.getWindow().getDecorView()).addView((View)this.captureButton, (ViewGroup.LayoutParams)this.createCaptureButtonContainer(activity));
        this.isCaptureButtonShown = true;
        this.captureButton.setOnClickListener(new View.OnClickListener(this, activity){
            private /* synthetic */ Activity a;
            private /* synthetic */ ExtraScreenshotHelper b;
            {
                this.b = extraScreenshotHelper;
                this.a = activity;
            }

            public final void onClick(View view) {
                this.b.hide();
                this.b.captureExtraScreenshot(this.a, this.b.onCaptureListener);
            }
        });
    }

    private ImageButton createCaptureButton(Activity activity) {
        ImageButton imageButton = new ImageButton((Context)activity);
        imageButton.setId(R.id.instabug_extra_screenshot_button);
        imageButton.setScaleType(ImageView.ScaleType.CENTER);
        imageButton.setBackgroundDrawable(Colorizer.getPrimaryColorTintedDrawable(ContextCompat.getDrawable((Context)activity, (int)R.drawable.instabug_bg_white_oval)));
        imageButton.setImageDrawable(AppCompatResources.getDrawable((Context)activity, (int)R.drawable.ib_ic_core_screenshot));
        return imageButton;
    }

    private FrameLayout.LayoutParams createCaptureButtonContainer(Activity activity) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 81);
        layoutParams.setMargins(0, 0, 0, 20);
        Resources resources = activity.getResources();
        if (Build.VERSION.SDK_INT >= 21 && ScreenUtility.hasNavBar(resources) && !ScreenUtility.isLandscape(activity)) {
            layoutParams.bottomMargin += ScreenUtility.getNavigationBarHeight(resources);
        }
        return layoutParams;
    }

    private void captureExtraScreenshot(Activity activity, OnCaptureListener onCaptureListener) {
        a.a(activity, new a.a(this, activity, onCaptureListener){
            private /* synthetic */ Activity b;
            final /* synthetic */ OnCaptureListener a;
            {
                this.b = activity;
                this.a = onCaptureListener;
            }

            @Override
            public final void a(Bitmap bitmap) {
                BitmapUtils.saveBitmap(bitmap, (Context)this.b, new BitmapUtils.a(this){
                    private /* synthetic */ 2 a;
                    {
                        this.a = var1_1;
                    }

                    @Override
                    public final void a(Uri uri) {
                        this.a.a.onExtraScreenshotCaptured(uri);
                    }

                    @Override
                    public final void a(Throwable throwable) {
                        InstabugSDKLogger.e(ExtraScreenshotHelper.class, throwable.getMessage(), throwable);
                    }
                });
            }

            @Override
            public final void a(Throwable throwable) {
                InstabugSDKLogger.e(ExtraScreenshotHelper.class, throwable.getMessage(), throwable);
            }
        });
    }

    private void hide() {
        if (this.isCaptureButtonShown && this.captureButton != null && this.captureButton.getParent() != null && this.captureButton.getParent() instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)this.captureButton.getParent();
            viewGroup.removeView((View)this.captureButton);
            this.isCaptureButtonShown = false;
        }
    }

    private void subscribeToCurranActivityLifeCycle() {
        this.currentActivityLifeCycleSubscription = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Action1<ActivityLifeCycleEvent>(this){
            private /* synthetic */ ExtraScreenshotHelper a;
            {
                this.a = extraScreenshotHelper;
            }

            public final /* synthetic */ void call(Object object) {
                ActivityLifeCycleEvent activityLifeCycleEvent = (ActivityLifeCycleEvent)((Object)object);
                object = this;
                switch (activityLifeCycleEvent) {
                    case RESUMED: {
                        object.a.handleCurrentActivityResumeEvent();
                        return;
                    }
                    case PAUSED: {
                        object.a.handleCurrentActivityPauseEvent();
                    }
                }
            }
        });
    }

    private void handleCurrentActivityResumeEvent() {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            this.show(activity);
            return;
        }
        InstabugSDKLogger.v(ExtraScreenshotHelper.class, "current activity equal null");
    }

    private void handleCurrentActivityPauseEvent() {
        this.hide();
    }

    public static interface OnCaptureListener {
        public void onExtraScreenshotCaptured(Uri var1);
    }
}

