/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.support.annotation.NonNull;
import com.instabug.library.Instabug;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.network.c;
import com.instabug.library.network.d;
import com.instabug.library.user.a;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Scanner;
import java.util.zip.GZIPOutputStream;
import org.json.JSONException;
import rx.Observable;
import rx.Subscriber;

public class NetworkManager {
    public static final String APP_TOKEN = "application_token";
    public static final String UUID = "uuid";
    private static final int DEFAULT_READ_TIME_OUT = 10000;
    private static final int DEFAULT_CONNECTION_TIME_OUT = 15000;

    public static boolean isOnline(Context context) {
        try {
            if (context != null && (context = (ConnectivityManager)context.getSystemService("connectivity")) != null && (context = context.getActiveNetworkInfo()) != null && context.isConnectedOrConnecting()) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            InstabugSDKLogger.w(NetworkManager.class, "Could not read network state. To enable please add the following line in your AndroidManifest.xml <uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\"/>\n" + securityException.getMessage());
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(NetworkManager.class, "Something went wrong while checking network state", exception);
        }
        return false;
    }

    public Observable<RequestResponse> doRequest(@NonNull Request request) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RequestResponse>(this, request){
            private /* synthetic */ Request a;
            private /* synthetic */ NetworkManager b;
            {
                this.b = networkManager;
                this.a = request;
            }

            public final /* synthetic */ void call(Object object) {
                Subscriber subscriber = (Subscriber)object;
                object = this;
                try {
                    subscriber.onStart();
                    InstabugSDKLogger.v(NetworkManager.class, "Starting do request");
                    InstabugSDKLogger.v(NetworkManager.class, "Request Url: " + object.a.getRequestUrl());
                    InstabugSDKLogger.v(NetworkManager.class, "Request Type: " + object.a.getRequestMethod().toString());
                    InstabugSDKLogger.v(NetworkManager.class, "Request Body: " + object.a.getRequestBody());
                    HttpURLConnection httpURLConnection = null;
                    switch (object.a.getRequestType()) {
                        case NORMAL: {
                            httpURLConnection = object.b.connectWithNormalType(object.a);
                            break;
                        }
                        case FILE_DOWNLOAD: {
                            httpURLConnection = object.b.connectWithFileDownloadType(object.a);
                            break;
                        }
                        case MULTI_PART: {
                            httpURLConnection = object.b.connectWithMultiPartType(object.a);
                        }
                    }
                    if (httpURLConnection != null) {
                        int n = httpURLConnection.getResponseCode();
                        if (n >= 300) {
                            InstabugSDKLogger.e(NetworkManager.class, "Network request got error");
                            object.b.handleServerConnectionError(httpURLConnection);
                        }
                        InstabugSDKLogger.v(NetworkManager.class, "Network request completed successfully");
                        switch (object.a.getRequestType()) {
                            case NORMAL: {
                                subscriber.onNext((Object)object.b.handleRequestResponse(httpURLConnection));
                                break;
                            }
                            case FILE_DOWNLOAD: {
                                subscriber.onNext((Object)object.b.handleFileDownloadRequestResponse(object.a, httpURLConnection));
                                break;
                            }
                            case MULTI_PART: {
                                subscriber.onNext((Object)object.b.handleMultipartRequestResponse(httpURLConnection));
                            }
                        }
                    }
                    subscriber.onCompleted();
                    return;
                }
                catch (InterruptedIOException interruptedIOException) {
                    InstabugSDKLogger.e(NetworkManager.class, "Request got error: " + object.a.getRequestUrl(), interruptedIOException);
                    subscriber.onError((Throwable)interruptedIOException);
                    return;
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e(NetworkManager.class, "Request got error: " + object.a.getRequestUrl(), iOException);
                    subscriber.onError((Throwable)iOException);
                    return;
                }
                catch (d d2) {
                    InstabugSDKLogger.w(NetworkManager.class, "Request got error: " + object.a.getRequestUrl() + ", error message: " + d2.getMessage());
                    subscriber.onError((Throwable)d2);
                    subscriber.onCompleted();
                    return;
                }
            }
        });
    }

    public Request buildRequest(@NonNull Context context, @NonNull Request.Endpoint endpoint, @NonNull Request.RequestMethod requestMethod) throws JSONException {
        return this.buildRequest(context, endpoint, requestMethod, RequestType.NORMAL);
    }

    public Request buildRequest(@NonNull Context context, @NonNull Request.Endpoint object, @NonNull Request.RequestMethod requestMethod, @NonNull RequestType requestType) throws JSONException {
        object = new Request((Request.Endpoint)((Object)object), requestType);
        ((Request)object).setRequestMethod(requestMethod);
        return this.buildRequest(context, (Request)object);
    }

    public Request buildRequest(@NonNull Context context, @NonNull String string2, @NonNull Request.RequestMethod requestMethod) throws JSONException {
        return this.buildRequest(context, string2, requestMethod, RequestType.NORMAL);
    }

    public Request buildRequest(@NonNull Context context, @NonNull String object, @NonNull Request.RequestMethod requestMethod, @NonNull RequestType requestType) throws JSONException {
        object = new Request((String)object, requestType);
        ((Request)object).setRequestMethod(requestMethod);
        return this.buildRequest(context, (Request)object);
    }

    public Request buildRequestWithoutUUID(@NonNull Context object, @NonNull Request.Endpoint endpoint, @NonNull Request.RequestMethod requestMethod) throws JSONException {
        object = new Request(endpoint, RequestType.NORMAL);
        ((Request)object).setRequestMethod(requestMethod);
        ((Request)object).addParameter(APP_TOKEN, Instabug.getAppToken());
        return object;
    }

    private Request buildRequest(@NonNull Context context, Request request) throws JSONException {
        request.addParameter(APP_TOKEN, Instabug.getAppToken());
        request.addParameter(UUID, a.f());
        return request;
    }

    public HttpURLConnection buildConnection(@NonNull Request object) throws IOException {
        Object object2 = new URL(((Request)object).getRequestUrl());
        object2 = (HttpURLConnection)((URL)object2).openConnection();
        ((URLConnection)object2).setRequestProperty("Content-Type", "application/json");
        ((URLConnection)object2).setRequestProperty("Accept-Charset", "UTF-8");
        ((URLConnection)object2).setRequestProperty("Content-Encoding", "gzip");
        for (Request.RequestParameter requestParameter : ((Request)object).getHeaders()) {
            ((URLConnection)object2).setRequestProperty(requestParameter.getKey(), (String)requestParameter.getValue());
        }
        ((URLConnection)object2).setDoInput(true);
        return object2;
    }

    private HttpURLConnection setURLConnectionDefaultTimeOut(@NonNull HttpURLConnection httpURLConnection) {
        return this.setURLConnectionTimeOut(httpURLConnection, 10000, 15000);
    }

    public HttpURLConnection setURLConnectionTimeOut(@NonNull HttpURLConnection httpURLConnection, int n, int n2) {
        httpURLConnection.setReadTimeout(n);
        httpURLConnection.setConnectTimeout(n2);
        return httpURLConnection;
    }

    private HttpURLConnection connectWithNormalType(Request request) throws IOException {
        InstabugSDKLogger.v(this, "Connect to: " + request.getRequestUrl() + " with normal type");
        HttpURLConnection httpURLConnection = this.buildConnection(request);
        this.setURLConnectionDefaultTimeOut(httpURLConnection);
        httpURLConnection.setRequestMethod(request.getRequestMethod().toString());
        if (request.getRequestMethod() == Request.RequestMethod.Post || request.getRequestMethod() == Request.RequestMethod.put) {
            httpURLConnection.setDoOutput(true);
            this.writeRequestBody(httpURLConnection.getOutputStream(), request.getRequestBody());
        }
        return httpURLConnection;
    }

    private void writeRequestBody(OutputStream outputStream, String string2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(string2.getBytes(Charset.forName("UTF8")));
        gZIPOutputStream.close();
        outputStream.write(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
    }

    private HttpURLConnection connectWithFileDownloadType(Request request) throws IOException {
        InstabugSDKLogger.v(this, "Connect to: " + request.getRequestUrl() + " with fileDownload type");
        return this.connectWithNormalType(request);
    }

    private HttpURLConnection connectWithMultiPartType(Request request) throws IOException {
        InstabugSDKLogger.v(this, "Connect to: " + request.getRequestUrl() + " with multiPart type");
        HttpURLConnection httpURLConnection = this.buildConnection(request);
        httpURLConnection.setRequestMethod(request.getRequestMethod().toString());
        httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
        httpURLConnection.setRequestProperty("Cache-Control", "no-cache");
        httpURLConnection.setRequestProperty("Content-Encoding", "");
        c c2 = new c(httpURLConnection);
        for (Request.RequestParameter requestParameter : request.getRequestBodyParameters()) {
            c2.a(requestParameter.getKey(), requestParameter.getValue().toString());
        }
        Request.FileToUpload fileToUpload = request.getFileToUpload();
        c2.a(fileToUpload.getFilePartName(), new File(fileToUpload.getFilePath()), fileToUpload.getFileName(), fileToUpload.getFileType());
        c2.a();
        return httpURLConnection;
    }

    private RequestResponse handleRequestResponse(HttpURLConnection httpURLConnection) throws IOException {
        RequestResponse requestResponse = new RequestResponse();
        int n = httpURLConnection.getResponseCode();
        requestResponse.setResponseCode(n);
        InstabugSDKLogger.v(this, "Request response code: " + n);
        String string2 = this.convertStreamToString(httpURLConnection.getInputStream());
        requestResponse.setResponseBody(string2);
        InstabugSDKLogger.v(this, "Request response: " + string2);
        httpURLConnection.disconnect();
        return requestResponse;
    }

    private RequestResponse handleMultipartRequestResponse(HttpURLConnection httpURLConnection) throws IOException {
        return this.handleRequestResponse(httpURLConnection);
    }

    private RequestResponse handleFileDownloadRequestResponse(Request request, HttpURLConnection httpURLConnection) throws IOException {
        RequestResponse requestResponse = new RequestResponse();
        int n = httpURLConnection.getResponseCode();
        requestResponse.setResponseCode(n);
        InstabugSDKLogger.v(this, "File downloader request response code: " + n);
        this.copyStream(httpURLConnection.getInputStream(), new FileOutputStream(request.getDownloadedFile()));
        requestResponse.setResponseBody(request.getDownloadedFile());
        InstabugSDKLogger.v(this, "File downloader request response: " + request.getDownloadedFile().getPath());
        httpURLConnection.disconnect();
        return requestResponse;
    }

    private void handleServerConnectionError(HttpURLConnection object) throws IOException, d {
        ((HttpURLConnection)object).getResponseCode();
        object = ((HttpURLConnection)object).getErrorStream();
        InstabugSDKLogger.e(this, "Error getting Network request response: " + this.convertStreamToString((InputStream)object));
    }

    private String convertStreamToString(InputStream closeable) {
        if (((Scanner)(closeable = new Scanner((InputStream)closeable, "UTF-8").useDelimiter("\\A"))).hasNext()) {
            return ((Scanner)closeable).next();
        }
        return "";
    }

    private void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        while ((n = inputStream.read()) != -1) {
            outputStream.write(n);
        }
    }

    public static enum RequestType {
        NORMAL,
        MULTI_PART,
        FILE_DOWNLOAD;

    }
}

