/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.content.Context;
import com.instabug.library.Feature;
import com.instabug.library.b;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.internal.storage.cache.UserAttributesCacheManager;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.a;
import com.instabug.library.model.c;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.d;
import com.instabug.library.user.UserEvent;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class State
implements Cacheable,
Serializable {
    public static final String KEY_APP_PACKAGE_NAME = "bundle_id";
    public static final String KEY_APP_VERSION = "app_version";
    public static final String KEY_BATTERY_LEVEL = "battery_level";
    public static final String KEY_BATTERY_STATUS = "battery_state";
    public static final String KEY_CARRIER = "carrier";
    public static final String KEY_CONSOLE_LOG = "console_log";
    public static final String KEY_CURRENT_VIEW = "current_view";
    public static final String KEY_DENSITY = "density";
    public static final String KEY_DEVICE = "device";
    public static final String KEY_DEVICE_ROOTED = "device_rooted";
    public static final String KEY_DURATION = "duration";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_INSTABUG_LOG = "instabug_log";
    public static final String KEY_LOCALE = "locale";
    public static final String KEY_MEMORY_FREE = "memory_free";
    public static final String KEY_MEMORY_TOTAL = "memory_total";
    public static final String KEY_MEMORY_USED = "memory_used";
    public static final String KEY_ORIENTATION = "orientation";
    public static final String KEY_OS = "os";
    public static final String KEY_REPORTED_AT = "reported_at";
    public static final String KEY_SCREEN_SIZE = "screen_size";
    public static final String KEY_SDK_VERSION = "sdk_version";
    public static final String KEY_STORAGE_FREE = "storage_free";
    public static final String KEY_STORAGE_TOTAL = "storage_total";
    public static final String KEY_STORAGE_USED = "storage_used";
    public static final String KEY_TAGS = "tags";
    public static final String KEY_USER_DATA = "user_data";
    public static final String KEY_USER_STEPS = "user_steps";
    public static final String KEY_WIFI_SSID = "wifi_ssid";
    public static final String KEY_WIFI_STATE = "wifi_state";
    public static final String KEY_USER_ATTRIBUTES = "user_attributes";
    public static final String KEY_NETWORK_LOGS = "network_log";
    public static final String KEY_USER_EVENTS = "user_events";
    public static final String KEY_VISUAL_USER_STEPS = "user_repro_steps";
    public static final String KEY_SESSIONS_PROFILER = "sessions_profiler";
    private String sdkVersion;
    private String locale;
    private long duration;
    private String device;
    private boolean isDeviceRooted;
    private String OS;
    private String carrier;
    private String appPackageName;
    private String appVersion;
    private int batteryLevel;
    private String batteryState;
    private boolean wifiState;
    private String wifiSSID;
    private long usedMemory;
    private long freeMemory;
    private long totalMemory;
    private long usedStorage;
    private long freeStorage;
    private long totalStorage;
    private String screenDensity;
    private String screenSize;
    private String ScreenOrientation;
    private String currentView;
    private String instabugLog;
    private ArrayList<a> consoleLog;
    private ArrayList<c> userSteps;
    private ArrayList<com.instabug.library.visualusersteps.b> visualUserSteps;
    private com.instabug.library.sessionprofiler.model.timeline.c sessionProfilerTimeline;
    private String userEmail;
    private String userData;
    private long reportedAt;
    private String tags;
    private String networkLogs;
    private String userAttributes;
    private String userEvents;

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public State setSdkVersion(String string2) {
        this.sdkVersion = string2;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public State setLocale(String string2) {
        this.locale = string2;
        return this;
    }

    public long getDuration() {
        return this.duration;
    }

    public State setDuration(long l) {
        this.duration = l;
        return this;
    }

    public String getDevice() {
        return this.device;
    }

    public State setDevice(String string2) {
        this.device = string2;
        return this;
    }

    public boolean isDeviceRooted() {
        return this.isDeviceRooted;
    }

    public State setIsDeviceRooted(boolean bl) {
        this.isDeviceRooted = bl;
        return this;
    }

    public String getOS() {
        return this.OS;
    }

    public State setOS(String string2) {
        this.OS = string2;
        return this;
    }

    public String getCarrier() {
        return this.carrier;
    }

    public State setCarrier(String string2) {
        this.carrier = string2;
        return this;
    }

    public String getAppPackageName() {
        return this.appPackageName;
    }

    public State setAppPackageName(String string2) {
        this.appPackageName = string2;
        return this;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public State setAppVersion(String string2) {
        this.appVersion = string2;
        return this;
    }

    public int getBatteryLevel() {
        return this.batteryLevel;
    }

    public State setBatteryLevel(int n) {
        this.batteryLevel = n;
        return this;
    }

    public String getBatteryState() {
        return this.batteryState;
    }

    public State setBatteryState(String string2) {
        this.batteryState = string2;
        return this;
    }

    public boolean isWifiEnable() {
        return this.wifiState;
    }

    public State setWifiState(boolean bl) {
        this.wifiState = bl;
        return this;
    }

    public String getWifiSSID() {
        return this.wifiSSID;
    }

    public State setWifiSSID(String string2) {
        this.wifiSSID = string2;
        return this;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public State setUsedMemory(long l) {
        this.usedMemory = l;
        return this;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public State setFreeMemory(long l) {
        this.freeMemory = l;
        return this;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public State setTotalMemory(long l) {
        this.totalMemory = l;
        return this;
    }

    public long getUsedStorage() {
        return this.usedStorage;
    }

    public State setUsedStorage(long l) {
        this.usedStorage = l;
        return this;
    }

    public long getFreeStorage() {
        return this.freeStorage;
    }

    public State setFreeStorage(long l) {
        this.freeStorage = l;
        return this;
    }

    public long getTotalStorage() {
        return this.totalStorage;
    }

    public State setTotalStorage(long l) {
        this.totalStorage = l;
        return this;
    }

    public String getScreenDensity() {
        return this.screenDensity;
    }

    public State setScreenDensity(String string2) {
        this.screenDensity = string2;
        return this;
    }

    public String getScreenSize() {
        return this.screenSize;
    }

    public State setScreenSize(String string2) {
        this.screenSize = string2;
        return this;
    }

    public String getScreenOrientation() {
        return this.ScreenOrientation;
    }

    public State setScreenOrientation(String string2) {
        this.ScreenOrientation = string2;
        return this;
    }

    public String getCurrentView() {
        return this.currentView;
    }

    public State setCurrentView(String string2) {
        this.currentView = string2;
        return this;
    }

    public String getInstabugLog() {
        return this.instabugLog;
    }

    public State setInstabugLog(String string2) {
        this.instabugLog = string2;
        return this;
    }

    public void updateConsoleLog() {
        this.setConsoleLog(Builder.getConsoleLog());
    }

    public JSONArray getConsoleLog() {
        return a.a(this.consoleLog);
    }

    public State setConsoleLog(ArrayList<a> arrayList) {
        this.consoleLog = arrayList;
        return this;
    }

    public JSONArray getUserSteps() {
        return c.a(this.userSteps);
    }

    public State setUserSteps(ArrayList<c> arrayList) {
        this.userSteps = arrayList;
        return this;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public State setUserEmail(String string2) {
        this.userEmail = string2;
        return this;
    }

    public String getUserData() {
        return this.userData;
    }

    public State setUserData(String string2) {
        this.userData = string2;
        return this;
    }

    public long getReportedAt() {
        return this.reportedAt;
    }

    public State setReportedAt(long l) {
        this.reportedAt = l;
        return this;
    }

    public String getTags() {
        return this.tags;
    }

    public State setTags(String string2) {
        this.tags = string2;
        return this;
    }

    public String getUserAttributes() {
        return this.userAttributes;
    }

    public State setUserAttributes(String string2) {
        this.userAttributes = string2;
        return this;
    }

    public String getNetworkLogs() {
        return this.networkLogs;
    }

    public State setNetworkLogs(String string2) {
        this.networkLogs = string2;
        return this;
    }

    public String getUserEvents() {
        return this.userEvents;
    }

    public State setUserEvents(String string2) {
        this.userEvents = string2;
        return this;
    }

    public String getVisualUserSteps() {
        Object object = this.visualUserSteps;
        JSONArray jSONArray = new JSONArray();
        if (object != null && ((ArrayList)object).size() > 0) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                com.instabug.library.visualusersteps.b b2 = (com.instabug.library.visualusersteps.b)object.next();
                jSONArray.put((Object)b2.a());
            }
        }
        return jSONArray.toString();
    }

    public State setVisualUserSteps(ArrayList<com.instabug.library.visualusersteps.b> arrayList) {
        this.visualUserSteps = arrayList;
        return this;
    }

    public String getSessionProfilerTimeline() {
        return this.sessionProfilerTimeline.b().toString();
    }

    public State setSessionProfilerTimeline(com.instabug.library.sessionprofiler.model.timeline.c c2) {
        this.sessionProfilerTimeline = c2;
        return this;
    }

    public ArrayList<StateItem> getStateItems() throws JSONException {
        ArrayList<StateItem> arrayList = new ArrayList<StateItem>();
        arrayList.add(new StateItem().setKey(KEY_APP_PACKAGE_NAME).setValue(this.getAppPackageName()));
        arrayList.add(new StateItem().setKey(KEY_APP_VERSION).setValue(this.getAppVersion()));
        arrayList.add(new StateItem().setKey(KEY_BATTERY_LEVEL).setValue(this.getBatteryLevel()));
        arrayList.add(new StateItem().setKey(KEY_BATTERY_STATUS).setValue(this.getBatteryState()));
        arrayList.add(new StateItem().setKey(KEY_CARRIER).setValue(this.getCarrier()));
        arrayList.add(new StateItem().setKey(KEY_CURRENT_VIEW).setValue(this.getCurrentView()));
        arrayList.add(new StateItem().setKey(KEY_DENSITY).setValue(this.getScreenDensity()));
        arrayList.add(new StateItem().setKey(KEY_DEVICE).setValue(this.getDevice()));
        arrayList.add(new StateItem().setKey(KEY_DEVICE_ROOTED).setValue(this.isDeviceRooted()));
        arrayList.add(new StateItem().setKey(KEY_DURATION).setValue(this.getDuration()));
        arrayList.add(new StateItem().setKey(KEY_EMAIL).setValue(this.getUserEmail()));
        arrayList.add(new StateItem().setKey(KEY_LOCALE).setValue(this.getLocale()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_FREE).setValue(this.getFreeMemory()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_TOTAL).setValue(this.getTotalMemory()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_USED).setValue(this.getUsedMemory()));
        arrayList.add(new StateItem().setKey(KEY_ORIENTATION).setValue(this.getScreenOrientation()));
        arrayList.add(new StateItem().setKey(KEY_OS).setValue(this.getOS()));
        arrayList.add(new StateItem().setKey(KEY_REPORTED_AT).setValue(this.getReportedAt()));
        arrayList.add(new StateItem().setKey(KEY_SCREEN_SIZE).setValue(this.getScreenSize()));
        arrayList.add(new StateItem().setKey(KEY_SDK_VERSION).setValue(this.getSdkVersion()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_FREE).setValue(this.getFreeStorage()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_TOTAL).setValue(this.getTotalStorage()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_USED).setValue(this.getUsedStorage()));
        arrayList.add(new StateItem().setKey(KEY_TAGS).setValue(this.getTags()));
        arrayList.add(new StateItem().setKey(KEY_WIFI_SSID).setValue(this.getWifiSSID()));
        arrayList.add(new StateItem().setKey(KEY_WIFI_STATE).setValue(this.isWifiEnable()));
        arrayList.add(new StateItem().setKey(KEY_USER_ATTRIBUTES).setValue(this.getUserAttributes()));
        return arrayList;
    }

    public ArrayList<StateItem> getLogsItems() {
        ArrayList<StateItem> arrayList = new ArrayList<StateItem>();
        arrayList.add(new StateItem().setKey(KEY_CONSOLE_LOG).setValue(this.getConsoleLog().toString()));
        arrayList.add(new StateItem().setKey(KEY_INSTABUG_LOG).setValue(this.getInstabugLog()));
        arrayList.add(new StateItem().setKey(KEY_USER_DATA).setValue(this.getUserData()));
        arrayList.add(new StateItem().setKey(KEY_NETWORK_LOGS).setValue(this.getNetworkLogs()));
        arrayList.add(new StateItem().setKey(KEY_USER_EVENTS).setValue(this.getUserEvents()));
        if (b.a().b(Feature.TRACK_USER_STEPS) == Feature.State.ENABLED) {
            arrayList.add(new StateItem().setKey(KEY_USER_STEPS).setValue(this.getUserSteps().toString()));
        }
        if (b.a().b(Feature.REPRO_STEPS) == Feature.State.ENABLED) {
            arrayList.add(new StateItem().setKey(KEY_VISUAL_USER_STEPS).setValue(this.getVisualUserSteps()));
        }
        if (b.a().b(Feature.SESSION_PROFILER) == Feature.State.ENABLED && this.sessionProfilerTimeline != null) {
            arrayList.add(new StateItem().setKey(KEY_SESSIONS_PROFILER).setValue(this.getSessionProfilerTimeline()));
        }
        return arrayList;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        ArrayList<StateItem> arrayList = this.getStateItems();
        for (int i = 0; i < arrayList.size(); ++i) {
            jSONObject.put(arrayList.get(i).getKey(), arrayList.get(i).getValue());
        }
        ArrayList<StateItem> arrayList2 = this.getLogsItems();
        for (int i = 0; i < arrayList2.size(); ++i) {
            jSONObject.put(arrayList2.get(i).getKey(), arrayList2.get(i).getValue());
        }
        InstabugSDKLogger.v(this, jSONObject.toString());
        return jSONObject.toString();
    }

    @Override
    public void fromJson(String string2) throws JSONException {
        if ((string2 = new JSONObject(string2)).has(KEY_APP_PACKAGE_NAME)) {
            this.setAppPackageName(string2.getString(KEY_APP_PACKAGE_NAME));
        }
        if (string2.has(KEY_APP_VERSION)) {
            this.setAppVersion(string2.getString(KEY_APP_VERSION));
        }
        if (string2.has(KEY_BATTERY_LEVEL)) {
            this.setBatteryLevel(string2.getInt(KEY_BATTERY_LEVEL));
        }
        if (string2.has(KEY_BATTERY_STATUS)) {
            this.setBatteryState(string2.getString(KEY_BATTERY_STATUS));
        }
        if (string2.has(KEY_CARRIER)) {
            this.setCarrier(string2.getString(KEY_CARRIER));
        }
        if (string2.has(KEY_CONSOLE_LOG)) {
            this.setConsoleLog(a.a(new JSONArray(string2.getString(KEY_CONSOLE_LOG))));
        }
        if (string2.has(KEY_CURRENT_VIEW)) {
            this.setCurrentView(string2.getString(KEY_CURRENT_VIEW));
        }
        if (string2.has(KEY_DENSITY)) {
            this.setScreenDensity(string2.getString(KEY_DENSITY));
        }
        if (string2.has(KEY_DEVICE)) {
            this.setDevice(string2.getString(KEY_DEVICE));
        }
        if (string2.has(KEY_DEVICE_ROOTED)) {
            this.setIsDeviceRooted(string2.getBoolean(KEY_DEVICE_ROOTED));
        }
        if (string2.has(KEY_DURATION)) {
            this.setDuration(string2.getLong(KEY_DURATION));
        }
        if (string2.has(KEY_EMAIL)) {
            this.setUserEmail(string2.getString(KEY_EMAIL));
        }
        if (string2.has(KEY_INSTABUG_LOG)) {
            this.setInstabugLog(string2.getString(KEY_INSTABUG_LOG));
        }
        if (string2.has(KEY_LOCALE)) {
            this.setLocale(string2.getString(KEY_LOCALE));
        }
        if (string2.has(KEY_MEMORY_FREE)) {
            this.setFreeMemory(string2.getLong(KEY_MEMORY_FREE));
        }
        if (string2.has(KEY_MEMORY_TOTAL)) {
            this.setTotalMemory(string2.getLong(KEY_MEMORY_TOTAL));
        }
        if (string2.has(KEY_MEMORY_USED)) {
            this.setUsedMemory(string2.getLong(KEY_MEMORY_USED));
        }
        if (string2.has(KEY_ORIENTATION)) {
            this.setScreenOrientation(string2.getString(KEY_ORIENTATION));
        }
        if (string2.has(KEY_OS)) {
            this.setOS(string2.getString(KEY_OS));
        }
        if (string2.has(KEY_REPORTED_AT)) {
            this.setReportedAt(string2.getLong(KEY_REPORTED_AT));
        }
        if (string2.has(KEY_SCREEN_SIZE)) {
            this.setScreenSize(string2.getString(KEY_SCREEN_SIZE));
        }
        if (string2.has(KEY_SDK_VERSION)) {
            this.setSdkVersion(string2.getString(KEY_SDK_VERSION));
        }
        if (string2.has(KEY_STORAGE_FREE)) {
            this.setFreeStorage(string2.getLong(KEY_STORAGE_FREE));
        }
        if (string2.has(KEY_STORAGE_TOTAL)) {
            this.setTotalStorage(string2.getLong(KEY_STORAGE_TOTAL));
        }
        if (string2.has(KEY_STORAGE_USED)) {
            this.setUsedStorage(string2.getLong(KEY_STORAGE_USED));
        }
        if (string2.has(KEY_TAGS)) {
            this.setTags(string2.getString(KEY_TAGS));
        }
        if (string2.has(KEY_USER_DATA)) {
            this.setUserData(string2.getString(KEY_USER_DATA));
        }
        if (string2.has(KEY_USER_STEPS)) {
            this.setUserSteps(c.a(new JSONArray(string2.getString(KEY_USER_STEPS))));
        }
        if (string2.has(KEY_WIFI_SSID)) {
            this.setWifiSSID(string2.getString(KEY_WIFI_SSID));
        }
        if (string2.has(KEY_WIFI_STATE)) {
            this.setWifiState(string2.getBoolean(KEY_WIFI_STATE));
        }
        if (string2.has(KEY_USER_ATTRIBUTES)) {
            this.setUserAttributes(string2.getString(KEY_USER_ATTRIBUTES));
        }
        if (string2.has(KEY_NETWORK_LOGS)) {
            this.setNetworkLogs(string2.getString(KEY_NETWORK_LOGS));
        }
        if (string2.has(KEY_USER_EVENTS)) {
            this.setUserEvents(string2.getString(KEY_USER_EVENTS));
        }
        if (string2.has(KEY_VISUAL_USER_STEPS)) {
            this.setVisualUserSteps(com.instabug.library.visualusersteps.b.a(new JSONArray(string2.getString(KEY_VISUAL_USER_STEPS))));
        }
        if (string2.has(KEY_SESSIONS_PROFILER)) {
            this.setSessionProfilerTimeline(com.instabug.library.sessionprofiler.model.timeline.c.a(new JSONObject(string2.getString(KEY_SESSIONS_PROFILER))));
        }
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
            InstabugSDKLogger.e(this, "Something went wrong while getting state.toString()" + jSONException2.getMessage(), jSONException2);
            return "error";
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof State) {
            return String.valueOf(((State)(object = (State)object)).getAppVersion()).equals(String.valueOf(this.getAppVersion())) && ((State)object).getBatteryLevel() == this.getBatteryLevel() && String.valueOf(((State)object).getBatteryState()).equals(String.valueOf(this.getBatteryState())) && String.valueOf(((State)object).getCarrier()).equals(String.valueOf(this.getCarrier())) && String.valueOf(((State)object).getConsoleLog()).equals(String.valueOf(this.getConsoleLog())) && String.valueOf(((State)object).getCurrentView()).equals(String.valueOf(this.getCurrentView())) && ((State)object).getDuration() == this.getDuration() && String.valueOf(((State)object).getDevice()).equals(String.valueOf(this.getDevice())) && ((State)object).getFreeMemory() == this.getFreeMemory() && ((State)object).getFreeStorage() == this.getFreeStorage() && String.valueOf(((State)object).getLocale()).equals(String.valueOf(this.getLocale())) && String.valueOf(((State)object).getOS()).equals(String.valueOf(this.getOS())) && ((State)object).getReportedAt() == this.getReportedAt() && String.valueOf(((State)object).getScreenDensity()).equals(String.valueOf(this.getScreenDensity())) && String.valueOf(((State)object).getScreenOrientation()).equals(String.valueOf(this.getScreenOrientation())) && String.valueOf(((State)object).getScreenSize()).equals(String.valueOf(this.getScreenSize())) && String.valueOf(((State)object).getSdkVersion()).equals(String.valueOf(this.getSdkVersion())) && ((State)object).getTotalMemory() == this.getTotalMemory() && ((State)object).getTotalStorage() == this.getTotalStorage() && String.valueOf(((State)object).getTags()).equals(String.valueOf(this.getTags())) && ((State)object).getUsedMemory() == this.getUsedMemory() && ((State)object).getUsedStorage() == this.getUsedStorage() && String.valueOf(((State)object).getUserData()).equals(String.valueOf(this.getUserData())) && String.valueOf(((State)object).getUserEmail()).equals(String.valueOf(this.getUserEmail())) && String.valueOf(((State)object).getUserSteps()).equals(String.valueOf(this.getUserSteps())) && String.valueOf(((State)object).getWifiSSID()).equals(String.valueOf(this.getWifiSSID())) && ((State)object).isDeviceRooted() == this.isDeviceRooted() && ((State)object).isWifiEnable() == this.isWifiEnable() && String.valueOf(((State)object).getInstabugLog()).equals(String.valueOf(this.getInstabugLog())) && String.valueOf(((State)object).getUserAttributes()).equals(String.valueOf(this.getUserAttributes())) && String.valueOf(((State)object).getNetworkLogs()).equals(String.valueOf(this.getNetworkLogs())) && String.valueOf(((State)object).getUserEvents()).equals(String.valueOf(this.getUserEvents())) && String.valueOf(((State)object).getVisualUserSteps()).equals(String.valueOf(this.getVisualUserSteps())) && String.valueOf(((State)object).getSessionProfilerTimeline()).equals(String.valueOf(this.getSessionProfilerTimeline()));
        }
        return false;
    }

    public int hashCode() {
        return String.valueOf(this.getReportedAt()).hashCode();
    }

    public static class Builder
    implements Serializable {
        private Context context;

        public Builder(Context context) {
            this.context = context;
        }

        private static ArrayList<a> getConsoleLog() {
            ArrayList<a> arrayList = new ArrayList<a>();
            if (b.a().b(Feature.CONSOLE_LOGS) == Feature.State.ENABLED) {
                try {
                    Object object;
                    Object object2 = Runtime.getRuntime().exec("logcat -v time -d " + android.os.Process.myPid());
                    object2 = new BufferedReader(new InputStreamReader(((Process)object2).getInputStream(), Charset.forName("UTF-8")));
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    while ((object = ((BufferedReader)object2).readLine()) != null) {
                        arrayList2.add((String)object);
                    }
                    ((BufferedReader)object2).close();
                    arrayList2.trimToSize();
                    int n = 0;
                    if (arrayList2.size() > 700) {
                        n = arrayList2.size() - 700;
                    }
                    while (n < arrayList2.size()) {
                        if (((String)arrayList2.get(n)).length() > 18) {
                            object = new a();
                            ((a)object).a(((String)arrayList2.get(n)).substring(18));
                            ((a)object).a(a.b(((String)arrayList2.get(n)).substring(0, 18)));
                            arrayList.add((a)object);
                        }
                        ++n;
                    }
                    arrayList2.clear();
                    return arrayList;
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e(Builder.class, "Could not read logcat log", iOException);
                    return arrayList;
                }
            }
            return arrayList;
        }

        public State build(boolean bl) {
            State state = new State().setSdkVersion(DeviceStateProvider.getSdkVersion()).setLocale(DeviceStateProvider.getLocale(this.context)).setDuration(DeviceStateProvider.getActiveSessionDuration()).setDevice(DeviceStateProvider.getDevice()).setIsDeviceRooted(DeviceStateProvider.isDeviceRooted()).setOS(DeviceStateProvider.getOS()).setCarrier(DeviceStateProvider.getCarrier(this.context)).setAppVersion(DeviceStateProvider.getAppVersion(this.context)).setAppPackageName(DeviceStateProvider.getAppPackageName(this.context)).setBatteryLevel(DeviceStateProvider.getBatteryLevel(this.context)).setBatteryState(DeviceStateProvider.getBatteryState(this.context)).setWifiState(DeviceStateProvider.getWifiState(this.context)).setWifiSSID(DeviceStateProvider.getWifiSSID(this.context)).setFreeMemory(DeviceStateProvider.getFreeMemory(this.context)).setUsedMemory(DeviceStateProvider.getUsedMemory(this.context)).setTotalMemory(DeviceStateProvider.getTotalMemory(this.context)).setFreeStorage(DeviceStateProvider.getFreeStorage()).setUsedStorage(DeviceStateProvider.getUsedStorage()).setTotalStorage(DeviceStateProvider.getTotalStorage()).setScreenDensity(DeviceStateProvider.getScreenDensity(this.context)).setScreenSize(DeviceStateProvider.getScreenSize(this.context)).setScreenOrientation(DeviceStateProvider.getScreenOrientation(this.context)).setCurrentView(DeviceStateProvider.getCurrentView()).setConsoleLog(Builder.getConsoleLog()).setUserSteps(this.getUserSteps()).setUserEmail(this.getUserEmail()).setUserData(this.getUserData()).setReportedAt(this.getReportedAt()).setTags(this.getTags()).setUserAttributes(UserAttributesCacheManager.getUserAttributes()).setNetworkLogs(this.getNetworkLogs()).setUserEvents(this.getUserEvents()).setVisualUserSteps(this.getVisualUserSteps()).setSessionProfilerTimeline(this.getSessionProfilerTimeline());
            if (bl) {
                state.setInstabugLog(this.getInstabugLog());
            }
            return state;
        }

        public State buildInternalState() {
            return new State().setSdkVersion(DeviceStateProvider.getSdkVersion()).setLocale(DeviceStateProvider.getLocale(this.context)).setDuration(DeviceStateProvider.getActiveSessionDuration()).setDevice(DeviceStateProvider.getDevice()).setIsDeviceRooted(DeviceStateProvider.isDeviceRooted()).setOS(DeviceStateProvider.getOS()).setCarrier(DeviceStateProvider.getCarrier(this.context)).setAppVersion(DeviceStateProvider.getAppVersion(this.context)).setAppPackageName(DeviceStateProvider.getAppPackageName(this.context)).setBatteryLevel(DeviceStateProvider.getBatteryLevel(this.context)).setBatteryState(DeviceStateProvider.getBatteryState(this.context)).setWifiState(DeviceStateProvider.getWifiState(this.context)).setWifiSSID(DeviceStateProvider.getWifiSSID(this.context)).setFreeMemory(DeviceStateProvider.getFreeMemory(this.context)).setUsedMemory(DeviceStateProvider.getUsedMemory(this.context)).setTotalMemory(DeviceStateProvider.getTotalMemory(this.context)).setFreeStorage(DeviceStateProvider.getFreeStorage()).setUsedStorage(DeviceStateProvider.getUsedStorage()).setTotalStorage(DeviceStateProvider.getTotalStorage()).setScreenDensity(DeviceStateProvider.getScreenDensity(this.context)).setScreenSize(DeviceStateProvider.getScreenSize(this.context)).setScreenOrientation(DeviceStateProvider.getScreenOrientation(this.context)).setCurrentView(DeviceStateProvider.getCurrentView()).setReportedAt(this.getReportedAt());
        }

        public String formatSessionDuration(long l) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = (int)l % 60;
            int n2 = (int)(l /= 60L) % 60;
            int n3 = (int)(l /= 60L) % 60;
            if (n3 <= 9) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n3);
            stringBuilder.append(":");
            if (n2 <= 9) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n2);
            stringBuilder.append(":");
            if (n <= 9) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n);
            return stringBuilder.toString();
        }

        private String getInstabugLog() {
            if (b.a().b(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
                return InstabugLog.getLogs();
            }
            return null;
        }

        private ArrayList<c> getUserSteps() {
            return d.a().c();
        }

        private ArrayList<com.instabug.library.visualusersteps.b> getVisualUserSteps() {
            return com.instabug.library.visualusersteps.d.a().b();
        }

        private com.instabug.library.sessionprofiler.model.timeline.c getSessionProfilerTimeline() {
            return com.instabug.library.sessionprofiler.a.a().e();
        }

        private String getUserEmail() {
            return com.instabug.library.user.a.e();
        }

        private String getUserData() {
            return SettingsManager.getInstance().getUserData();
        }

        private long getReportedAt() {
            return InstabugDateFormatter.getCurrentUTCTimeStampInSeconds();
        }

        private String getTags() {
            return SettingsManager.getInstance().getTagsAsString();
        }

        public String getNetworkLogs() {
            return com.instabug.library.core.eventbus.coreeventbus.a.d();
        }

        private String getUserEvents() {
            try {
                return UserEvent.toJson(InstabugUserEventLogger.getInstance().getUserEvents()).toString();
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(this, "Got error while parsing user events logs", jSONException);
                return "";
            }
        }

        private String getUserAttributes() {
            String string2 = "{}";
            HashMap<String, String> hashMap = UserAttributesCacheManager.getAll();
            if (hashMap != null && hashMap.size() != 0) {
                com.instabug.library.model.b b2 = new com.instabug.library.model.b();
                b2.a(hashMap);
                try {
                    string2 = b2.toJson();
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e(this, "parsing user attributes got error: " + jSONException.getMessage(), jSONException);
                }
            }
            return string2;
        }
    }

    public static class StateItem<V>
    implements Serializable {
        String key;
        V value;

        public String getKey() {
            return this.key;
        }

        public StateItem<V> setKey(String string2) {
            this.key = string2;
            return this;
        }

        public V getValue() {
            return this.value;
        }

        public StateItem<V> setValue(V v) {
            this.value = v;
            return this;
        }

        public String toString() {
            return "key: " + this.getKey() + ", value: " + this.getValue();
        }
    }
}

