/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.media.MediaMuxer;
import com.instabug.library.Instabug;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class InstabugVideoUtils {
    private static final String TAG = "InstabugVideoUtils";

    @TargetApi(value=18)
    public String mux(String string2, String string3) throws IOException {
        File file = AttachmentManager.getVideoFile(Instabug.getApplicationContext());
        String string4 = file.getAbsolutePath();
        MediaExtractor mediaExtractor = new MediaExtractor();
        mediaExtractor.setDataSource(string3);
        string3 = new MediaExtractor();
        string3.setDataSource(string2);
        InstabugSDKLogger.i(this, "Video Extractor Track Count " + mediaExtractor.getTrackCount());
        InstabugSDKLogger.i(this, "Audio Extractor Track Count " + string3.getTrackCount());
        InstabugSDKLogger.i(this, "Video Extractor Track duration " + mediaExtractor.getCachedDuration());
        InstabugSDKLogger.i(this, "Audio Extractor Track duration " + string3.getCachedDuration());
        string2 = new MediaMuxer(string4, 0);
        mediaExtractor.selectTrack(0);
        string4 = mediaExtractor.getTrackFormat(0);
        int n = string2.addTrack((MediaFormat)string4);
        string3.selectTrack(0);
        MediaFormat mediaFormat = string3.getTrackFormat(0);
        int n2 = string2.addTrack(mediaFormat);
        InstabugSDKLogger.i(this, "Video Format " + string4.toString());
        InstabugSDKLogger.i(this, "Audio Format " + mediaFormat.toString());
        boolean bl = false;
        int n3 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(262144);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(262144);
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        MediaCodec.BufferInfo bufferInfo2 = new MediaCodec.BufferInfo();
        mediaExtractor.seekTo(0L, 0);
        string3.seekTo(0L, 1);
        string2.start();
        while (!bl) {
            bufferInfo.offset = 100;
            bufferInfo.size = mediaExtractor.readSampleData(byteBuffer, 100);
            if (bufferInfo.size < 0 || bufferInfo2.size < 0) {
                InstabugSDKLogger.i(this, "saw input EOS.");
                bl = true;
                bufferInfo.size = 0;
                continue;
            }
            bufferInfo.presentationTimeUs = mediaExtractor.getSampleTime();
            bufferInfo.flags = mediaExtractor.getSampleFlags();
            string2.writeSampleData(n, byteBuffer, bufferInfo);
            mediaExtractor.advance();
            InstabugSDKLogger.i("ContentValues", "Frame (" + ++n3 + ") Video PresentationTimeUs:" + bufferInfo.presentationTimeUs + " Flags:" + bufferInfo.flags + " Size(KB) " + bufferInfo.size / 1024);
            InstabugSDKLogger.i(this, "Frame (" + n3 + ") Audio PresentationTimeUs:" + bufferInfo2.presentationTimeUs + " Flags:" + bufferInfo2.flags + " Size(KB) " + bufferInfo2.size / 1024);
        }
        bl = false;
        while (!bl) {
            bufferInfo2.offset = 100;
            bufferInfo2.size = string3.readSampleData(byteBuffer2, 100);
            if (bufferInfo.size < 0 || bufferInfo2.size < 0) {
                InstabugSDKLogger.i(this, "saw input EOS.");
                bl = true;
                bufferInfo2.size = 0;
                continue;
            }
            bufferInfo2.presentationTimeUs = string3.getSampleTime();
            bufferInfo2.flags = string3.getSampleFlags();
            string2.writeSampleData(n2, byteBuffer2, bufferInfo2);
            string3.advance();
            InstabugSDKLogger.i(this, "Frame (" + n3 + ") Video PresentationTimeUs:" + bufferInfo.presentationTimeUs + " Flags:" + bufferInfo.flags + " Size(KB) " + bufferInfo.size / 1024);
            InstabugSDKLogger.i(this, "Frame (" + n3 + ") Audio PresentationTimeUs:" + bufferInfo2.presentationTimeUs + " Flags:" + bufferInfo2.flags + " Size(KB) " + bufferInfo2.size / 1024);
        }
        string2.stop();
        string2.release();
        return file.getAbsolutePath();
    }

    public static int getVideoDuration(String string2) {
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(string2);
        string2 = mediaMetadataRetriever.extractMetadata(9);
        return Integer.parseInt(string2);
    }

    public static boolean isDurationMoreThanAutoRecMaxDuration(int n, int n2) {
        return n > n2;
    }

    public static File startTrim(File file, File file2, int n) throws IOException {
        if (InstabugVideoUtils.isDurationMoreThanAutoRecMaxDuration(InstabugVideoUtils.getVideoDuration(file.getPath()), n)) {
            int n2 = InstabugVideoUtils.getVideoDuration(file.getPath());
            n = n2 - n;
            InstabugVideoUtils.genVideoUsingMuxer(file.getPath(), file2.getPath(), n, n2, false, true);
            return file2;
        }
        return file;
    }

    @TargetApi(value=21)
    private static void genVideoUsingMuxer(String object, String string2, int n, int n2, boolean bl, boolean bl2) throws IOException {
        int n3;
        int n4;
        Object object2;
        MediaExtractor mediaExtractor = new MediaExtractor();
        mediaExtractor.setDataSource((String)object);
        int n5 = mediaExtractor.getTrackCount();
        string2 = new MediaMuxer(string2, 0);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(n5);
        int n6 = -1;
        for (int i = 0; i < n5; ++i) {
            object2 = mediaExtractor.getTrackFormat(i);
            String string3 = object2.getString("mime");
            n4 = 0;
            if (string3.startsWith("audio/") && bl) {
                n4 = 1;
            } else if (string3.startsWith("video/") && bl2) {
                n4 = 1;
            }
            if (n4 == 0) continue;
            mediaExtractor.selectTrack(i);
            int n7 = string2.addTrack(object2);
            hashMap.put(i, n7);
            if (!object2.containsKey("max-input-size")) continue;
            int n8 = object2.getInteger("max-input-size");
            n6 = n8 > n6 ? n8 : n6;
        }
        if (n6 < 0) {
            n6 = 4096;
        }
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource((String)object);
        object2 = mediaMetadataRetriever.extractMetadata(24);
        if (object2 != null && (n3 = Integer.parseInt((String)object2)) >= 0) {
            string2.setOrientationHint(n3);
        }
        if (n > 0) {
            mediaExtractor.seekTo((long)(n * 1000), 2);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n6);
        object2 = new MediaCodec.BufferInfo();
        try {
            string2.start();
            while (true) {
                object2.offset = 0;
                object2.size = mediaExtractor.readSampleData(byteBuffer, 0);
                if (object2.size < 0) {
                    InstabugSDKLogger.d(TAG, "Saw input EOS.");
                    object2.size = 0;
                    break;
                }
                object2.presentationTimeUs = mediaExtractor.getSampleTime();
                if (n2 > 0 && object2.presentationTimeUs > (long)(n2 * 1000)) {
                    InstabugSDKLogger.d(TAG, "The current sample is over the trim end time.");
                    break;
                }
                object2.flags = mediaExtractor.getSampleFlags();
                n4 = mediaExtractor.getSampleTrackIndex();
                string2.writeSampleData(((Integer)hashMap.get(n4)).intValue(), byteBuffer, (MediaCodec.BufferInfo)object2);
                mediaExtractor.advance();
            }
            string2.stop();
            object = new File((String)object);
            ((File)object).delete();
            return;
        }
        catch (IllegalStateException illegalStateException) {
            InstabugSDKLogger.w(TAG, "The source video file is malformed");
            return;
        }
        finally {
            string2.release();
        }
    }
}

