/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.model.State;
import com.instabug.library.model.b;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.HashMap;
import org.json.JSONException;

public class UserAttributesCacheManager {
    public static final String USER_ATTRIBUTES_DISK_CACHE_FILE_NAME = "/user_attributes.cache";
    public static final String USER_ATTRIBUTES_DISK_CACHE_KEY = "user_attributes_disk_cache";
    public static final String USER_ATTRIBUTES_MEMORY_CACHE_KEY = "user_attributes_memory_cache";
    public static final String USER_ATTRIBUTES_CACHE_KEY = "attrs";

    public static InMemoryCache<String, b> getCache() {
        if (!CacheManager.getInstance().cacheExists(USER_ATTRIBUTES_MEMORY_CACHE_KEY)) {
            Cache cache = CacheManager.getInstance().getCache(USER_ATTRIBUTES_MEMORY_CACHE_KEY);
            InstabugSDKLogger.d(UserAttributesCacheManager.class, "In-memory user attributes cache not found, loading it from disk " + cache);
            CacheManager.getInstance().migrateCache(USER_ATTRIBUTES_DISK_CACHE_KEY, USER_ATTRIBUTES_MEMORY_CACHE_KEY, new CacheManager.KeyExtractor<String, b>(){});
        }
        InstabugSDKLogger.d(UserAttributesCacheManager.class, "In-memory user attributes cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(USER_ATTRIBUTES_MEMORY_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        Cache cache = CacheManager.getInstance().getCache(USER_ATTRIBUTES_MEMORY_CACHE_KEY);
        Cache cache2 = CacheManager.getInstance().getCache(USER_ATTRIBUTES_DISK_CACHE_KEY);
        if (cache != null && cache2 != null) {
            CacheManager.getInstance().migrateCache(cache, cache2, new CacheManager.KeyExtractor<String, b>(){});
        }
    }

    public static void putAttribute(@NonNull String string2, String string3) {
        InMemoryCache<String, b> inMemoryCache = UserAttributesCacheManager.getCache();
        if (inMemoryCache != null) {
            if (inMemoryCache.get(USER_ATTRIBUTES_CACHE_KEY) == null) {
                inMemoryCache.put(USER_ATTRIBUTES_CACHE_KEY, new b());
            }
            inMemoryCache.get(USER_ATTRIBUTES_CACHE_KEY).a(string2, string3);
        }
    }

    @Nullable
    public static String getAttribute(@NonNull String string2) {
        InMemoryCache<String, b> inMemoryCache = UserAttributesCacheManager.getCache();
        if (inMemoryCache != null && (inMemoryCache = inMemoryCache.get(USER_ATTRIBUTES_CACHE_KEY)) != null) {
            return ((b)((Object)inMemoryCache)).a(string2);
        }
        return null;
    }

    public static void deleteAttribute(String string2) {
        InMemoryCache<String, b> inMemoryCache = UserAttributesCacheManager.getCache();
        if (inMemoryCache != null && (inMemoryCache = inMemoryCache.get(USER_ATTRIBUTES_CACHE_KEY)) != null) {
            ((b)((Object)inMemoryCache)).b(string2);
        }
    }

    public static void deleteAll() {
        InMemoryCache<String, b> inMemoryCache = UserAttributesCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.invalidate();
        }
    }

    @Nullable
    public static HashMap<String, String> getAll() {
        InMemoryCache<String, b> inMemoryCache = UserAttributesCacheManager.getCache();
        inMemoryCache = inMemoryCache != null ? UserAttributesCacheManager.getCache().get(USER_ATTRIBUTES_CACHE_KEY) : null;
        if (inMemoryCache == null || ((b)((Object)inMemoryCache)).a() == null || ((b)((Object)inMemoryCache)).a().isEmpty()) {
            return null;
        }
        return ((b)((Object)inMemoryCache)).a();
    }

    public static String getUserAttributes() {
        String string2 = "{}";
        HashMap<String, String> hashMap = UserAttributesCacheManager.getAll();
        if (hashMap != null && hashMap.size() != 0) {
            b b2 = new b();
            b2.a(hashMap);
            try {
                string2 = b2.toJson();
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(State.class, "parsing user attributes got error: " + jSONException.getMessage(), jSONException);
            }
        }
        return string2;
    }
}

