/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.media;

import android.media.MediaPlayer;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AudioPlayer {
    private String filePath;
    private MediaPlayer mediaPlayer;
    private b onGetDurationListener;
    private Map<String, OnStopListener> onStopListeners = new HashMap<String, OnStopListener>();
    private MediaPlayer.OnCompletionListener onCompletionListener;

    private void prepare(a a2) {
        try {
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setDataSource(this.filePath);
            this.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(this, a2){
                private /* synthetic */ a a;
                private /* synthetic */ AudioPlayer b;
                {
                    this.b = audioPlayer;
                    this.a = a2;
                }

                public final void onPrepared(MediaPlayer mediaPlayer) {
                    this.b.doAction(this.a);
                }
            });
            this.mediaPlayer.prepareAsync();
            if (this.onCompletionListener != null) {
                this.mediaPlayer.setOnCompletionListener(this.onCompletionListener);
            }
            return;
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(this, "Playing audio file failed", iOException);
            return;
        }
    }

    public void addOnStopListener(OnStopListener onStopListener) {
        this.onStopListeners.put(onStopListener.getFilePath(), onStopListener);
        if (this.onCompletionListener == null) {
            this.onCompletionListener = new MediaPlayer.OnCompletionListener(this){
                private /* synthetic */ AudioPlayer a;
                {
                    this.a = audioPlayer;
                }

                public final void onCompletion(MediaPlayer mediaPlayer) {
                    this.a.notifyOnStopListeners();
                }
            };
            if (this.mediaPlayer != null) {
                this.mediaPlayer.setOnCompletionListener(this.onCompletionListener);
            }
        }
    }

    private void notifyOnStopListeners() {
        for (OnStopListener onStopListener : this.onStopListeners.values()) {
            onStopListener.onStop();
        }
    }

    private void stream(String string2, a a2) {
        if (string2 == null) {
            InstabugSDKLogger.e(this, "Audio file path can not be null");
            return;
        }
        if (string2.equals(this.filePath)) {
            this.doAction(a2);
            return;
        }
        this.filePath = string2;
        this.prepare(a2);
    }

    public void getDurationAsync(String string2, b b2) {
        this.stream(string2, a.GET_DURATION);
        this.onGetDurationListener = b2;
    }

    public void start(String string2) {
        this.pause();
        this.stream(string2, a.START);
    }

    public void pause() {
        this.notifyOnStopListeners();
        this.doAction(a.PAUSE);
    }

    public void release() {
        this.filePath = null;
        if (this.mediaPlayer != null) {
            if (this.mediaPlayer.isPlaying()) {
                this.mediaPlayer.stop();
            }
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }

    private void doAction(a a2) {
        switch (a2) {
            case START: {
                if (this.mediaPlayer.isPlaying()) break;
                this.mediaPlayer.start();
                return;
            }
            case PAUSE: {
                if (this.mediaPlayer == null || !this.mediaPlayer.isPlaying()) break;
                this.mediaPlayer.pause();
                return;
            }
            case GET_DURATION: {
                this.onGetDurationListener.a(this.mediaPlayer.getDuration());
            }
        }
    }

    public static String getFormattedDurationText(long l) {
        int n = (int)(l / 3600000L);
        int n2 = (int)(l % 3600000L / 60000L);
        int n3 = (int)(l % 60000L / 1000L);
        if (n > 0) {
            return String.format("%02d:%02d:%02d", n, n2, n3);
        }
        return String.format("%02d:%02d", n2, n3);
    }

    public static abstract class OnStopListener {
        private String filePath;

        public String getFilePath() {
            return this.filePath;
        }

        public OnStopListener(String string2) {
            this.filePath = string2;
        }

        public abstract void onStop();
    }

    public static interface b {
        public void a(int var1);
    }

    static enum a {
        START,
        PAUSE,
        GET_DURATION;

    }
}

