/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.instacapture.screenshot;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import com.instabug.library.instacapture.screenshot.FieldHelper;
import com.instabug.library.instacapture.screenshot.RootViewInfo;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;

public final class ScreenshotTaker {
    private ScreenshotTaker() {
    }

    public static Bitmap getScreenshotBitmap(Activity activity, @Nullable @IdRes int[] nArray) {
        if (activity == null) {
            throw new IllegalArgumentException("Parameter activity cannot be null.");
        }
        View view = activity.getWindow().getDecorView();
        List<RootViewInfo> list = FieldHelper.getRootViews(activity, nArray);
        String string2 = "viewRoots count: " + list.size();
        try {
            long l = view.getWidth() * view.getHeight() << 2;
            activity = (ActivityManager)activity.getSystemService("activity");
            string2 = new ActivityManager.MemoryInfo();
            activity.getMemoryInfo((ActivityManager.MemoryInfo)string2);
            activity = l < ((ActivityManager.MemoryInfo)string2).availMem ? Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        }
        catch (IllegalArgumentException | OutOfMemoryError throwable) {
            return null;
        }
        ScreenshotTaker.drawRootsToBitmap(list, (Bitmap)activity, nArray);
        return activity;
    }

    private static void drawRootsToBitmap(List<RootViewInfo> object, Bitmap bitmap, @Nullable @IdRes int[] nArray) {
        object = object.iterator();
        while (object.hasNext()) {
            RootViewInfo rootViewInfo = (RootViewInfo)object.next();
            ScreenshotTaker.drawRootToBitmap(rootViewInfo, bitmap, nArray);
        }
    }

    private static void drawRootToBitmap(RootViewInfo rootViewInfo, Bitmap bitmap, @Nullable @IdRes int[] nArray) {
        View view;
        Canvas canvas;
        if ((rootViewInfo.getLayoutParams().flags & 2) == 2) {
            canvas = new Canvas(bitmap);
            int n = (int)(255.0f * rootViewInfo.getLayoutParams().dimAmount);
            canvas.drawARGB(n, 0, 0, 0);
        }
        canvas = new Canvas(bitmap);
        canvas.translate((float)rootViewInfo.getLeft(), (float)rootViewInfo.getTop());
        int[] nArray2 = null;
        if (nArray != null) {
            nArray2 = new int[nArray.length];
        }
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                view = rootViewInfo.getView().findViewById(nArray[i]);
                if (view == null) continue;
                nArray2[i] = view.getVisibility();
                view.setVisibility(4);
            }
        }
        rootViewInfo.getView().draw(canvas);
        ScreenshotTaker.drawUnDrawableViews(rootViewInfo.getView(), canvas);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                view = rootViewInfo.getView().findViewById(nArray[i]);
                if (view == null) continue;
                view.setVisibility(nArray2[i]);
            }
        }
    }

    private static ArrayList<View> drawUnDrawableViews(View view, Canvas canvas) {
        if (!(view instanceof ViewGroup)) {
            ArrayList<View> arrayList = new ArrayList<View>();
            arrayList.add(view);
            return arrayList;
        }
        ArrayList<View> arrayList = new ArrayList<View>();
        ViewGroup viewGroup = (ViewGroup)view;
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View view2 = viewGroup.getChildAt(i);
            ArrayList<View> arrayList2 = new ArrayList<View>();
            arrayList2.add(view);
            arrayList2.addAll(ScreenshotTaker.drawUnDrawableViews(view2, canvas));
            int[] nArray = new int[2];
            view2.getLocationOnScreen(nArray);
            if (Build.VERSION.SDK_INT >= 14 && view2 instanceof TextureView) {
                ScreenshotTaker.drawTextureView((TextureView)view2, nArray, canvas);
            }
            if (view2 instanceof GLSurfaceView) {
                ScreenshotTaker.drawGLSurfaceView((GLSurfaceView)view2, nArray, canvas);
            }
            if (Build.VERSION.SDK_INT >= 11 && view2 instanceof WebView) {
                ScreenshotTaker.drawWebView((WebView)view2, canvas);
            }
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public static void drawGLSurfaceView(GLSurfaceView object, int[] nArray, Canvas canvas) {
        String string2 = "Drawing GLSurfaceView";
        if (object.getWindowToken() != null) {
            int n = object.getWidth();
            int n2 = object.getHeight();
            int[] nArray2 = new int[n * (n2 + 0)];
            IntBuffer intBuffer = IntBuffer.wrap(nArray2);
            intBuffer.position(0);
            CountDownLatch countDownLatch = new CountDownLatch(1);
            object.queueEvent(new Runnable(n, n2, intBuffer, countDownLatch){
                private /* synthetic */ int a;
                private /* synthetic */ int b;
                private /* synthetic */ IntBuffer c;
                private /* synthetic */ CountDownLatch d;
                {
                    this.a = n;
                    this.b = n2;
                    this.c = intBuffer;
                    this.d = countDownLatch;
                }

                @Override
                public final void run() {
                    EGL10 eGL10 = (EGL10)EGLContext.getEGL();
                    eGL10.eglWaitGL();
                    eGL10 = (GL10)eGL10.eglGetCurrentContext().getGL();
                    eGL10.glFinish();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptedException interruptedException2 = interruptedException;
                        interruptedException.printStackTrace();
                    }
                    eGL10.glReadPixels(0, 0, this.a, 0 + this.b, 6408, 5121, (Buffer)this.c);
                    this.d.countDown();
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                object = interruptedException;
                interruptedException.printStackTrace();
            }
            object = new int[n * n2];
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                for (int i = 0; i < n; ++i) {
                    int n5 = nArray2[n3 * n + i];
                    int n6 = n5 >> 16 & 0xFF;
                    int n7 = n5 << 16 & 0xFF0000;
                    n5 = n5 & 0xFF00FF00 | n7 | n6;
                    object[(n2 - n4 - 1) * n + i] = (GLSurfaceView)n5;
                }
                ++n3;
                ++n4;
            }
            Bitmap bitmap = Bitmap.createBitmap((int[])object, (int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Paint paint = new Paint();
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
            canvas.drawBitmap(bitmap, (float)nArray[0], (float)nArray[1], paint);
            bitmap.recycle();
        }
    }

    @TargetApi(value=14)
    public static void drawTextureView(TextureView textureView, int[] nArray, Canvas canvas) {
        String string2 = "Drawing TextureView";
        if ((textureView = textureView.getBitmap()) != null) {
            string2 = new Paint();
            string2.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
            canvas.drawBitmap((Bitmap)textureView, (float)nArray[0], (float)nArray[1], (Paint)string2);
            textureView.recycle();
        }
    }

    @TargetApi(value=11)
    public static void drawWebView(WebView webView, Canvas canvas) {
        int n = webView.getLayerType();
        if (n == 2) {
            webView.setLayerType(0, null);
            webView.setDrawingCacheEnabled(true);
            webView.buildDrawingCache(true);
            Bitmap bitmap = webView.getDrawingCache();
            if (bitmap != null) {
                Paint paint = new Paint();
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
                int[] nArray = new int[2];
                webView.getLocationOnScreen(nArray);
                canvas.drawBitmap(bitmap, (float)nArray[0], (float)nArray[1], paint);
                bitmap.recycle();
            }
            webView.setDrawingCacheEnabled(false);
            webView.setLayerType(n, null);
        }
    }
}

