/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.instacapture.screenshot;

import android.app.Activity;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.WindowManager;
import com.instabug.library.instacapture.screenshot.RootViewInfo;
import com.instabug.library.util.InstabugSDKLogger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class FieldHelper {
    private static final String FIELD_NAME_WINDOW_MANAGER = "mWindowManager";
    private static final String FIELD_NAME_GLOBAL = "mGlobal";
    private static final String FIELD_NAME_ROOTS = "mRoots";
    private static final String FIELD_NAME_PARAMS = "mParams";
    private static final String FIELD_NAME_VIEW = "mView";

    private FieldHelper() {
    }

    public static List<RootViewInfo> getRootViews(Activity object, @Nullable @IdRes int[] nArray) {
        Object[] objectArray;
        ArrayList<RootViewInfo> arrayList = new ArrayList<RootViewInfo>();
        try {
            object = Build.VERSION.SDK_INT >= 17 ? FieldHelper.getFieldValue(FIELD_NAME_GLOBAL, object.getWindowManager()) : FieldHelper.getFieldValue(FIELD_NAME_WINDOW_MANAGER, object.getWindowManager());
            objectArray = FieldHelper.getFieldValue(FIELD_NAME_ROOTS, object);
            object = FieldHelper.getFieldValue(FIELD_NAME_PARAMS, object);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(FieldHelper.class, "Can't fine one of (WindowManager, rootObjects, paramsObject) field name so screenshot capturing failed", exception);
            return arrayList;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            objectArray = ((List)objectArray).toArray();
            List list = (List)object;
            object = list.toArray(new WindowManager.LayoutParams[list.size()]);
        } else {
            objectArray = objectArray;
            object = object;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                View view = (View)FieldHelper.getFieldValue(FIELD_NAME_VIEW, objectArray[i]);
                boolean bl = false;
                if (nArray != null) {
                    int[] nArray2 = nArray;
                    int n = nArray.length;
                    for (int j = 0; j < n; ++j) {
                        int n2 = nArray2[j];
                        if (n2 != view.getId()) continue;
                        bl = true;
                    }
                }
                if (view.getVisibility() != 0 || bl) continue;
                arrayList.add(new RootViewInfo(view, object[i]));
                continue;
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(FieldHelper.class, "Screenshot capturing failed in one of the viewRoots", exception);
            }
        }
        return arrayList;
    }

    private static Object getFieldValue(String object, Object object2) throws NoSuchFieldException, IllegalAccessException {
        object = ((String)object).equals(FIELD_NAME_WINDOW_MANAGER) ? FieldHelper.findField((String)object, object2.getClass()) : object2.getClass().getDeclaredField((String)object);
        ((Field)object).setAccessible(true);
        return ((Field)object).get(object2);
    }

    private static Field findField(String string2, Class clazz) throws NoSuchFieldException {
        for (Class clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            for (Field field : clazz2.getDeclaredFields()) {
                if (!string2.equals(field.getName())) continue;
                return field;
            }
        }
        throw new NoSuchFieldException("Field: " + string2 + " is not found in class: " + clazz.toString());
    }
}

