/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.analytics;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.instabug.library.Instabug;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.analytics.network.InstabugAnalyticsUploaderService;
import com.instabug.library.analytics.util.a;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.model.Session;
import com.instabug.library.settings.SettingsManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import rx.functions.Action1;

@SuppressFBWarnings(value={"URF_UNREAD_FIELD", "DLS_DEAD_LOCAL_STORE", "DLS_DEAD_LOCAL_STORE"})
public class AnalyticsObserver {
    private static final String LAST_UPLOADED_AT = "analytics_last_uploaded";
    private static AnalyticsObserver INSTANCE;
    private Action1<Session.SessionState> sessionStateChangedAction;
    private LinkedHashMap<String, Api> loggingApisLinkedHashMap = new LinkedHashMap();
    private List<Api> sdkApisArrayList = Collections.synchronizedList(new ArrayList());

    public static AnalyticsObserver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AnalyticsObserver();
        }
        return INSTANCE;
    }

    private AnalyticsObserver() {
        this.sessionStateChangedAction = new Action1<Session.SessionState>(){

            public final /* synthetic */ void call(Object object) {
                Session.SessionState sessionState = (Session.SessionState)((Object)object);
                object = this;
                HandlerThread handlerThread = new HandlerThread("AnalyticsObserver");
                handlerThread.start();
                handlerThread = handlerThread.getLooper();
                handlerThread = new Handler((Looper)handlerThread);
                handlerThread.post(new Runnable(object, sessionState){
                    private /* synthetic */ Session.SessionState a;
                    private /* synthetic */ 1 b;
                    {
                        this.b = var1_1;
                        this.a = sessionState;
                    }

                    @Override
                    public final void run() {
                        this.b.AnalyticsObserver.this.handleAPIsUsageWithSessionStateChanged(this.a);
                        if (Instabug.getApplicationContext() != null) {
                            InstabugAnalyticsUploaderService.a(Instabug.getApplicationContext(), new Intent(Instabug.getApplicationContext(), InstabugAnalyticsUploaderService.class));
                        }
                    }
                });
            }
        };
        SessionStateEventBus.getInstance().subscribe(this.sessionStateChangedAction);
    }

    public void catchApiUsage(Api.Parameter ... parameterArray) {
        String string2 = this.getCallerMethodName();
        this.catchApiUsage(string2, false, parameterArray);
    }

    public void catchDeprecatedApiUsage(Api.Parameter ... parameterArray) {
        String string2 = this.getCallerMethodName();
        this.catchApiUsage(string2, true, parameterArray);
    }

    public void catchLoggingApiUsage(Api.Parameter ... parameterArray) {
        String string2 = this.getCallerMethodName();
        this.catchLoggingApiUsage(string2, false, parameterArray);
    }

    public void catchDeprecatedLoggingApiUsage(Api.Parameter ... parameterArray) {
        String string2 = this.getCallerMethodName();
        this.catchLoggingApiUsage(string2, true, parameterArray);
    }

    private void catchApiUsage(String string2, boolean bl, Api.Parameter ... parameterArray) {
        this.sdkApisArrayList.add(this.createApiUsageInfo(string2, bl, parameterArray));
    }

    private void catchLoggingApiUsage(String string2, boolean bl, Api.Parameter ... parameterArray) {
        if (this.loggingApisLinkedHashMap.containsKey(string2)) {
            Api api = this.loggingApisLinkedHashMap.get(string2);
            api.incrementCount();
            this.loggingApisLinkedHashMap.put(string2, api);
            return;
        }
        this.loggingApisLinkedHashMap.put(string2, this.createApiUsageInfo(string2, bl, parameterArray));
    }

    private Api createApiUsageInfo(String arrayList, boolean bl, Api.Parameter ... parameterArray) {
        Api api = new Api();
        api.setApiName((String)((Object)arrayList));
        api.setDeprecated(bl);
        arrayList = parameterArray != null ? new ArrayList<Api.Parameter>(Arrays.asList(parameterArray)) : new ArrayList();
        api.setParameters(arrayList);
        return api;
    }

    private String getCallerMethodName() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        return stackTraceElementArray[4].getMethodName();
    }

    private void handleAPIsUsageWithSessionStateChanged(Session.SessionState sessionState) {
        long l = SettingsManager.getInstance().getSessionStartedAt();
        if (sessionState == Session.SessionState.FINISH) {
            a.a(this.sdkApisArrayList, l);
            a.a(this.loggingApisLinkedHashMap.values(), l);
            this.sdkApisArrayList.clear();
            this.loggingApisLinkedHashMap.clear();
        }
    }

    public static long getLastUploadedAt(Context context) {
        context = context.getSharedPreferences("instabug", 0);
        return context.getLong(LAST_UPLOADED_AT, 0L);
    }

    public static void setLastUploadedAt(long l, Context context) {
        context = context.getSharedPreferences("instabug", 0);
        context.edit().putLong(LAST_UPLOADED_AT, l).apply();
    }
}

