/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.analytics;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.analytics.util.a;
import com.instabug.library.analytics.util.b;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.model.Session;
import com.instabug.library.settings.SettingsManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import rx.functions.Action1;

@SuppressFBWarnings(value={"URF_UNREAD_FIELD", "DLS_DEAD_LOCAL_STORE", "DLS_DEAD_LOCAL_STORE"})
public class AnalyticsObserver {
    private static final String LAST_UPLOADED_AT = "analytics_last_uploaded";
    private static AnalyticsObserver INSTANCE;
    private Action1<Session.SessionState> sessionStateChangedAction;
    private LinkedHashMap<String, Api> loggingApisLinkedHashMap = new LinkedHashMap();
    private List<Api> sdkApisArrayList = Collections.synchronizedList(new ArrayList());

    public static AnalyticsObserver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AnalyticsObserver();
        }
        return INSTANCE;
    }

    private AnalyticsObserver() {
        this.sessionStateChangedAction = new Action1<Session.SessionState>(){

            public void a(final Session.SessionState sessionState) {
                HandlerThread handlerThread = new HandlerThread("AnalyticsObserver");
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                Handler handler = new Handler(looper);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AnalyticsObserver.this.handleAPIsUsageWithSessionStateChanged(sessionState);
                        b.a();
                    }
                });
            }

            public /* synthetic */ void call(Object object) {
                this.a((Session.SessionState)((Object)object));
            }
        };
        SessionStateEventBus.getInstance().subscribe(this.sessionStateChangedAction);
    }

    public void catchApiUsage(Api.Parameter ... parameterArray) {
        String string2 = this.getCallerMethodName();
        this.catchApiUsage(string2, false, parameterArray);
    }

    public void catchDeprecatedApiUsage(Api.Parameter ... parameterArray) {
        String string2 = this.getCallerMethodName();
        this.catchApiUsage(string2, true, parameterArray);
    }

    public void catchLoggingApiUsage(Api.Parameter ... parameterArray) {
        String string2 = this.getCallerMethodName();
        this.catchLoggingApiUsage(string2, false, parameterArray);
    }

    public void catchDeprecatedLoggingApiUsage(Api.Parameter ... parameterArray) {
        String string2 = this.getCallerMethodName();
        this.catchLoggingApiUsage(string2, true, parameterArray);
    }

    private void catchApiUsage(String string2, boolean bl, Api.Parameter ... parameterArray) {
        this.sdkApisArrayList.add(this.createApiUsageInfo(string2, bl, parameterArray));
    }

    private void catchLoggingApiUsage(String string2, boolean bl, Api.Parameter ... parameterArray) {
        if (this.loggingApisLinkedHashMap.containsKey(string2)) {
            Api api = this.loggingApisLinkedHashMap.get(string2);
            api.incrementCount();
            this.loggingApisLinkedHashMap.put(string2, api);
        } else {
            this.loggingApisLinkedHashMap.put(string2, this.createApiUsageInfo(string2, bl, parameterArray));
        }
    }

    private Api createApiUsageInfo(String string2, boolean bl, Api.Parameter ... parameterArray) {
        Api api = new Api();
        api.setApiName(string2);
        api.setDeprecated(bl);
        ArrayList<Api.Parameter> arrayList = parameterArray != null ? new ArrayList<Api.Parameter>(Arrays.asList(parameterArray)) : new ArrayList();
        api.setParameters(arrayList);
        return api;
    }

    private String getCallerMethodName() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        return stackTraceElementArray[4].getMethodName();
    }

    private void handleAPIsUsageWithSessionStateChanged(Session.SessionState sessionState) {
        long l = SettingsManager.getInstance().getSessionStartedAt();
        if (sessionState == Session.SessionState.FINISH) {
            a.a(this.sdkApisArrayList, l);
            a.a(this.loggingApisLinkedHashMap.values(), l);
            this.sdkApisArrayList.clear();
            this.loggingApisLinkedHashMap.clear();
        }
    }

    public static long getLastUploadedAt(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("instabug", 0);
        return sharedPreferences.getLong(LAST_UPLOADED_AT, 0L);
    }

    public static void setLastUploadedAt(long l, Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("instabug", 0);
        sharedPreferences.edit().putLong(LAST_UPLOADED_AT, l).apply();
    }
}

