/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.media;

import android.media.MediaPlayer;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AudioPlayer {
    private String filePath;
    private MediaPlayer mediaPlayer;
    private b onGetDurationListener;
    private Map<String, OnStopListener> onStopListeners = new HashMap<String, OnStopListener>();
    private MediaPlayer.OnCompletionListener onCompletionListener;

    private void prepare(final a a2) {
        try {
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setDataSource(this.filePath);
            this.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mediaPlayer) {
                    AudioPlayer.this.doAction(a2);
                }
            });
            this.mediaPlayer.prepareAsync();
            if (this.onCompletionListener != null) {
                this.mediaPlayer.setOnCompletionListener(this.onCompletionListener);
            }
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(this, "Playing audio file failed", iOException);
        }
    }

    public void addOnStopListener(OnStopListener onStopListener) {
        this.onStopListeners.put(onStopListener.getFilePath(), onStopListener);
        if (this.onCompletionListener == null) {
            this.onCompletionListener = new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mediaPlayer) {
                    AudioPlayer.this.notifyOnStopListeners();
                }
            };
            if (this.mediaPlayer != null) {
                this.mediaPlayer.setOnCompletionListener(this.onCompletionListener);
            }
        }
    }

    private void notifyOnStopListeners() {
        for (OnStopListener onStopListener : this.onStopListeners.values()) {
            onStopListener.onStop();
        }
    }

    private void stream(String string2, a a2) {
        if (string2 == null) {
            InstabugSDKLogger.e(this, "Audio file path can not be null");
            return;
        }
        if (string2.equals(this.filePath)) {
            this.doAction(a2);
        } else {
            this.filePath = string2;
            this.prepare(a2);
        }
    }

    public void getDurationAsync(String string2, b b2) {
        this.stream(string2, a.c);
        this.onGetDurationListener = b2;
    }

    public void start(String string2) {
        this.pause();
        this.stream(string2, a.a);
    }

    public void pause() {
        this.notifyOnStopListeners();
        this.doAction(a.b);
    }

    public void release() {
        this.filePath = null;
        if (this.mediaPlayer != null) {
            if (this.mediaPlayer.isPlaying()) {
                this.mediaPlayer.stop();
            }
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }

    private void doAction(a a2) {
        switch (a2) {
            case a: {
                if (this.mediaPlayer.isPlaying()) break;
                this.mediaPlayer.start();
                break;
            }
            case b: {
                if (this.mediaPlayer == null || !this.mediaPlayer.isPlaying()) break;
                this.mediaPlayer.pause();
                break;
            }
            case c: {
                this.onGetDurationListener.a(this.mediaPlayer.getDuration());
            }
        }
    }

    public static String getFormattedDurationText(long l) {
        int n = 3600000;
        int n2 = 60000;
        int n3 = 1000;
        int n4 = (int)(l / 3600000L);
        int n5 = (int)(l % 3600000L / 60000L);
        int n6 = (int)(l % 60000L / 1000L);
        if (n4 > 0) {
            return String.format("%02d:%02d:%02d", n4, n5, n6);
        }
        return String.format("%02d:%02d", n5, n6);
    }

    public static abstract class OnStopListener {
        private String filePath;

        public String getFilePath() {
            return this.filePath;
        }

        public OnStopListener(String string2) {
            this.filePath = string2;
        }

        public abstract void onStop();
    }

    public static interface b {
        public void a(int var1);
    }

    static enum a {
        a,
        b,
        c;

    }
}

