/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.screenshot;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import com.instabug.library.R;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.invocation.b;
import com.instabug.library.screenshot.a;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugSDKLogger;
import rx.Subscription;
import rx.functions.Action1;

public class ExtraScreenshotHelper {
    private ImageButton captureButton;
    private boolean isCaptureButtonShown = false;
    private Subscription currentActivityLifeCycleSubscription;
    private OnCaptureListener onCaptureListener;

    public void init(OnCaptureListener onCaptureListener) {
        this.onCaptureListener = onCaptureListener;
        this.subscribeToCurranActivityLifeCycle();
        b.c().h();
    }

    public void release() {
        this.captureButton = null;
        this.onCaptureListener = null;
        if (this.currentActivityLifeCycleSubscription != null && !this.currentActivityLifeCycleSubscription.isUnsubscribed()) {
            this.currentActivityLifeCycleSubscription.unsubscribe();
        }
        b.c().i();
    }

    private void show(final @NonNull Activity activity) {
        if (this.isCaptureButtonShown) {
            InstabugSDKLogger.v(this, "bar already shown");
            return;
        }
        this.captureButton = this.createCaptureButton(activity);
        activity.getWindow().addContentView((View)this.captureButton, (ViewGroup.LayoutParams)this.createCaptureButtonContainer(activity));
        this.isCaptureButtonShown = true;
        this.captureButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ExtraScreenshotHelper.this.hide();
                ExtraScreenshotHelper.this.captureExtraScreenshot(activity, ExtraScreenshotHelper.this.onCaptureListener);
            }
        });
    }

    private ImageButton createCaptureButton(Activity activity) {
        ImageButton imageButton = new ImageButton((Context)activity);
        imageButton.setId(R.id.instabug_extra_screenshot_button);
        imageButton.setScaleType(ImageView.ScaleType.CENTER);
        imageButton.setBackgroundDrawable(Colorizer.getPrimaryColorTintedDrawable(ContextCompat.getDrawable((Context)activity, (int)R.drawable.instabug_bg_white_oval)));
        imageButton.setImageResource(R.drawable.instabug_ic_capture_screenshot);
        return imageButton;
    }

    private FrameLayout.LayoutParams createCaptureButtonContainer(Activity activity) {
        View view;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 81);
        layoutParams.setMargins(0, 0, 0, 20);
        Resources resources = activity.getResources();
        if (Build.VERSION.SDK_INT >= 21 && this.hasNavBar(resources) && (view = activity.findViewById(16908336)) == null) {
            layoutParams.bottomMargin += this.getNavigationBarHeight(resources);
        }
        return layoutParams;
    }

    private void captureExtraScreenshot(final Activity activity, final OnCaptureListener onCaptureListener) {
        a.a(activity, new a.a(){

            @Override
            public void a(Bitmap bitmap) {
                BitmapUtils.saveBitmap(bitmap, (Context)activity, new BitmapUtils.a(){

                    @Override
                    public void a(Uri uri) {
                        onCaptureListener.onExtraScreenshotCaptured(uri);
                    }

                    @Override
                    public void a(Throwable throwable) {
                        InstabugSDKLogger.e(ExtraScreenshotHelper.class, throwable.getMessage(), throwable);
                    }
                });
            }

            @Override
            public void a(Throwable throwable) {
                InstabugSDKLogger.e(ExtraScreenshotHelper.class, throwable.getMessage(), throwable);
            }
        });
    }

    private void hide() {
        if (this.isCaptureButtonShown && this.captureButton != null && this.captureButton.getParent() != null && this.captureButton.getParent() instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)this.captureButton.getParent();
            viewGroup.removeView((View)this.captureButton);
            this.isCaptureButtonShown = false;
        }
    }

    private void subscribeToCurranActivityLifeCycle() {
        this.currentActivityLifeCycleSubscription = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Action1<ActivityLifeCycleEvent>(){

            public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                switch (activityLifeCycleEvent) {
                    case RESUMED: {
                        ExtraScreenshotHelper.this.handleCurrentActivityResumeEvent();
                        break;
                    }
                    case PAUSED: {
                        ExtraScreenshotHelper.this.handleCurrentActivityPauseEvent();
                        break;
                    }
                }
            }

            public /* synthetic */ void call(Object object) {
                this.a((ActivityLifeCycleEvent)((Object)object));
            }
        });
    }

    private void handleCurrentActivityResumeEvent() {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            this.show(activity);
        } else {
            InstabugSDKLogger.v(ExtraScreenshotHelper.class, "current activity equal null");
        }
    }

    private void handleCurrentActivityPauseEvent() {
        this.hide();
    }

    private int getNavigationBarHeight(Resources resources) {
        int n = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (n > 0) {
            return resources.getDimensionPixelSize(n);
        }
        return 0;
    }

    private boolean hasNavBar(Resources resources) {
        int n = resources.getIdentifier("config_showNavigationBar", "bool", "android");
        return n > 0 && resources.getBoolean(n);
    }

    public static interface OnCaptureListener {
        public void onExtraScreenshotCaptured(Uri var1);
    }
}

