/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class InstabugDateFormatter {
    public static long getCurrentUTCTimeStampInSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long getCurrentUTCTimeStampInMiliSeconds() {
        return System.currentTimeMillis();
    }

    public static String getCurrentDateAsString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String formatUTCDate(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2 * 1000L);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String convertUnixTimeToFormattedDate(long l2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(InstabugDateFormatter.convertUnixTimeToDate(l2));
    }

    public static Date convertUnixTimeToDate(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        return calendar.getTime();
    }

    public static String formatMessageDate(long l2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM HH:mm", Locale.US);
        return simpleDateFormat.format(l2 * 1000L);
    }

    public static String formatConversationLastMessageDate(long l2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM", Locale.US);
        return simpleDateFormat.format(l2 * 1000L);
    }

    public static Date getDate(String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            Date date = simpleDateFormat.parse(string2);
            return date;
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }
}

