package com.instabug.library.util

import kotlin.experimental.and
import kotlin.experimental.inv
import kotlin.experimental.or

fun Byte.addFlag(other: Byte): Byte = this or other
fun Byte.removeFlag(other: Byte): Byte = this and other.inv()
fun Byte.hasFlag(other: Byte): Boolean = this and other == other

fun Int.addFlag(other: Int): Int = this or other
fun Int.removeFlag(other: Int): Int = this and other.inv()
fun Int.hasFlag(other: Int): Boolean = this and other == other
