package com.instabug.library.sessionreplay.networkLog

import com.instabug.library.map.Mapper
import com.instabug.library.networkinterception.model.NetworkLogModel
import com.instabug.library.sessionreplay.model.SRLog
import com.instabug.library.sessionreplay.model.SRLogType
import org.json.JSONObject

class SRNetworkLog(
    networkLogModel: NetworkLogModel,
    mapper: Mapper<NetworkLogModel, JSONObject?>
) : SRLog {

    private val logJSONObject: JSONObject? by lazy {
        mapper.map(networkLogModel)
    }

    override val timestamp = networkLogModel.startTimestampMs
    override val logType: String = SRLogType.NETWORK_LOG
    override val srJsonRep: JSONObject?
        get() = logJSONObject
}
