package com.instabug.library.sessionprofiler.model.timeline;

import android.annotation.SuppressLint;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;

import androidx.annotation.Nullable;

/**
 * Created by tarek on 3/4/18.
 */

public abstract class TimelinePoint implements Serializable {

    protected final static String KEY_TIME = "t";
    protected final static String KEY_VALUE = "v";

    private double time;

    public double getTime() {
        return time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    JSONObject getTimelinePointJSONObject(@Nullable Object value) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(KEY_TIME, time);
        jsonObject.put(KEY_VALUE, value);
        return jsonObject;
    }

    abstract JSONObject toJSONObject() throws JSONException;

    public static JSONArray toJSONArray(Collection<TimelinePoint> timelinePoints) throws
            JSONException {
        JSONArray jsonArray = new JSONArray();

        ConcurrentLinkedQueue<TimelinePoint> timelinePointsAsQueue =
                timelinePoints instanceof ConcurrentLinkedQueue
                        ? (ConcurrentLinkedQueue<TimelinePoint>) timelinePoints
                        : new ConcurrentLinkedQueue<>(timelinePoints);

        for (TimelinePoint point : timelinePointsAsQueue) {
            if (point != null) {
                jsonArray.put(point.toJSONObject());
            }
        }

        return jsonArray;
    }
}
