package com.instabug.library.sessionV3.di

import android.content.Context
import com.instabug.library.Instabug
import com.instabug.library.InstabugNetworkJob
import com.instabug.library.core.eventbus.V3SessionSyncResultEventBus
import com.instabug.library.core.plugin.PluginsExtractor
import com.instabug.library.core.plugin.PluginsExtractorImpl
import com.instabug.library.featuresflags.di.FeaturesFlagServiceLocator
import com.instabug.library.internal.storage.cache.dbv2.IBGDbManager
import com.instabug.library.map.Mapper
import com.instabug.library.model.v3Session.PreferencesKeys
import com.instabug.library.networkv2.INetworkManager
import com.instabug.library.networkv2.NetworkManager
import com.instabug.library.networkv2.limitation.RateLimitationSettingsImpl
import com.instabug.library.networkv2.limitation.RateLimitedFeature
import com.instabug.library.networkv2.limitation.RateLimiter
import com.instabug.library.sessionV3.cache.SessionCacheManager
import com.instabug.library.sessionV3.cache.SessionCacheManagerImpl
import com.instabug.library.sessionV3.cache.SessionFeaturesFlagsCacheManager
import com.instabug.library.sessionV3.cache.SessionFeaturesFlagsCacheManagerImpl
import com.instabug.library.sessionV3.configurations.IBGConfigurationsHandler
import com.instabug.library.sessionV3.configurations.IBGSessionConfigurations
import com.instabug.library.sessionV3.configurations.IBGSessionConfigurationsHandlerImpl
import com.instabug.library.sessionV3.configurations.IBGSessionConfigurationsImpl
import com.instabug.library.sessionV3.configurations.IBGSessionCrashesConfigurations
import com.instabug.library.sessionV3.configurations.RatingDialogDetectionConfigurations
import com.instabug.library.sessionV3.configurations.RatingDialogDetectionConfigurationsImpl
import com.instabug.library.sessionV3.manager.IBGSessionStateManager
import com.instabug.library.sessionV3.manager.IBGSessionStateManagerImpl
import com.instabug.library.sessionV3.manager.SessionStitchingManger
import com.instabug.library.sessionV3.manager.SessionStitchingMangerImpl
import com.instabug.library.sessionV3.providers.BackgroundStateProvider
import com.instabug.library.sessionV3.providers.BackgroundStateProviderImpl
import com.instabug.library.sessionV3.providers.IBGSessionDataProvider
import com.instabug.library.sessionV3.providers.SessionDataProvider
import com.instabug.library.sessionV3.ratingDialogDetection.KeyboardDurationDetector
import com.instabug.library.sessionV3.ratingDialogDetection.KeyboardDurationDetectorImpl
import com.instabug.library.sessionV3.ratingDialogDetection.KeyboardEventListenerProviderImpl
import com.instabug.library.sessionV3.ratingDialogDetection.ManualRatingDetector
import com.instabug.library.sessionV3.ratingDialogDetection.ManualRatingDetectorImpl
import com.instabug.library.sessionV3.ratingDialogDetection.RatingDetectionDataMapper
import com.instabug.library.sessionV3.ratingDialogDetection.RatingDialogData
import com.instabug.library.sessionV3.ratingDialogDetection.RatingDialogDetector
import com.instabug.library.sessionV3.ratingDialogDetection.RatingDialogDetectorImpl
import com.instabug.library.sessionV3.sync.IBGSessionBatchEvaluator
import com.instabug.library.sessionV3.sync.IBGSessionBatchEvaluatorImpl
import com.instabug.library.sessionV3.sync.IBGSessionMerger
import com.instabug.library.sessionV3.sync.IBGSessionMergerImpl
import com.instabug.library.sessionV3.sync.IBGSessionsSyncJob
import com.instabug.library.sessionV3.sync.IBGSessionsSyncManager
import com.instabug.library.sessionV3.sync.IBGSessionsSyncMangerImpl
import com.instabug.library.sessionV3.sync.RateDetectionFilter
import com.instabug.library.sessionV3.sync.SessionBatchingFilter
import com.instabug.library.sessionV3.sync.SessionDataControllerImpl
import com.instabug.library.sessionreplay.SRStateChangeListener
import com.instabug.library.sessionreplay.di.SessionReplayServiceLocator
import com.instabug.library.util.threading.PoolProvider
import java.lang.ref.WeakReference
import java.util.concurrent.Executor

object IBGSessionServiceLocator {
    val srEnabled: Boolean
        get() = SessionReplayServiceLocator.srConfigurationsProvider.srEnabled

    @JvmStatic
    val pluginsExtractor: PluginsExtractor
        get() = PluginsExtractorImpl
    private val instancesMap by lazy { hashMapOf<String, WeakReference<Any>>() }
    val networkManager: INetworkManager
        get() = NetworkManager.newInstance()
    val database: IBGDbManager
        get() = IBGDbManager.getInstance()

    @JvmStatic
    val sessionCacheManger: SessionCacheManager
        get() = SessionCacheManagerImpl
    val featuresFlagsCacheManager: SessionFeaturesFlagsCacheManager
        get() = SessionFeaturesFlagsCacheManagerImpl(
            FeaturesFlagServiceLocator.featureFlagsManager,
            database
        )
    val sessionDataController
        get() = SessionDataControllerImpl

    @JvmStatic
    val sessionDataProvider: IBGSessionDataProvider
        get() = SessionDataProvider
    val sessionExecutor: Executor
        get() = PoolProvider.getSessionExecutor()

    @JvmStatic
    val sessionConfigurations: IBGSessionConfigurations
        get() = IBGSessionConfigurationsImpl

    @JvmStatic
    val sessionCrashesConfigurations: IBGSessionCrashesConfigurations
        get() = IBGSessionConfigurationsImpl
    val backgroundStateProvider: BackgroundStateProvider
        get() = BackgroundStateProviderImpl
    val stitchingManger: SessionStitchingManger
        get() = SessionStitchingMangerImpl
    val sessionMerger: IBGSessionMerger
        get() = IBGSessionMergerImpl
    val syncJob: InstabugNetworkJob
        get() = IBGSessionsSyncJob

    @JvmStatic
    val syncManger: IBGSessionsSyncManager
        get() = IBGSessionsSyncMangerImpl

    @JvmStatic
    val configurationsHandler: IBGConfigurationsHandler
        get() = IBGSessionConfigurationsHandlerImpl

    @JvmStatic
    val batchEvaluator: IBGSessionBatchEvaluator
        get() = IBGSessionBatchEvaluatorImpl

    @JvmStatic
    val stateManager: IBGSessionStateManager
        get() = IBGSessionStateManagerImpl

    val durationSharedPreferences
        get() = Instabug.getApplicationContext()
            ?.getSharedPreferences(PreferencesKeys.DURATION_PREF_NAME, Context.MODE_PRIVATE)

    val ratingDetectionMapper: Mapper<RatingDialogData, String>
        get() = RatingDetectionDataMapper()

    val ratingDialogDetectionConfigs: RatingDialogDetectionConfigurations
        get() = RatingDialogDetectionConfigurationsImpl

    private val keyboardDurationDetector: KeyboardDurationDetector
        get() = KeyboardDurationDetectorImpl(KeyboardEventListenerProviderImpl())

    val ratingDialogDetector: RatingDialogDetector by lazy {
        RatingDialogDetectorImpl(
            sessionExecutor,
            sessionDataProvider,
            keyboardDurationDetector,
            ratingDialogDetectionConfigs,
            sessionConfigurations
        )
    }

    @JvmStatic
    val manualRatingDetector: ManualRatingDetector by lazy {
        ManualRatingDetectorImpl(
            sessionDataProvider,
            ratingDialogDetectionConfigs,
            sessionConfigurations,
            sessionExecutor
        )
    }
    val rateDetectionBatchingFilter: SessionBatchingFilter by lazy {
        RateDetectionFilter(sessionCacheManger)
    }

    @Suppress("UNCHECKED_CAST")
    fun rateLimiter(onLimited: (List<String>) -> Unit): RateLimiter<List<String>, RateLimitationSettingsImpl> =
        instancesMap[RateLimiter::class.java.name]
            ?.get()
            ?.let { rateLimiter -> rateLimiter as RateLimiter<List<String>, RateLimitationSettingsImpl> }
            ?: RateLimiter(
                settings = RateLimitationSettingsImpl(RateLimitedFeature.V3_SESSION),
                onLimitationApplied = onLimited,
                feature = RateLimitedFeature.V3_SESSION
            ).also { instancesMap[RateLimiter::class.java.name] = WeakReference(it) }

    @Synchronized
    fun registerSrConfigurationChangedListener(srConfigurationChangeListener: SRStateChangeListener) {
        SessionReplayServiceLocator.stateListenersRegistry
            .register(srConfigurationChangeListener)
    }

    val v3SessionSyncResultEventBus: V3SessionSyncResultEventBus
        get() = V3SessionSyncResultEventBus

}
