package com.instabug.library.sanitize

import com.instabug.library.util.extenstions.runOrLogError

fun interface Sanitizer<T> {
    fun sanitize(item: T): T?
}

/**
 * Composite sanitizer that chains the output of a sanitizer to the input of the proceeding
 * sanitizer and the final result is returned, it will break whenever null value is reached
 */
class CompositeSanitizer<T> : Sanitizer<T> {

    private val sanitizers: MutableList<Sanitizer<T>> = mutableListOf()

    fun addSanitizer(sanitizer: Sanitizer<T>?) {
        sanitizer?.let(sanitizers::add)
    }

    override fun sanitize(item: T): T? =
        runOrLogError {
            sanitizers.fold(item as T?) { accumulated, sanitizer ->
                accumulated?.let { sanitizer.sanitize(it) } ?: return@fold null
            }
        }.getOrNull()
}
