package com.instabug.library.networkv2.service.userattributes;

import androidx.annotation.Nullable;

import com.instabug.library.Constants;
import com.instabug.library.model.UserAttribute;
import com.instabug.library.model.UserAttributes;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Endpoints;
import com.instabug.library.networkv2.request.Header;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestMethod;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.networkv2.request.RequestType;

import org.json.JSONException;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class AttributesDataMapper {

    private AttributesDataMapper() {
    }

    public static Request toRequest(String email, @Nullable String hash) {

        Request.Builder requestBuilder = new Request.Builder()
                .endpoint(Endpoints.USER_ATTRIBUTES)
                .type(RequestType.NORMAL)
                .method(RequestMethod.GET)
                .addParameter(new RequestParameter(Constants.NetworkParam.EMAIL, email));
        if (hash != null) {
            requestBuilder.addHeader(new RequestParameter(Header.IF_MATCH, hash));
        }

        return requestBuilder.build();
    }

    static List<UserAttribute> toUserAttributeList(Map<String, String> map) {
        List<UserAttribute> attributes = new ArrayList<>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            UserAttribute attribute = new UserAttribute.Builder(entry.getKey(), entry.getValue())
                    .build();
            attributes.add(attribute);
        }
        return attributes;
    }

    static String toJson(RequestResponse response) {
        return (response == null || response.getResponseBody() == null) ? "{}"
                : (String) response.getResponseBody();
    }

    static UserAttributes toUserAttributes(String json) throws JSONException {
        UserAttributes userAttributes = new UserAttributes();
        userAttributes.fromJson(json);
        return userAttributes;
    }
}
