package com.instabug.library.networkv2.service.synclogs;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

public class SyncLogKeyProvider implements ISyncKeyProvider {

    static {
        try {
            System.loadLibrary("ibg-native");
        } catch (UnsatisfiedLinkError e) {
            // to pass unit tests only.
        }
    }


    static native String getNativeMatchingUuidPrefix();

    static native String getNativeMatchingUuidSuffix();

    static native String getNativeMatchingEmailPrefix();

    static native String getNativeMatchingEmailSuffix();

    static native String getNativeSyncingUuidPrefix();

    static native String getNativeSyncingUuidSuffix();

    static native String getNativeSyncingEmailPrefix();

    static native String getNativeSyncingEmailSuffix();


    @Override
    public String getMatchingUuidPrefix() {
        try {
            return getNativeMatchingUuidPrefix();
        } catch (UnsatisfiedLinkError e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Error loading native method", e);
            return "";
        }
    }

    @Override
    public String getMatchingUuidSuffix() {
        try {
            return getNativeMatchingUuidSuffix();
        } catch (UnsatisfiedLinkError e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Error loading native method", e);
            return "";
        }
    }

    @Override
    public String getMatchingEmailPrefix() {
        try {
            return getNativeMatchingEmailPrefix();
        } catch (UnsatisfiedLinkError e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Error loading native method", e);
            return "";
        }
    }

    @Override
    public String getMatchingEmailSuffix() {

        try {
            return getNativeMatchingEmailSuffix();
        } catch (UnsatisfiedLinkError e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Error loading native method", e);
            return "";
        }
    }

    @Override
    public String getSyncingUuidPrefix() {
        try {
            return getNativeSyncingUuidPrefix();
        } catch (UnsatisfiedLinkError e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Error loading native method", e);
            return "";
        }
    }

    @Override
    public String getSyncingUuidSuffix() {
        try {
            return getNativeSyncingUuidSuffix();
        } catch (UnsatisfiedLinkError e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Error loading native method", e);
            return "";
        }
    }

    @Override
    public String getSyncingEmailPrefix() {
        try {
            return getNativeSyncingEmailPrefix();
        } catch (UnsatisfiedLinkError e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Error loading native method", e);
            return "";
        }
    }

    @Override
    public String getSyncingEmailSuffix() {
        try {
            return getNativeSyncingEmailSuffix();
        } catch (UnsatisfiedLinkError e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Error loading native method", e);
            return "";
        }
    }
}
