package com.instabug.library.networkv2.service.base;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.request.Request;

/**
 * Base service for all network services.
 */
public class BaseService {


    @NonNull
    private final NetworkManager networkManager;
    @NonNull
    private final BaseScheduler scheduler;
    @Nullable
    private final Request.Callbacks callbacks;

    protected BaseService(@NonNull NetworkManager networkManager,
                          @NonNull BaseScheduler scheduler,
                          @Nullable Request.Callbacks callbacks) {

        this.networkManager = networkManager;
        this.scheduler = scheduler;
        this.callbacks = callbacks;
    }

    @NonNull
    public BaseScheduler getScheduler() {
        return scheduler;
    }

    @NonNull
    public NetworkManager getNetworkManager() {
        return networkManager;
    }

    @Nullable
    public Request.Callbacks getCallbacks() {
        return callbacks;
    }
}
