package com.instabug.library.networkinterception.urlconnection.delegate.validate

import com.instabug.library.networkinterception.config.IBGNetworkInterceptionConfigurationProvider
import com.instabug.library.networkinterception.config.V2InterceptorFlags.Companion.RESPONSE_BODY_COLLECTION_ENABLED
import com.instabug.library.networkinterception.delegate.validate.NetworkLogBodyValidator
import com.instabug.library.util.hasFlag

class UrlConnectionResponseBodyValidator(
    private val delegate: NetworkLogBodyValidator,
    private val configurations: IBGNetworkInterceptionConfigurationProvider
) : NetworkLogBodyValidator {

    override fun invoke(headers: Map<String, String>, contentLength: Long): Pair<Boolean, String?> =
        delegate.takeIf { responseBodyCollectionEnabled }
            ?.invoke(headers, contentLength) ?: (false to null)

    private val responseBodyCollectionEnabled
        get() = configurations.v2UrlConnectionInterceptorBEState
            .hasFlag(RESPONSE_BODY_COLLECTION_ENABLED)
}
