package com.instabug.library.networkinterception.urlconnection.delegate.validate

import com.instabug.library.networkinterception.config.IBGNetworkInterceptionConfigurationProvider
import com.instabug.library.networkinterception.config.V2InterceptorFlags.Companion.REQUEST_BODY_COLLECTION_ENABLED
import com.instabug.library.networkinterception.delegate.validate.NetworkLogBodyValidator
import com.instabug.library.util.hasFlag

class UrlConnectionRequestBodyValidator(
    private val delegate: NetworkLogBodyValidator,
    private val configurations: IBGNetworkInterceptionConfigurationProvider
) : NetworkLogBodyValidator {

    override fun invoke(headers: Map<String, String>, contentLength: Long): Pair<Boolean, String?> =
        delegate.takeIf { requestBodyCollectionEnabled }
            ?.invoke(headers, contentLength) ?: (false to null)

    private val requestBodyCollectionEnabled
        get() = configurations.v2UrlConnectionInterceptorBEState
            .hasFlag(REQUEST_BODY_COLLECTION_ENABLED)
}
