package com.instabug.library.networkinterception.urlconnection.delegate

import com.instabug.library.internal.servicelocator.Provider
import com.instabug.library.networkinterception.NetworkInterceptionServiceLocator
import com.instabug.library.networkinterception.delegate.NetworkInterceptorDelegate
import com.instabug.library.util.extenstions.runOrLogError
import java.io.InputStream
import java.io.OutputStream

class UrlConnectionInterceptorDelegateProvider :
    Provider<NetworkInterceptorDelegate<OutputStream, InputStream>?> {

    override fun invoke(): NetworkInterceptorDelegate<OutputStream, InputStream>? =
        runOrLogError {
            if (isV2UrlConnectionInterceptionEnabled()) {
                NetworkInterceptionServiceLocator.urlConnectionInterceptorDelegate
            } else {
                null
            }
        }.getOrNull()

    private fun isV2UrlConnectionInterceptionEnabled(): Boolean =
        with(NetworkInterceptionServiceLocator.configurationProvider) {
            v2UrlConnectionInterceptorBEState.isV2InterceptorEnabled()
        }
}
