package com.instabug.library.networkinterception.urlconnection;

import android.annotation.SuppressLint;
import android.os.Build;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import java.util.List;
import java.util.Map;

/**
 * {@link HttpURLConnection} decorator that collects network log data
 * Suppressed lint null checks are made so because {@link HttpURLConnection} does not specify nullability
 * which falls back to default Non-Null, while the documentation specifies otherwise
 * and since we have a kotlin interceptor layer between our decorator and the original UrlConnection
 * the Kotlin interceptor declares everything as nullable to avoid runtime crashes when the original
 * UrlConnection returns null
 * (IBGHttpUrlConnection -> HttpUrlConnectionInterceptor -> HttpUrlConnection)
 */
public class IBGHttpUrlConnection extends HttpURLConnection {

    private final HttpUrlConnectionInterceptor<HttpURLConnection> interceptor;

    @SuppressLint("PARAMETER_NOT_NULLABLE")
    public IBGHttpUrlConnection(HttpUrlConnectionInterceptor<HttpURLConnection> interceptor) {
        super(interceptor.getURL());
        this.interceptor = interceptor;
    }


    @Override
    public void disconnect() {
        interceptor.disconnect();
    }

    @Override
    public boolean usingProxy() {
        return interceptor.usingProxy();
    }

    @Override
    public void connect() throws IOException {
        interceptor.connect();
    }

    @Override
    public void setConnectTimeout(int timeout) {
        interceptor.setConnectTimeout(timeout);
    }

    @Override
    public int getConnectTimeout() {
        return interceptor.getConnectTimeout();
    }

    @Override
    public void setReadTimeout(int timeout) {
        interceptor.setReadTimeout(timeout);
    }

    @Override
    public int getReadTimeout() {
        return interceptor.getReadTimeout();
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public URL getURL() {
        return interceptor.getURL();
    }

    @Override
    public int getContentLength() {
        return interceptor.getContentLength();
    }

    @RequiresApi(api = Build.VERSION_CODES.N)
    @Override
    public long getContentLengthLong() {
        return interceptor.getContentLengthLong();
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public String getContentType() {
        return interceptor.getContentType();
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public String getContentEncoding() {
        return interceptor.getContentEncoding();
    }

    @Override
    public long getExpiration() {
        return interceptor.getExpiration();
    }

    @Override
    public long getDate() {
        return interceptor.getDate();
    }

    @Override
    public long getLastModified() {
        return interceptor.getLastModified();
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public String getHeaderField(String name) {
        return interceptor.getHeaderField(name);
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public Map<String, List<String>> getHeaderFields() {
        return interceptor.getHeaderFields();
    }

    @Override
    public int getHeaderFieldInt(String name, int def) {
        return interceptor.getHeaderFieldInt(name, def);
    }

    @RequiresApi(api = Build.VERSION_CODES.N)
    @Override
    public long getHeaderFieldLong(String name, long def) {
        return interceptor.getHeaderFieldLong(name, def);
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public String getHeaderFieldKey(int n) {
        return interceptor.getHeaderFieldKey(n);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        interceptor.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setFixedLengthStreamingMode(long contentLength) {
        interceptor.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setChunkedStreamingMode(int chunkLen) {
        interceptor.setChunkedStreamingMode(chunkLen);
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public String getHeaderField(int n) {
        return interceptor.getHeaderField(n);
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public Object getContent() throws IOException {
        return interceptor.getContent();
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public Object getContent(Class[] classes) throws IOException {
        return interceptor.getContent(classes);
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        interceptor.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return interceptor.getInstanceFollowRedirects();
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        interceptor.setRequestMethod(method);
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public String getRequestMethod() {
        return interceptor.getRequestMethod();
    }

    @Override
    public int getResponseCode() throws IOException {
        return interceptor.getResponseCode();
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public String getResponseMessage() throws IOException {
        return interceptor.getResponseMessage();
    }

    @Override
    public long getHeaderFieldDate(String name, long def) {
        return interceptor.getHeaderFieldDate(name, def);
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public Permission getPermission() throws IOException {
        return interceptor.getPermission();
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public InputStream getInputStream() throws IOException {
        return interceptor.getInputStream();
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public OutputStream getOutputStream() throws IOException {
        return interceptor.getOutputStream();
    }

    @NonNull
    @Override
    public String toString() {
        return interceptor.toString();
    }

    @Override
    public void setDoInput(boolean doInput) {
        interceptor.setDoInput(doInput);
    }

    @Override
    public boolean getDoInput() {
        return interceptor.getDoInput();
    }

    @Override
    public void setDoOutput(boolean doOutput) {
        interceptor.setDoOutput(doOutput);
    }

    @Override
    public boolean getDoOutput() {
        return interceptor.getDoOutput();
    }

    @Override
    public void setAllowUserInteraction(boolean allowUserInteraction) {
        interceptor.setAllowUserInteraction(allowUserInteraction);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return interceptor.getAllowUserInteraction();
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        interceptor.setUseCaches(useCaches);
    }

    @Override
    public boolean getUseCaches() {
        return interceptor.getUseCaches();
    }

    @Override
    public void setIfModifiedSince(long ifModifiedSince) {
        interceptor.setIfModifiedSince(ifModifiedSince);
    }

    @Override
    public long getIfModifiedSince() {
        return interceptor.getIfModifiedSince();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return interceptor.getDefaultUseCaches();
    }

    @Override
    public void setDefaultUseCaches(boolean defaultUseCaches) {
        interceptor.setDefaultUseCaches(defaultUseCaches);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        interceptor.setRequestProperty(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        interceptor.addRequestProperty(key, value);
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public String getRequestProperty(String key) {
        return interceptor.getRequestProperty(key);
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public Map<String, List<String>> getRequestProperties() {
        return interceptor.getRequestProperties();
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public InputStream getErrorStream() {
        return interceptor.getErrorStream();
    }
}
