package com.instabug.library.networkinterception.urlconnection

import com.instabug.library.networkinterception.NetworkLogProcessor
import com.instabug.library.networkinterception.delegate.NetworkInterceptorDelegate
import java.io.InputStream
import java.io.OutputStream
import java.net.URL
import java.security.Principal
import java.security.cert.Certificate
import javax.net.ssl.HostnameVerifier
import javax.net.ssl.HttpsURLConnection
import javax.net.ssl.SSLSocketFactory

class HttpsUrlConnectionInterceptor(
    url: URL,
    connectionDelegate: HttpsURLConnection,
    interceptorDelegate: NetworkInterceptorDelegate<OutputStream, InputStream>,
    processor: NetworkLogProcessor
) : HttpUrlConnectionInterceptor<HttpsURLConnection>(
    url,
    connectionDelegate,
    interceptorDelegate,
    processor
) {

    fun getCipherSuite(): String? = connectionDelegate.cipherSuite

    fun getLocalCertificates(): Array<Certificate?>? = connectionDelegate.localCertificates

    fun getServerCertificates(): Array<Certificate?>? = connectionDelegate.serverCertificates

    fun getPeerPrincipal(): Principal? = connectionDelegate.getPeerPrincipal()

    fun getLocalPrincipal(): Principal? = connectionDelegate.getLocalPrincipal()

    fun setHostnameVerifier(v: HostnameVerifier?) = connectionDelegate.setHostnameVerifier(v)

    fun getHostnameVerifier(): HostnameVerifier? = connectionDelegate.hostnameVerifier

    fun setSSLSocketFactory(sf: SSLSocketFactory?) = connectionDelegate.setSSLSocketFactory(sf)

    fun getSSLSocketFactory(): SSLSocketFactory? = connectionDelegate.sslSocketFactory
}
